/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.utils.MutableInteger;
import java.util.ArrayList;
import java.util.Arrays;

public final class ByteUtils {
    private static int result_i;
    private static byte[] _datas;

    static {
        _datas = new byte[0];
    }

    private ByteUtils() {
    }

    public static byte[] swap(byte[] data, int wordSize) {
        if (wordSize == 1) {
            return data;
        }
        int remainder = data.length % wordSize;
        if (remainder != 0) {
            _datas = new byte[data.length + (wordSize - remainder)];
            System.arraycopy(data, 0, _datas, 0, data.length);
            data = _datas;
        }
        byte[] result = new byte[data.length];
        int iters = data.length / wordSize;
        result_i = 0;
        int i = 0;
        while (i < iters) {
            int base = i * wordSize;
            int j = wordSize - 1;
            while (j >= 0) {
                result[ByteUtils.result_i++] = data[base + j];
                --j;
            }
            ++i;
        }
        return result;
    }

    public static boolean isAscii(byte[] data) {
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (!(b >= 32 && b <= 126 || Character.isWhitespace(b))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static byte[][] splitIntoPowersOf2Chunks(byte[] data, int maxChunkSize) {
        int i = 0;
        int chunkSize = maxChunkSize;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        while (i < data.length) {
            if (i + chunkSize <= data.length) {
                chunks.add(Arrays.copyOfRange(data, i, i + chunkSize));
                i += chunkSize;
                continue;
            }
            assert (chunkSize >= 2);
            chunkSize /= 2;
        }
        return (byte[][])chunks.toArray((T[])new byte[chunks.size()][]);
    }

    public static void reverse(byte @Nullable [] bytes, @Nullable MutableInteger chunkSize, @Nullable MutableInteger offsetCrcNotSwapped) {
        if (bytes == null || chunkSize == null) {
            return;
        }
        if (offsetCrcNotSwapped == null) {
            ByteUtils.reverse(bytes, chunkSize);
        } else {
            int chunkLength = chunkSize.get();
            int chunks = (int)Math.ceil((double)offsetCrcNotSwapped.get().intValue() / (double)chunkLength);
            int i = 0;
            while (i < chunks) {
                ByteUtils.reverseChunk(bytes, i * chunkLength, Math.min(offsetCrcNotSwapped.get() - 1, (i + 1) * chunkLength - 1));
                ++i;
            }
        }
    }

    public static void reverse(byte @Nullable [] bytes, @Nullable MutableInteger chunkSize) {
        if (bytes == null || chunkSize == null) {
            return;
        }
        int chunkLength = chunkSize.get();
        int chunks = (int)Math.ceil((double)bytes.length / (double)chunkLength);
        int i = 0;
        while (i < chunks) {
            ByteUtils.reverseChunk(bytes, i * chunkLength, Math.min(bytes.length - 1, (i + 1) * chunkLength - 1));
            ++i;
        }
    }

    public static void reverseChunk(byte[] bytes, int fromIdx, int toIdx) {
        while (toIdx > fromIdx) {
            byte temp = bytes[toIdx];
            bytes[toIdx] = bytes[fromIdx];
            bytes[fromIdx] = temp;
            --toIdx;
            ++fromIdx;
        }
    }
}

