/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.presenter.updaters;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.mem.validation.ui.MainView;
import com.nxp.swtools.mem.validation.ui.VScenarioView;
import com.nxp.swtools.mem.validation.views.VStagesView;
import java.util.Objects;
import java.util.logging.Logger;

public class RunResultsUiUpdater
extends AUIRunnable {
    private static final Logger LOGGER = LogManager.getLogger(RunResultsUiUpdater.class);
    private VPresentationModel data;
    private VParamVariation[] cells;
    private MainView mainView;
    @Nullable
    private VStagesView stageView;
    @Nullable
    private VScenarioView scenarioView;
    @Nullable
    private CellResultsMainView cellsView;

    private static void trace(String message) {
        LOGGER.warning(message);
    }

    public RunResultsUiUpdater(VPresentationModel _data, VParamVariation _cell) {
        this(_data, new VParamVariation[]{_cell});
    }

    public RunResultsUiUpdater(VPresentationModel _data, VParamVariation[] _cells) {
        this.data = _data;
        this.cells = (VParamVariation[])_cells.clone();
        this.mainView = Objects.requireNonNull(this.data.getView());
        if (!this.data.isViewDisposed()) {
            this.stageView = this.mainView.getStagesView();
            this.scenarioView = this.mainView.getScenarioView();
            this.cellsView = this.mainView.getCellResultsMainView();
        } else {
            RunResultsUiUpdater.trace(UtilsText.safeString((String)Messages.RunResultsUiUpdater_0));
        }
    }

    @Override
    public void run() {
        if (this.data.isViewDisposed()) {
            RunResultsUiUpdater.trace(UtilsText.safeString((String)Messages.RunResultsUiUpdater_1));
            return;
        }
        if (this.stageView != null) {
            this.stageView.refresh();
        }
        if (this.scenarioView != null) {
            this.scenarioView.redrawScenarioFigure();
        }
        VParamVariation selCell = this.data.getSelectedCell();
        VParamVariation[] vParamVariationArray = this.cells;
        int n = this.cells.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation cell = vParamVariationArray[n2];
            if (selCell == cell && this.cellsView != null) {
                this.cellsView.setInput(cell, null, false);
            }
            ++n2;
        }
    }
}

