/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.model.IProgressIndicator;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.swt.graphics.Point;

public class VSessionModel
implements Iterable<VEvent>,
Iterator<VEvent>,
IProgressIndicator {
    private VStage stage;
    private VEvent @Nullable [] events;
    private int eventIdx;
    private int nextEventIdx;

    private static VEvent[] generateValidationEvents(VStage stage) {
        VScriptConfig[] scripts;
        int initialEventsCountForCell;
        ArrayList wrlvlTables = new ArrayList();
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        VScenario[] scenarios = stage.extractSelectedScenarios();
        int[] progressDelimiters = new int[scenarios.length + 1];
        long startPhases = 0L;
        boolean sessionStart = true;
        boolean scenarioStart = true;
        boolean tableStart = true;
        boolean cellStart = true;
        boolean scriptStart = true;
        int scenIdx = 0;
        while (scenIdx < scenarios.length) {
            scenarioStart = true;
            VScenario scenario = scenarios[scenIdx];
            progressDelimiters[scenIdx] = events.size();
            VTable[] tables = scenario.getSelectedTables();
            int tableIdx = 0;
            while (tableIdx < tables.length) {
                tableStart = true;
                int initialEventsCountForTable = events.size();
                VTable table = tables[tableIdx];
                if (table != null) {
                    VParamVariation[][] cells = table.getParamVariations();
                    int row = 0;
                    while (row < cells.length) {
                        int col = 0;
                        while (col < cells[row].length) {
                            cellStart = true;
                            VParamVariation cell = cells[row][col];
                            if (cell.isSelected()) {
                                initialEventsCountForCell = events.size();
                                scripts = table.getSelectedScriptConfigs(cell);
                                if (scripts.length != 0) {
                                    int runResultIdx = 0;
                                    int scriptIdx = 0;
                                    while (scriptIdx < scripts.length) {
                                        scriptStart = true;
                                        VScriptConfig script = scripts[scriptIdx];
                                        if (sessionStart) {
                                            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VALIDATION_START);
                                            sessionStart = false;
                                        }
                                        if (scenarioStart) {
                                            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VSCENARIO_START);
                                            scenarioStart = false;
                                        }
                                        if (tableStart) {
                                            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VTABLE_START);
                                            tableStart = false;
                                        }
                                        if (cellStart) {
                                            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.CELL_START);
                                            cellStart = false;
                                        }
                                        if (scriptStart) {
                                            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.SCRIPT_UNIT_START);
                                        }
                                        int initialEventsCountForScripts = events.size();
                                        int i = 0;
                                        while (i < script.getNumRuns()) {
                                            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.SCRIPT_START);
                                            VRunResult result = cell.getResult(runResultIdx++);
                                            HashMap<Integer, VRunResult[]> resultsMap = new HashMap<Integer, VRunResult[]>();
                                            if (result != null) {
                                                resultsMap.put(new Integer(result.numRun), new VRunResult[]{result});
                                            }
                                            VEvent event = new VEvent(scenario, table, cell, script, i, resultsMap);
                                            event.setStartPhases(startPhases);
                                            events.add(event);
                                            startPhases = 0L;
                                            ++i;
                                        }
                                        if (initialEventsCountForScripts != events.size()) {
                                            ((VEvent)events.get(events.size() - 1)).addEndPhase(VEventPhase.SCRIPT_UNIT_END);
                                        }
                                        ++scriptIdx;
                                    }
                                    if (initialEventsCountForCell != events.size()) {
                                        ((VEvent)events.get(events.size() - 1)).addEndPhase(VEventPhase.CELL_END);
                                    }
                                }
                            }
                            ++col;
                        }
                        ++row;
                    }
                }
                if (initialEventsCountForTable != events.size()) {
                    ((VEvent)events.get(events.size() - 1)).addEndPhase(VEventPhase.VTABLE_END);
                }
                ++tableIdx;
            }
            if (VScenario.ScenarioType.CLOCK_CENTERING.name.equals(scenario.getName()) && !wrlvlTables.isEmpty()) {
                VEvent event = new VEvent(scenario, wrlvlTables.toArray(new VTable[wrlvlTables.size()]));
                event.setStartPhases(VPhaseDecoder.INSTANCE.appendPhase(0L, VEventPhase.DYNAMIC_WRLVL_START));
                events.add(event);
            }
            if (events.size() > 0) {
                ((VEvent)events.get(events.size() - 1)).addEndPhase(VEventPhase.VSCENARIO_END);
            }
            ++scenIdx;
        }
        if (events.size() > 0) {
            ((VEvent)events.get(events.size() - 1)).addEndPhase(VEventPhase.VALIDATION_END);
        }
        progressDelimiters[scenarios.length] = events.size();
        int i = 0;
        while (i < progressDelimiters.length - 1) {
            int numRuns = 0;
            int j = progressDelimiters[i];
            while (j < progressDelimiters[i + 1]) {
                numRuns += ((VEvent)events.get((int)j)).numRuns;
                ++j;
            }
            double progressUnit = numRuns > 0 ? 1.0 / (double)numRuns : 1.0;
            int runsCount = 0;
            int j2 = progressDelimiters[i];
            while (j2 < progressDelimiters[i + 1]) {
                VEvent event = (VEvent)events.get(j2);
                List<Double> progressLoc = event.getProgress();
                if (progressLoc != null) {
                    progressLoc.clear();
                    int k = 0;
                    while (k < event.numRuns) {
                        progressLoc.add(new Double((double)(100 * ++runsCount) * progressUnit));
                        ++k;
                    }
                }
                ++j2;
            }
            ++i;
        }
        if (!wrlvlTables.isEmpty()) {
            VScriptConfig[] scriptsConfig;
            int wrlvlStartTestsCount = 0;
            int wrlvlStartEventIdx = progressDelimiters[1] - 1;
            VEvent referenceEvent = (VEvent)events.get(0);
            VTable @Nullable [] tableLoc = referenceEvent.getTables();
            VTable referenceTable = tableLoc[0];
            VParamVariation referenceCell = referenceTable.getParamVariations()[0][0];
            int eventsPerCell = 0;
            scripts = scriptsConfig = referenceTable.getSelectedScriptConfigs(referenceCell);
            initialEventsCountForCell = scriptsConfig.length;
            int cell = 0;
            while (cell < initialEventsCountForCell) {
                VScriptConfig scriptConfig = scripts[cell];
                eventsPerCell += scriptConfig.getNumRuns();
                ++cell;
            }
            int numCells = wrlvlStartTestsCount;
            VEvent wsVirtualEvent = (VEvent)events.get(wrlvlStartEventIdx);
            VTable[] tablesLoc = wsVirtualEvent.getTables();
            VTable wsTable = tablesLoc[0];
            int totalEvents = (numCells += tablesLoc.length * wsTable.getParamVariations().length) * eventsPerCell + wrlvlStartTestsCount;
            int progress = 0;
            int ccIdx = 0;
            while (ccIdx < progressDelimiters[1] - 1) {
                VEvent event = (VEvent)events.get(ccIdx);
                List<Double> progressLoc = event.getProgress();
                if (progressLoc != null) {
                    progressLoc.clear();
                    int iteration = 0;
                    while (iteration < event.getNumRuns()) {
                        progressLoc.add(new Double((double)(++progress) * (100.0 / (double)totalEvents)));
                        ++iteration;
                    }
                }
                ++ccIdx;
            }
            List<Double> progressLoc = wsVirtualEvent.getProgress();
            if (progressLoc != null) {
                progressLoc.clear();
                progressLoc.add(new Double(100.0 / (double)totalEvents));
            }
        }
        return events.toArray(new VEvent[events.size()]);
    }

    private static VEvent[] generateMarginEvents(VStage stage) {
        VTable table;
        long startPhases;
        VParamVariation cell;
        VTable table2;
        VScriptConfig scriptConfig;
        VScriptConfig scriptConfig2;
        VTable[] tables;
        VScenario rmScen = stage.getScenario(VScenario.ScenarioType.READ_MARGINS);
        VScenario wmScen = stage.getScenario(VScenario.ScenarioType.WRITE_MARGINS);
        VScenario diagWmScen = stage.getScenario(VScenario.ScenarioType.DIAG_TX_EYE);
        VScenario diagRmScen = stage.getScenario(VScenario.ScenarioType.DIAG_RX_EYE);
        int numEvents = 0;
        if (rmScen != null && rmScen.isSelected()) {
            ++numEvents;
        }
        if (wmScen != null && wmScen.isSelected()) {
            ++numEvents;
        }
        if (diagWmScen != null && diagWmScen.isSelected()) {
            ++numEvents;
        }
        if (diagRmScen != null && diagRmScen.isSelected()) {
            ++numEvents;
        }
        VEvent[] events = new VEvent[numEvents];
        int crtEventIdx = 0;
        if (rmScen != null && rmScen.isSelected()) {
            tables = rmScen.getSelectedTables();
            @Nullable VParamVariation[] cells = new VParamVariation[tables.length];
            int i = 0;
            while (i < tables.length) {
                VTable table3 = tables[i];
                cells[i] = table3 != null ? table3.getParamVariation(new Point(0, 0)) : null;
                ++i;
            }
            scriptConfig2 = rmScen.getSelectedScriptConfigs()[0];
            VEvent event = new VEvent(rmScen, tables, cells, scriptConfig2);
            events[crtEventIdx++] = event;
            long startPhases2 = 0L;
            startPhases2 = VPhaseDecoder.INSTANCE.appendPhase(startPhases2, VEventPhase.VSCENARIO_START);
            startPhases2 = VPhaseDecoder.INSTANCE.appendPhase(startPhases2, VEventPhase.VTABLE_START);
            startPhases2 = VPhaseDecoder.INSTANCE.appendPhase(startPhases2, VEventPhase.CELL_START);
            startPhases2 = VPhaseDecoder.INSTANCE.appendPhase(startPhases2, VEventPhase.SCRIPT_UNIT_START);
            startPhases2 = VPhaseDecoder.INSTANCE.appendPhase(startPhases2, VEventPhase.SCRIPT_START);
            event.setStartPhases(startPhases2);
            long endPhases = 0L;
            endPhases = VPhaseDecoder.INSTANCE.appendPhase(endPhases, VEventPhase.VSCENARIO_END);
            event.setEndPhases(endPhases);
        }
        if (wmScen != null && wmScen.isSelected()) {
            tables = wmScen.getSelectedTables();
            scriptConfig = wmScen.getSelectedScriptConfigs()[0];
            table2 = tables[0];
            if (table2 != null && (cell = table2.getParamVariation(new Point(0, 0))) != null) {
                VEvent event = new VEvent(wmScen, table2, cell, scriptConfig);
                events[crtEventIdx++] = event;
                startPhases = 0L;
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VSCENARIO_START);
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VTABLE_START);
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.CELL_START);
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.SCRIPT_UNIT_START);
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.SCRIPT_START);
                event.setStartPhases(startPhases);
                event.addEndPhase(VEventPhase.VSCENARIO_END);
            }
        }
        if (diagWmScen != null && diagWmScen.isSelected()) {
            tables = diagWmScen.getSelectedTables();
            scriptConfig = diagWmScen.getSelectedScriptConfigs()[0];
            table2 = tables[0];
            if (table2 != null) {
                cell = table2.getParamVariation(new Point(0, 0));
                VEvent event = new VEvent(diagWmScen, table2, cell, scriptConfig);
                events[crtEventIdx++] = event;
                startPhases = 0L;
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VSCENARIO_START);
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VTABLE_START);
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.CELL_START);
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.SCRIPT_UNIT_START);
                startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.SCRIPT_START);
                event.setStartPhases(startPhases);
                event.addEndPhase(VEventPhase.VSCENARIO_END);
            }
        }
        if (diagRmScen != null && diagRmScen.isSelected() && (table = (tables = diagRmScen.getSelectedTables())[0]) != null) {
            scriptConfig2 = diagRmScen.getSelectedScriptConfigs()[0];
            cell = table.getParamVariation(new Point(0, 0));
            VEvent event = new VEvent(diagRmScen, tables[0], cell, scriptConfig2);
            events[crtEventIdx++] = event;
            startPhases = 0L;
            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VSCENARIO_START);
            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.VTABLE_START);
            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.CELL_START);
            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.SCRIPT_UNIT_START);
            startPhases = VPhaseDecoder.INSTANCE.appendPhase(startPhases, VEventPhase.SCRIPT_START);
            event.setStartPhases(startPhases);
            event.addEndPhase(VEventPhase.VSCENARIO_END);
            event.addEndPhase(VEventPhase.VALIDATION_END);
        }
        return events;
    }

    public VSessionModel(VStage stage, boolean generateEvents) {
        this.stage = stage;
        if (generateEvents) {
            this.generateEvents();
        }
    }

    public void generateEvents() {
        this.events = VSessionModel.generateValidationEvents(this.stage);
        if ((VStage.StageType.VALIDATION.name.equals(this.stage.getName()) || VStage.StageType.UBOOT.name.equals(this.stage.getName())) && this.events == null) {
            this.events = VSessionModel.generateValidationEvents(this.stage);
        } else if (VStage.StageType.MARGINS.name.equals(this.stage.getName()) && this.events == null) {
            this.events = VSessionModel.generateMarginEvents(this.stage);
        }
    }

    @Override
    public @Nullable VEvent getNextEvent() {
        VEvent @Nullable [] eventsLoc = this.events;
        return eventsLoc != null ? (this.nextEventIdx < eventsLoc.length ? eventsLoc[this.nextEventIdx] : null) : null;
    }

    @Override
    public double getProgress() {
        List<Double> progressLoc;
        VEvent event;
        if (this.events != null && (event = this.events[this.eventIdx]) != null && (progressLoc = event.getProgress()) != null) {
            if (event.getIteration() >= 0 && event.getIteration() < progressLoc.size()) {
                return progressLoc.get(event.getIteration());
            }
            if (progressLoc.size() > 0) {
                return progressLoc.get(progressLoc.size() - 1);
            }
        }
        return 0.0;
    }

    @Override
    public @Nullable VScenario getScenario() {
        return this.events != null ? this.events[this.eventIdx].getScenario() : null;
    }

    @Override
    public @Nullable VStage getStage() {
        return this.stage;
    }

    @Override
    public @Nullable VTable getTable() {
        VTable[] tableLoc = this.getTables();
        return tableLoc[0];
    }

    @Override
    public VTable[] getTables() {
        return this.events != null ? this.events[this.eventIdx].getTables() : new VTable[]{};
    }

    public boolean hasMultipleScenarios() {
        VEvent @Nullable [] eventsLoc = this.events;
        return eventsLoc != null ? eventsLoc[0].getScenario() != eventsLoc[eventsLoc.length - 1].getScenario() : false;
    }

    @Override
    public boolean hasNext() {
        VEvent @Nullable [] eventsLoc = this.events;
        return eventsLoc != null ? this.nextEventIdx < eventsLoc.length : false;
    }

    public boolean isFirstScenario() {
        VEvent @Nullable [] eventsLoc = this.events;
        if (eventsLoc != null && this.eventIdx >= 0) {
            return eventsLoc[0].getScenario() == eventsLoc[this.eventIdx].getScenario();
        }
        return false;
    }

    public boolean isLastScenario() {
        VEvent @Nullable [] eventsLoc = this.events;
        return eventsLoc != null ? eventsLoc[this.eventIdx].getScenario() == eventsLoc[eventsLoc.length - 1].getScenario() : false;
    }

    @Override
    public Iterator<VEvent> iterator() {
        return this;
    }

    @Override
    public VEvent next() {
        VEvent @Nullable [] eventsLoc = this.events;
        this.eventIdx = this.nextEventIdx++;
        if (eventsLoc != null && this.eventIdx < eventsLoc.length) {
            VEvent event = eventsLoc[this.eventIdx];
            return Objects.requireNonNull(event);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        VEvent @Nullable [] eventsLoc = this.events;
        return eventsLoc == null ? 0 : eventsLoc.length;
    }

    public void undo() {
        VEvent @Nullable [] eventsLoc = this.events;
        if (eventsLoc != null && this.eventIdx > 0) {
            if (eventsLoc[this.eventIdx].scenario == eventsLoc[0].scenario) {
                this.eventIdx = 0;
                return;
            }
            int i = this.eventIdx;
            while (i > 0) {
                if (eventsLoc[this.eventIdx].scenario != eventsLoc[i].scenario) {
                    this.eventIdx = i + 1;
                    return;
                }
                --i;
            }
        }
    }

    public static class VEvent {
        private long startPhases;
        private long endPhases;
        VScenario scenario;
        private VTable[] tables;
        @Nullable
        private @Nullable VParamVariation @Nullable [] cells;
        private int primaryCellIdx;
        @Nullable
        private VScriptConfig scriptConfig;
        private int iteration;
        @Nullable
        private Map<Integer, VRunResult[]> results;
        private int workUnits;
        @Nullable
        private List<Double> progress;
        private VEventSkipMode skipMode;
        int numRuns;

        public VEvent(VScenario scenario, VTable table, @Nullable VParamVariation cell, VScriptConfig script) {
            this(scenario, new VTable[]{table}, new VParamVariation[]{cell}, script, 0, null);
        }

        public VEvent(VScenario scenario, VTable table, VParamVariation cell, VScriptConfig script, int iteration, HashMap<Integer, VRunResult[]> results) {
            this(scenario, new VTable[]{table}, new VParamVariation[]{cell}, script, iteration, results);
        }

        public VEvent(VScenario scenario, VTable[] tables) {
            this(scenario, tables, null, null, -1, null);
        }

        public VEvent(VScenario scenario, VTable[] tables, VParamVariation cell, VScriptConfig script) {
            this(scenario, tables, new VParamVariation[]{cell}, script, 0, null);
        }

        public VEvent(VScenario scenario, VTable[] tables, @Nullable VParamVariation[] cells, VScriptConfig script) {
            this(scenario, tables, cells, script, 0, null);
        }

        public VEvent(VScenario scenario, VTable[] tables, @Nullable VParamVariation @Nullable [] cells, @Nullable VScriptConfig script, int iteration, @Nullable HashMap<Integer, VRunResult[]> resultTable) {
            this.scenario = scenario;
            this.tables = (VTable[])tables.clone();
            this.cells = cells == null ? null : (VParamVariation[])cells.clone();
            this.scriptConfig = script;
            this.iteration = iteration;
            this.results = resultTable;
            this.primaryCellIdx = -1;
            this.skipMode = VEventSkipMode.NO_SKIP;
            this.numRuns = 1;
            this.setProgress(new ArrayList<Double>());
        }

        public void addEndPhase(VEventPhase endPhase) {
            this.endPhases = VPhaseDecoder.INSTANCE.appendPhase(this.endPhases, endPhase);
        }

        public @Nullable VParamVariation @Nullable [] getCells() {
            return this.cells != null ? (VParamVariation[])this.cells.clone() : null;
        }

        public VEventPhase[] getEndPhases() {
            return VPhaseDecoder.INSTANCE.getPhases(this.endPhases, false);
        }

        public int getIteration() {
            return this.iteration;
        }

        public int getNumRuns() {
            return this.numRuns;
        }

        public int getPrimaryCellIndex() {
            return this.primaryCellIdx;
        }

        public @Nullable List<Double> getProgress() {
            return this.progress;
        }

        public @Nullable Map<Integer, VRunResult[]> getResults() {
            return this.results;
        }

        public VScenario getScenario() {
            return this.scenario;
        }

        public @Nullable VScriptConfig getScriptConfig() {
            return this.scriptConfig;
        }

        public VEventSkipMode getSkipMode() {
            return this.skipMode;
        }

        public VEventPhase[] getStartPhases() {
            return VPhaseDecoder.INSTANCE.getPhases(this.startPhases, true);
        }

        public VTable[] getTables() {
            return (VTable[])this.tables.clone();
        }

        public int getWorkUnits() {
            return this.workUnits;
        }

        public void setEndPhase(VEventPhase endPhase) {
            this.endPhases = VPhaseDecoder.INSTANCE.appendPhase(0L, endPhase);
        }

        public void setEndPhases(long endPhases) {
            this.endPhases = endPhases;
        }

        public void setIteration(int iteration) {
            this.iteration = iteration;
        }

        public void setNumRuns(int numRuns) {
            this.numRuns = numRuns;
        }

        public void setPrimaryCellIndex(int primaryCellIdx) {
            this.primaryCellIdx = primaryCellIdx;
        }

        public void setProgress(ArrayList<Double> progress) {
            this.progress = progress;
        }

        public void setSkipMode(VEventSkipMode skipMode) {
            this.skipMode = skipMode;
        }

        public void setStartPhases(long startPhases) {
            this.startPhases = startPhases;
        }
    }

    public static enum VEventPhase {
        VALIDATION_START(1),
        VSCENARIO_START(2),
        VTABLE_START(3),
        CELL_START(4),
        SCRIPT_UNIT_START(5),
        SCRIPT_START(6),
        DYNAMIC_WRLVL_START(7),
        DYNAMIC_WRLVL_START_PHASE_2_START(8),
        SCRIPT_END(1),
        SCRIPT_UNIT_END(2),
        CELL_END(3),
        VTABLE_END(4),
        VSCENARIO_END(5),
        VALIDATION_END(6),
        DYNAMIC_WLRLVL_START_PHASE_1_END(7),
        DYNAMIC_WRLVL_START_PHASE_2_UPPER_END(8),
        DYNAMIC_WRLVL_START_PHASE_2_LOWER_END(9);

        public final int id;

        private VEventPhase(int id) {
            this.id = id;
        }
    }

    public static enum VEventSkipMode {
        NO_SKIP,
        SKIP_FULL,
        SKIP_START_AND_EXEC;

    }

    public static enum VPhaseDecoder {
        INSTANCE;

        private final long ENCODED_MASK = 0xFFFFFFFFFFL;
        private final long ENCODED_MASK_MSBS = 0xFFFFF00000L;
        private final int MAX_PHASES = 10;
        private final long SEMIBYTE_MASK = 15L;
        private final long SEMIBYTE_LEN = 4L;
        private Map<Integer, VEventPhase> startPhases = new HashMap<Integer, VEventPhase>();
        private Map<Integer, VEventPhase> endPhases = new HashMap<Integer, VEventPhase>();
        private Map<Long, VEventPhase[]> decodedStartPhases = new HashMap<Long, VEventPhase[]>();
        private Map<Long, VEventPhase[]> decodedEndPhases = new HashMap<Long, VEventPhase[]>();

        private VPhaseDecoder() {
            this.startPhases.put(new Integer(VEventPhase.VALIDATION_START.id), VEventPhase.VALIDATION_START);
            this.startPhases.put(new Integer(VEventPhase.VSCENARIO_START.id), VEventPhase.VSCENARIO_START);
            this.startPhases.put(new Integer(VEventPhase.VTABLE_START.id), VEventPhase.VTABLE_START);
            this.startPhases.put(new Integer(VEventPhase.CELL_START.id), VEventPhase.CELL_START);
            this.startPhases.put(new Integer(VEventPhase.SCRIPT_UNIT_START.id), VEventPhase.SCRIPT_UNIT_START);
            this.startPhases.put(new Integer(VEventPhase.SCRIPT_START.id), VEventPhase.SCRIPT_START);
            this.startPhases.put(new Integer(VEventPhase.DYNAMIC_WRLVL_START.id), VEventPhase.DYNAMIC_WRLVL_START);
            this.startPhases.put(new Integer(VEventPhase.DYNAMIC_WRLVL_START_PHASE_2_START.id), VEventPhase.DYNAMIC_WRLVL_START_PHASE_2_START);
            this.endPhases.put(new Integer(VEventPhase.SCRIPT_END.id), VEventPhase.SCRIPT_END);
            this.endPhases.put(new Integer(VEventPhase.SCRIPT_UNIT_END.id), VEventPhase.SCRIPT_UNIT_END);
            this.endPhases.put(new Integer(VEventPhase.CELL_END.id), VEventPhase.CELL_END);
            this.endPhases.put(new Integer(VEventPhase.VTABLE_END.id), VEventPhase.VTABLE_END);
            this.endPhases.put(new Integer(VEventPhase.VSCENARIO_END.id), VEventPhase.VSCENARIO_END);
            this.endPhases.put(new Integer(VEventPhase.VALIDATION_END.id), VEventPhase.VALIDATION_END);
            this.endPhases.put(new Integer(VEventPhase.DYNAMIC_WLRLVL_START_PHASE_1_END.id), VEventPhase.DYNAMIC_WLRLVL_START_PHASE_1_END);
            this.endPhases.put(new Integer(VEventPhase.DYNAMIC_WRLVL_START_PHASE_2_UPPER_END.id), VEventPhase.DYNAMIC_WRLVL_START_PHASE_2_UPPER_END);
            this.endPhases.put(new Integer(VEventPhase.DYNAMIC_WRLVL_START_PHASE_2_LOWER_END.id), VEventPhase.DYNAMIC_WRLVL_START_PHASE_2_LOWER_END);
            this.decodedStartPhases.put(new Long(0L), new VEventPhase[0]);
            this.decodedEndPhases.put(new Long(0L), new VEventPhase[0]);
        }

        public long appendPhase(long encoded, VEventPhase phase) {
            int count = this.getPhaseCount(encoded);
            return encoded |= (long)(phase.id << count * 4);
        }

        private VEventPhase[] decodePhases(long encoded, boolean fromStartPhases) {
            int count = this.getPhaseCount(encoded);
            int[] ids = this.getPhaseIds(encoded, count);
            Map<Integer, VEventPhase> phaseMap = fromStartPhases ? this.startPhases : this.endPhases;
            VEventPhase[] phases = new VEventPhase[count];
            int i = 0;
            while (i < count) {
                VEventPhase p = phaseMap.get(new Integer(ids[i]));
                if (p != null) {
                    phases[i] = p;
                }
                ++i;
            }
            return phases;
        }

        private int getPhaseCount(long encoded) {
            long maxCount;
            if ((encoded &= 0xFFFFFFFFFFL) == 0L) {
                return 0;
            }
            long i = maxCount = (long)((encoded & 0xFFFFF00000L) != 0L ? 10 : 5);
            while (i > 0L) {
                long mask = 15L << (int)((i - 1L) * 4L);
                if ((encoded & mask) > 0L) {
                    maxCount = i;
                    break;
                }
                --i;
            }
            return (int)maxCount;
        }

        private int[] getPhaseIds(long encoded, int count) {
            int[] phaseIds = new int[count];
            int i = 0;
            while (i < count) {
                phaseIds[i] = (int)(encoded & 0xFL);
                encoded >>= 4;
                ++i;
            }
            return phaseIds;
        }

        public VEventPhase[] getPhases(long encoded, boolean fromStartPhases) {
            Map<Long, VEventPhase[]> decodedMap = fromStartPhases ? this.decodedStartPhases : this.decodedEndPhases;
            VEventPhase[] phases = decodedMap.get(new Long(encoded));
            if (phases == null) {
                phases = this.decodePhases(encoded, fromStartPhases);
                decodedMap.put(new Long(encoded), phases);
            }
            return phases;
        }
    }
}

