/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.tasystem;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessDestroyer;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessOutputHandler;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessWaitHandler;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystem;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemDescriptor;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemLauncher;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TASystemInstance {
    protected static final Logger LOGGER = LogManager.getLogger(TASystemInstance.class);
    public static final String INSTANCE_ID_PARAM = "INSTANCE_ID";
    public static final String CMD_QUIT_CMD = "exit";
    public static final String GDB_PY_QUIT_CMD = "quit";
    private static final long OUTPUT_HANDLER_WAIT_TIMEOUT = 2000L;
    private static long nextID = 0L;
    private TASystem system;
    private Map<String, @Nullable Process> services = new HashMap<String, Process>();
    private Map<String, String> params;
    @Nullable
    private TransientProcess trans;
    private boolean recycled;
    private long instanceId;

    private static long getNextId() {
        return nextID++;
    }

    public TASystemInstance(TASystem _system, Map<String, @Nullable Process> _services, Map<String, String> _params, @Nullable TASystemDescriptor.TAProcessDescriptor _transientPD, String _transientExecPath) {
        this.system = _system;
        this.services.putAll(_services);
        this.params = new HashMap<String, String>();
        this.params.putAll(_params);
        this.trans = new TransientProcess(_transientPD, _transientExecPath);
        this.instanceId = TASystemInstance.getNextId();
        this.params.put(INSTANCE_ID_PARAM, "" + this.instanceId);
    }

    public long getId() {
        return this.instanceId;
    }

    public @Nullable OutputStream getInputStream() {
        TransientProcess transLoc = this.trans;
        return transLoc != null ? (transLoc.process != null ? transLoc.process.getOutputStream() : null) : null;
    }

    public @Nullable ProcessOutputHandler getOutputHandler() {
        TransientProcess transLoc = this.trans;
        return transLoc != null ? transLoc.outHandler : null;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public @Nullable Process getService(String procId) {
        return this.services.get(procId);
    }

    public TASystem getSystem() {
        return this.system;
    }

    public @Nullable ProcessWaitHandler getWaitHandler() {
        TransientProcess transLoc = this.trans;
        return transLoc != null ? transLoc.waitHandler : null;
    }

    public boolean isRecycled() {
        return this.recycled;
    }

    public boolean isRunning() {
        TransientProcess transLoc = this.trans;
        return transLoc != null ? transLoc.process != null && transLoc.process.isAlive() : false;
    }

    public void launchTransientProcess(long timeout, Map<String, String> envParams) throws IOException {
        TransientProcess transLoc = this.trans;
        if (transLoc != null) {
            LOGGER.log(Level.INFO, Messages.StartConnectionServer_0, transLoc.execPath);
            transLoc.process = TASystemLauncher.createProcess(transLoc.descriptor, transLoc.execPath, true, this.params, envParams);
            transLoc.outHandler = new ProcessOutputHandler(transLoc.process);
            transLoc.outHandlerThread = new Thread(transLoc.outHandler);
            transLoc.outHandlerThread.start();
            transLoc.waitHandler = new ProcessWaitHandler(Objects.requireNonNull(transLoc.outHandlerThread), timeout);
            transLoc.waitHandlerThread = new Thread(transLoc.waitHandler);
            transLoc.waitHandlerThread.start();
            transLoc.out = new BufferedWriter(new OutputStreamWriter(Objects.requireNonNull(transLoc.process).getOutputStream(), StandardCharsets.UTF_8));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendCommands(String ... commands) throws ResourceNotFoundException {
        TransientProcess transLoc = this.trans;
        if (transLoc == null || transLoc.waitHandler == null || transLoc.outHandler == null) {
            return false;
        }
        ProcessWaitHandler waitHandlerLoc = transLoc.waitHandler;
        if (waitHandlerLoc == null || waitHandlerLoc.getState() != RunAction.ExecStatus.RUNNING && waitHandlerLoc.getState() != RunAction.ExecStatus.CANCELLED && waitHandlerLoc.getState() != RunAction.ExecStatus.TIMED_OUT) throw new ResourceNotFoundException(Messages.ConnectionServerDown_0);
        try {
            BufferedWriter outLoc = transLoc.out;
            if (outLoc == null) return true;
            String[] stringArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                outLoc.write(command);
                outLoc.newLine();
                ++n2;
            }
            outLoc.flush();
            return true;
        }
        catch (IOException iOException) {
            throw new ResourceNotFoundException(Messages.ConnectionServerDown_0);
        }
    }

    public void setRecycled() {
        this.recycled = true;
    }

    public boolean terminate(String @Nullable [] processesPID) throws ResourceNotFoundException {
        TransientProcess transLoc = this.trans;
        if (transLoc == null) {
            return true;
        }
        ProcessWaitHandler waitHandlerLoc = transLoc.waitHandler;
        ProcessOutputHandler outHandlerLoc = transLoc.outHandler;
        if (waitHandlerLoc == null || outHandlerLoc == null) {
            return true;
        }
        String quitCommand = "";
        boolean isGdbPy = false;
        switch (this.getSystem().getDescriptor().type) {
            case SERIAL: {
                quitCommand = CMD_QUIT_CMD;
                break;
            }
            case GDB_PY: {
                isGdbPy = true;
                quitCommand = GDB_PY_QUIT_CMD;
            }
        }
        this.sendCommands(quitCommand);
        if (UtilsText.isArrayEmpty((String[])processesPID) && isGdbPy && OSDetect.isUnix()) {
            String cmd = "ps -aux | grep -v jre | grep -v grep | grep " + transLoc.execPath + " | awk '{print $2}'";
            Runtime runtime = Runtime.getRuntime();
            try {
                Throwable throwable = null;
                Object var10_13 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(runtime.exec(cmd).getInputStream(), Charset.forName("UTF-8")));){
                    String pid = null;
                    String inputLine = null;
                    while ((inputLine = in.readLine()) != null) {
                        pid = inputLine;
                    }
                    if (pid != null) {
                        cmd = "kill -INT " + pid;
                        Process p = Runtime.getRuntime().exec(cmd);
                        p.waitFor();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.severe("Could not send SIGINT to GDB PY : " + e.getMessage());
            }
        }
        try {
            waitHandlerLoc.cancel();
            if (transLoc.waitHandlerThread != null) {
                transLoc.waitHandlerThread.join();
            }
            outHandlerLoc.cancel();
            if (transLoc.outHandlerThread != null) {
                transLoc.outHandlerThread.join(2000L);
            }
        }
        catch (InterruptedException ie) {
            LOGGER.warning(ie.getLocalizedMessage());
            return false;
        }
        String execName = new File(transLoc.execPath).getName();
        ProcessDestroyer.destroy(execName, transLoc.process, processesPID);
        transLoc.cleanup();
        return true;
    }

    public void updateParam(String name, String value) {
        this.params.put(name, value);
    }

    public boolean waitForTransientProcess(long timeout, long stepTimeout) {
        TransientProcess transLoc = this.trans;
        if (transLoc == null || transLoc.waitHandler == null || transLoc.outHandler == null) {
            return true;
        }
        long crtTimeout = 0L;
        while (crtTimeout <= timeout) {
            if (Objects.requireNonNull(transLoc.waitHandler).getState() != RunAction.ExecStatus.RUNNING) {
                return true;
            }
            try {
                Thread.sleep(stepTimeout);
            }
            catch (InterruptedException ie) {
                LOGGER.severe(ie.getMessage());
            }
            crtTimeout += stepTimeout;
        }
        return false;
    }

    public static class TransientProcess {
        @Nullable
        public TASystemDescriptor.TAProcessDescriptor descriptor;
        public String execPath;
        @Nullable
        public Process process;
        @Nullable
        public ProcessOutputHandler outHandler;
        @Nullable
        public ProcessWaitHandler waitHandler;
        @Nullable
        public Thread outHandlerThread;
        @Nullable
        public Thread waitHandlerThread;
        @Nullable
        public BufferedWriter out;

        public TransientProcess(@Nullable TASystemDescriptor.TAProcessDescriptor _descriptor, String _execPath) {
            this.descriptor = _descriptor;
            this.execPath = _execPath;
        }

        public void cleanup() {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    LOGGER.severe(e.getMessage());
                }
            }
            this.process = null;
            this.outHandler = null;
            this.waitHandler = null;
            this.outHandlerThread = null;
            this.waitHandlerThread = null;
        }
    }
}

