/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.tasystem;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemDescriptor;
import java.util.HashMap;
import java.util.Map;

public class TASystem {
    private TASystemDescriptor descriptor;
    private int id;
    private Map<String, String> execPaths = new HashMap<String, String>();

    public static String getExecPath(String processKey) {
        return processKey.split("@")[1];
    }

    public TASystem(TASystemDescriptor _descriptor, Map<String, String> _execPaths) {
        this.descriptor = _descriptor;
        this.execPaths = new HashMap<String, String>(_execPaths);
    }

    public TASystemDescriptor getDescriptor() {
        return this.descriptor;
    }

    public @Nullable String getPath(String taProcessType) {
        return this.execPaths.get(taProcessType);
    }

    public String @Nullable [] getProcessExecPaths() {
        return this.execPaths.values().toArray(new String[this.execPaths.size()]);
    }

    public String getProcessKey(TASystemDescriptor.TAProcessDescriptor procDesc) {
        String pdName = procDesc.type.name();
        return String.valueOf(pdName) + "@" + this.execPaths.get(pdName);
    }

    public String @Nullable [] getProcessTypes() {
        return this.execPaths.keySet().toArray(new String[this.execPaths.size()]);
    }

    public String getSystemId() {
        StringBuilder buff = new StringBuilder();
        TASystemDescriptor.TAProcessDescriptor[] tAProcessDescriptorArray = this.descriptor.processes;
        int n = this.descriptor.processes.length;
        int n2 = 0;
        while (n2 < n) {
            TASystemDescriptor.TAProcessDescriptor pd = tAProcessDescriptorArray[n2];
            String pdName = pd.type.name();
            buff.append(pdName);
            String exePath = this.execPaths.get(pdName);
            if (exePath != null) {
                buff.append(" : ").append(exePath).append(" | ");
            }
            ++n2;
        }
        return buff.toString();
    }

    public void setDescriptor(TASystemDescriptor _descriptor) {
        this.descriptor = _descriptor;
    }

    public void setId(int _id) {
        this.id = _id;
    }

    public int sgetId() {
        return this.id;
    }
}

