/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.os.PlatformSpecificUtils;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.ui.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Path;

public class SerialConnection
extends Connection {
    private static final Logger LOGGER = LogManager.getLogger(SerialConnection.class);
    private String comPort;
    private boolean isSerialApplicationChecked = false;
    private String securedAppPath;
    private String nonSecuredAppDir;

    public SerialConnection(Connection.SUPPORTED_CONNECTIONS connectionType) {
        super(connectionType);
        this.clockSource = 0;
        this.securedAppPath = "";
        this.nonSecuredAppDir = "";
        String currentValidationPort = "";
        Connection currentValidationConnection = ValidationContext.getInstance().getCurrentConnection();
        if (currentValidationConnection instanceof SerialConnection) {
            currentValidationPort = ((SerialConnection)currentValidationConnection).getComPort();
        }
        this.comPort = !currentValidationPort.isEmpty() ? currentValidationPort : SerialConnection.getCOMPorts()[0];
    }

    SerialConnection(String comPortArg, int clockSourceArg) {
        super(Connection.SUPPORTED_CONNECTIONS.SERIAL_CONNECTION);
        this.comPort = comPortArg;
        this.clockSource = clockSourceArg;
        this.securedAppPath = "";
        this.nonSecuredAppDir = "";
    }

    public String getComPort() {
        return this.comPort;
    }

    public String getSecuredAppPath() {
        return this.securedAppPath;
    }

    public String getNonSecuredAppDir() {
        return this.nonSecuredAppDir;
    }

    public boolean getSecuredAppOptionState() {
        return this.isSerialApplicationChecked;
    }

    public void setSecuredAppPath(String securedApplicationPath) {
        this.securedAppPath = securedApplicationPath;
    }

    public void setNonSecuredAppDir(String nonSecuredApplicationDir) {
        this.nonSecuredAppDir = nonSecuredApplicationDir;
    }

    public void setSecuredOptionCheckState(boolean isSerialAppOptionChecked) {
        this.isSerialApplicationChecked = isSerialAppOptionChecked;
    }

    public void setComPort(String comPortArg) {
        this.comPort = comPortArg;
    }

    @Override
    public int getClockSource() {
        return this.clockSource;
    }

    @Override
    public void setClockSource(int clockSourceArg) {
        this.clockSource = clockSourceArg;
    }

    @Override
    public boolean hasErrors() {
        boolean comPortError;
        boolean securedOptionErrors = this.isSerialApplicationChecked && this.securedAppPath.isEmpty();
        boolean bl = comPortError = this.comPort.isEmpty() || Messages.UNDEFINED_PORT_NAME.equals(this.comPort);
        return securedOptionErrors || comPortError;
    }

    @Override
    public String getErrorMessage() {
        if (this.comPort.isEmpty() || Messages.UNDEFINED_PORT_NAME.equals(this.comPort)) {
            return Messages.ERR_USB_PORT_NOT_SPECIFIED;
        }
        if (this.isSerialApplicationChecked && this.securedAppPath.isEmpty()) {
            return Messages.SECURED_PATH_NOT_SPECIFIED;
        }
        return "";
    }

    public static String[] getCOMPorts() {
        String scanOutput;
        String[] comPorts = new String[]{Messages.UNDEFINED_PORT_NAME};
        Path path = new Path(System.getProperty("user.dir"));
        String pythonPath = System.getProperty("python.dir");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (pythonPath == null) {
            String[] availableComPorts = PlatformSpecificUtils.getAvailablePorts().toArray(new String[0]);
            return availableComPorts.length == 0 ? comPorts : availableComPorts;
        }
        path = path.append(pythonPath);
        if (!(System.getProperty("python.dir") == null || path != null && new File(path.toOSString()).exists())) {
            LOGGER.log(Level.SEVERE, Messages.PythonNotFound, path);
            return comPorts;
        }
        path = OSDetect.isWindows() ? path.append("python") : path.append("bin/python");
        builder.command(path.toOSString(), "-E", "-m", "serial.tools.list_ports");
        int exitCode = -1;
        StringBuilder output = new StringBuilder();
        Process process = null;
        try {
            process = builder.start();
            exitCode = process.waitFor();
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
            return comPorts;
        }
        catch (InterruptedException e) {
            LOGGER.severe(e.getMessage());
            Thread.currentThread().interrupt();
            return comPorts;
        }
        try {
            Throwable e = null;
            Object var8_13 = null;
            try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line = null;
                while ((line = stdInput.readLine()) != null) {
                    output.append(line);
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
        }
        if (exitCode == 0 && !(scanOutput = output.toString()).isEmpty()) {
            comPorts = scanOutput.replaceAll("( )+", " ").split(" ");
        }
        return comPorts;
    }
}

