/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.codgen;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.codgen.RunScriptRequest;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.JTAGConnection;
import com.nxp.swtools.mem.validation.connections.SerialConnection;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptFileParamValue;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.FileUtils;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.registers.RegisterInfo;
import com.nxp.swtools.utils.scripting.ScriptDependencyHelper;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import com.nxp.swtools.utils.scripting.api.IScriptDependencyHelper;
import com.nxp.swtools.utils.scripting.api.IScriptProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.json.JSONObject;
import org.osgi.framework.Bundle;

public class ValidationScriptProfile
implements IScriptProfile {
    public static final String RESET_TARGET = "connect.reset";
    public static final String TABLE_ID = "TABLE_ID";
    public static final String CELL_ROW = "CELL_ROW";
    public static final String CELL_COL = "CELL_COL";
    public static final String SCRIPT_ID = "app.name";
    public static final String ITERATION = "ITERATION";
    public static final String NUM_RUNS = "NUM_RUNS";
    public static final String RANDOM_PATTERN = "RANDOM_PATTERN";
    private static final String[] vstageProperties = new String[]{"connect.reset", "TABLE_ID", "CELL_ROW", "CELL_COL", "app.name", "ITERATION", "NUM_RUNS", "RANDOM_PATTERN"};
    private static final Logger LOGGER = LogManager.getLogger(ValidationScriptProfile.class);
    private IScriptDependencyHelper scrptDependencyHelper = new ScriptDependencyHelper(new ArrayList(), false);
    private RunScriptRequest.ScriptFile[] files = new RunScriptRequest.ScriptFile[0];

    private static @com.nxp.swtools.common.utils.Nullable VScriptParamValue getScriptProperty(String id) {
        ValidationContext vContext = ValidationContext.getInstance();
        String scriptName = vContext.getCrtScriptId();
        VScript script = vContext.getData().getScripts().getScript(scriptName);
        VSessionModel.VEvent event = vContext.getEvent();
        if (event.getTables().length > 0) {
            VTable table = event.getTables()[0];
            if (script == null) {
                return null;
            }
            VScriptConfig scriptConfig = table.getConfigurationForScript(script, true);
            if (scriptConfig == null) {
                return null;
            }
            VScriptParamValue[] vScriptParamValueArray = scriptConfig.getParamValues();
            int n = vScriptParamValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                VScriptParamValue pv = vScriptParamValueArray[n2];
                if (pv.getParam().getId().equals(id)) {
                    return pv;
                }
                ++n2;
            }
        }
        return null;
    }

    private static @com.nxp.swtools.common.utils.Nullable Object getScriptPropertyValue(String id) {
        VScriptParamValue paramValue = ValidationScriptProfile.getScriptProperty(id);
        if (paramValue == null) {
            return null;
        }
        return paramValue.getValue();
    }

    private static Object getVstagePropertyValue(String property) {
        ValidationContext vContext = ValidationContext.getInstance();
        VSessionModel.VEvent event = vContext.getEvent();
        VSessionModel.VEventPhase phase = vContext.getEventPhase();
        if (RESET_TARGET.equalsIgnoreCase(property)) {
            return false;
        }
        if (TABLE_ID.equalsIgnoreCase(property)) {
            return Objects.requireNonNull(Objects.requireNonNull(event.getTables())[0]).getId();
        }
        if (CELL_ROW.equalsIgnoreCase(property)) {
            return phase == VSessionModel.VEventPhase.CELL_START || phase == VSessionModel.VEventPhase.SCRIPT_UNIT_START || phase == VSessionModel.VEventPhase.SCRIPT_START ? Integer.valueOf(Objects.requireNonNull(Objects.requireNonNull(event.getCells())[0]).getPos().x) : "";
        }
        if (CELL_COL.equalsIgnoreCase(property)) {
            return phase == VSessionModel.VEventPhase.CELL_START || phase == VSessionModel.VEventPhase.SCRIPT_UNIT_START || phase == VSessionModel.VEventPhase.SCRIPT_START ? Integer.valueOf(Objects.requireNonNull(Objects.requireNonNull(event.getCells())[0]).getPos().y) : "";
        }
        if (SCRIPT_ID.equalsIgnoreCase(property)) {
            String scriptId = Objects.requireNonNull(event.getScriptConfig()).getScript().getName();
            return phase == VSessionModel.VEventPhase.SCRIPT_UNIT_START || phase == VSessionModel.VEventPhase.SCRIPT_START ? scriptId : "";
        }
        if (ITERATION.equalsIgnoreCase(property)) {
            return event.getIteration();
        }
        if (NUM_RUNS.equalsIgnoreCase(property)) {
            return event.getNumRuns();
        }
        if (RANDOM_PATTERN.equalsIgnoreCase(property)) {
            return true;
        }
        return "";
    }

    public IScriptDependencyHelper getDependencyHelper() {
        return this.scrptDependencyHelper;
    }

    public List<@NonNull String> getGeneratedCode() {
        return new ArrayList<String>();
    }

    public List<@NonNull String> getInstanceNames() {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        return configController != null ? configController.getConfiguredComponentInstances() : new ArrayList<String>();
    }

    public String getCurrentInstanceName() {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        return configController != null ? configController.getCurrentInstanceName() : "";
    }

    public List<@NonNull String> getTestParams() {
        ArrayList<@NonNull String> paramFiles = new ArrayList<String>();
        RunScriptRequest.ScriptFile[] scriptFileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            RunScriptRequest.ScriptFile currentFile = scriptFileArray[n2];
            paramFiles.add(currentFile.name);
            ++n2;
        }
        return paramFiles;
    }

    public IMcuInfo getMcuInfo() {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null) {
            return configController.getMCUInfo();
        }
        return new IMcuInfo(){

            public @NonNull String getSeries() {
                return "";
            }

            public @NonNull String getSdkVersion() {
                return "";
            }

            public @NonNull String getPartNumber() {
                return "";
            }

            public @NonNull String getPackage() {
                return "";
            }

            public @com.nxp.swtools.common.utils.Nullable String getKit() {
                return "";
            }

            public @NonNull String getFamily() {
                return "";
            }

            public @NonNull String getDataVersion() {
                return "";
            }

            public @NonNull JSONObject getCoresList() {
                return new JSONObject();
            }

            public @com.nxp.swtools.common.utils.Nullable String getBoard() {
                return "";
            }

            public @Nullable String getMexVariant() {
                return null;
            }
        };
    }

    public String getToolName() {
        return "ValidationTool";
    }

    public String getToolVersion() {
        return "";
    }

    public @com.nxp.swtools.common.utils.Nullable Object getValueOf(String id) {
        String[] stringArray = vstageProperties;
        int n = vstageProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String vstageProperty = stringArray[n2];
            if (vstageProperty.equalsIgnoreCase(id)) {
                return ValidationScriptProfile.getVstagePropertyValue(id);
            }
            ++n2;
        }
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        Object value = configController != null ? configController.getPropertyValueId(id) : null;
        value = value == null ? ValidationScriptProfile.getScriptPropertyValue(id) : value;
        return value != null ? value : null;
    }

    public void setValueOf(String id, String value) {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null) {
            configController.updatePropertyValue(id, value, true, false);
        }
    }

    public String getValueOf(String componentId, String id) {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        String value = configController != null ? configController.getPropertyValue(componentId, id) : null;
        return UtilsText.safeString((String)value);
    }

    public @com.nxp.swtools.common.utils.Nullable String getRegisterData(String id) {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        String value = configController != null ? configController.getPropertyValueId(id) : null;
        return UtilsText.safeString((String)value);
    }

    public List<Long[]> getDdrcConfigSeq() {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        ArrayList<Long[]> value = configController != null ? configController.getDdrcConfigSeq() : new ArrayList<Long[]>();
        return value;
    }

    public Map<String, RegisterInfo> getRegisters() {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        assert (configController != null);
        Map<String, RegisterInfo> orderedDdrRegisters = configController.getRegisters();
        if (orderedDdrRegisters == null) {
            return new LinkedHashMap<String, RegisterInfo>();
        }
        String configSet = configController.getCurrentInstanceName();
        List orderedRegsByName = orderedDdrRegisters.values().stream().collect(Collectors.toList());
        Collections.sort(orderedRegsByName, (left, right) -> {
            BigInteger leftVal = left.getRegisterData().getAddress(configSet);
            BigInteger rightVal = right.getRegisterData().getAddress(configSet);
            if (leftVal != null && rightVal != null) {
                return leftVal.intValue() - rightVal.intValue();
            }
            return 0;
        });
        orderedDdrRegisters = new LinkedHashMap<String, RegisterInfo>();
        for (RegisterInfo register : orderedRegsByName) {
            orderedDdrRegisters.put(register.getRegisterData().getName(), register);
        }
        return orderedDdrRegisters;
    }

    public String getRunningTest() {
        ValidationContext vContext = ValidationContext.getInstance();
        VSessionModel.VEvent event = vContext.getNullableEvent();
        if (event != null) {
            return event.getScenario().getName();
        }
        return "";
    }

    public @com.nxp.swtools.common.utils.Nullable String getResultFilePath() {
        ValidationContext vContext = ValidationContext.getInstance();
        VSessionModel.VEvent event = vContext.getEvent();
        VTable table = event.getTables()[0];
        VParamVariation cell = table.getFirstQueuedCell();
        if (cell == null) {
            return null;
        }
        VRunResult[] results = cell.getResults();
        if (results == null) {
            return null;
        }
        return FileUtils.readTextFile(TestResultsLogger.getLogFilePath(results[0]));
    }

    public @com.nxp.swtools.common.utils.Nullable String getYaml() {
        return "";
    }

    public void setFiles(RunScriptRequest.ScriptFile[] files) {
        this.files = files;
    }

    public void setGeneratedCode(List<String> generated) {
        int i = 0;
        for (String str : generated) {
            this.files[i++].content = str;
        }
    }

    public List<String> getConfiguredComponentInstances() {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        return configController != null ? configController.getConfiguredComponentInstances() : new ArrayList<String>();
    }

    public @com.nxp.swtools.common.utils.Nullable IComponentInstanceConfig getInstance(String name) {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        return configController != null ? configController.getInstance(name) : null;
    }

    public @com.nxp.swtools.common.utils.Nullable String getLog() {
        return Activator.getDefault().getConfigManager().getLogsFolder();
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public @com.nxp.swtools.common.utils.Nullable SerialConnection getConfiguredSerialConnection() {
        Connection connection;
        ValidationContext context = ValidationContext.getInstance();
        ExecutionPresentationModel executionModel = context.getData().getExecution();
        if (executionModel != null && (connection = executionModel.getConnection()) instanceof SerialConnection) {
            return (SerialConnection)connection;
        }
        return null;
    }

    public String getUsbComPort() {
        SerialConnection connection = this.getConfiguredSerialConnection();
        if (connection != null) {
            return connection.getComPort();
        }
        return "";
    }

    public String getSerialSecuredAppPath() {
        SerialConnection connection = this.getConfiguredSerialConnection();
        if (connection != null) {
            return connection.getSecuredAppPath();
        }
        return "";
    }

    public boolean getSerialSecuredAppState() {
        SerialConnection connection = this.getConfiguredSerialConnection();
        if (connection != null) {
            return connection.getSecuredAppOptionState();
        }
        return false;
    }

    public String getNonSecuredAppDirPath() {
        SerialConnection connection = this.getConfiguredSerialConnection();
        if (connection != null) {
            return connection.getNonSecuredAppDir();
        }
        return "";
    }

    public String getXoscFreq() {
        Connection connection;
        ValidationContext context = ValidationContext.getInstance();
        ExecutionPresentationModel executionModel = context.getData().getExecution();
        if (executionModel != null && (connection = executionModel.getConnection()) != null) {
            return String.valueOf(connection.getClockSource());
        }
        return "";
    }

    @Deprecated
    public String getBaudRate() {
        switch (this.getXoscFreq()) {
            case "20": {
                return "24000";
            }
            case "40": {
                return "48000";
            }
        }
        return "";
    }

    public String getUsbSerialNumber() {
        Connection connection;
        ValidationContext context = ValidationContext.getInstance();
        ExecutionPresentationModel executionModel = context.getData().getExecution();
        if (executionModel != null && (connection = executionModel.getConnection()) instanceof JTAGConnection && ((JTAGConnection)connection).isUsbConnection()) {
            return String.valueOf(((JTAGConnection)connection).getUsbSerialNumber());
        }
        return "";
    }

    public String getHostname() {
        Connection connection;
        ValidationContext context = ValidationContext.getInstance();
        ExecutionPresentationModel executionModel = context.getData().getExecution();
        if (executionModel != null && (connection = executionModel.getConnection()) instanceof JTAGConnection && !((JTAGConnection)connection).isUsbConnection()) {
            return ((JTAGConnection)connection).getHostname();
        }
        return "";
    }

    public void setOutput(String output) {
        ValidationContext.getInstance().setOutput(output);
    }

    public byte[] getBinaryFileContent(String fileName) {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null) {
            return configController.getBinaryFileContent(fileName);
        }
        return new byte[0];
    }

    public List<String> getFileLines(String fileName) {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null) {
            File file = configController.getResourceFile(fileName);
            if (file == null) {
                LOGGER.severe(() -> "Could not find the file:" + fileName + " in getFileLines()");
            } else if (file.exists()) {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStream fileContent = UtilsDecryption.getFileInputStream((File)file);){
                        return new BufferedReader(new InputStreamReader(fileContent, StandardCharsets.US_ASCII)).lines().collect(Collectors.toList());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.severe("Error while reading the file:" + file.getName() + e.getMessage());
                }
            } else {
                LOGGER.severe("The required file doesn't exists:" + file.getName());
            }
        }
        return new ArrayList<String>();
    }

    public boolean getSkipDownload() {
        ValidationContext context = ValidationContext.getInstance();
        ExecutionPresentationModel executionModel = context.getData().getExecution();
        if (executionModel != null) {
            return executionModel.getSkipDownload();
        }
        return false;
    }

    public boolean validationEnded() {
        ValidationContext context = ValidationContext.getInstance();
        return VSessionModel.VEventPhase.VALIDATION_END.equals((Object)context.getEventPhase());
    }

    public String getSoc() {
        ValidationContext context = ValidationContext.getInstance();
        return context.getCpuVariant();
    }

    public String getSocFamily() {
        ValidationContext context = ValidationContext.getInstance();
        return context.getCpuFamily();
    }

    public String getModeId() {
        IConfigProvider context = ValidationContext.getInstance().getConfigController();
        if (context != null) {
            IComponentInstanceConfig instance = context.getInstance(context.getCurrentInstanceName());
            return instance != null ? instance.getMode().getId() : "";
        }
        return "";
    }

    public String getSelectedCoreId() {
        ProcessorCore selectedCore = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getSelectedCore();
        return selectedCore != null ? selectedCore.getID() : "";
    }

    public String getTestExecutablesDir() {
        return Activator.getDefault().getConfigManager().getTestExecutablesDir();
    }

    public String getTestScriptsDir() {
        return Activator.getDefault().getConfigManager().getScriptsFolder();
    }

    public String getSymbolFromBinary(String binaryFile, String symbol) {
        String address = "";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(binaryFile), Charset.defaultCharset()));){
                String line = reader.readLine();
                while (line != null) {
                    if (line.contains(symbol)) {
                        String[] cols = line.split("( )+");
                        address = cols[2];
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error while reading the file:" + binaryFile + e.getMessage());
        }
        return address;
    }

    public @com.nxp.swtools.common.utils.Nullable IRegistersDatabaseAPI getRegistersDB() {
        return null;
    }

    public String getConfigurationReport() {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null) {
            return configController.getConfigurationReport();
        }
        return "";
    }

    public void setDdrcConfigSeq(List<List<String>> list) {
    }

    public String getSelectedStageName() {
        ValidationContext context = ValidationContext.getInstance();
        VStagePresentation vStage = context.getData().getSelectedStage();
        return vStage != null ? vStage.getName() : "";
    }

    public String getSelectedScenarioName() {
        ValidationContext context = ValidationContext.getInstance();
        VStagePresentation vStage = context.getData().getSelectedStage();
        if (vStage != null) {
            VScenarioPresentation selectedScenario = vStage.getSelectedScenario();
            return selectedScenario != null ? selectedScenario.getModel().getName() : "";
        }
        return "";
    }

    public int getNumberOfSelectedScenarios() {
        VStage vStage;
        ValidationContext vContext = ValidationContext.getInstance();
        VSessionModel vSession = vContext.getData().getSession();
        if (vSession != null && (vStage = vSession.getStage()) != null) {
            return vStage.extractSelectedScenarios().length;
        }
        return 0;
    }

    public boolean anyTestFailed() {
        ValidationContext vContext = ValidationContext.getInstance();
        VSessionModel.VEvent event = vContext.getEvent();
        VTable[] vTableArray = event.getTables();
        int n = vTableArray.length;
        int n2 = 0;
        while (n2 < n) {
            VTable table = vTableArray[n2];
            if (table.hasFailingCells()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getResourcesPath() {
        String resourcesPath = "";
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("resources"), null);
        if (url != null) {
            try {
                URI uri = FileLocator.toFileURL((URL)url).toURI();
                if (uri != null) {
                    resourcesPath = Paths.get(uri).toString();
                }
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                LOGGER.severe("[TOOL] Could not read" + resourcesPath + e.getMessage());
            }
        }
        return resourcesPath;
    }

    public boolean getInputFileState(String id) {
        VScriptParamValue inputFileValue = ValidationScriptProfile.getScriptProperty(id);
        if (inputFileValue instanceof VScriptFileParamValue) {
            return ((VScriptFileParamValue)inputFileValue).isEnabled();
        }
        return false;
    }

    public String getInputFilePath(String id) {
        VScriptParamValue inputFileValue = ValidationScriptProfile.getScriptProperty(id);
        if (inputFileValue instanceof VScriptFileParamValue) {
            return ((VScriptFileParamValue)inputFileValue).getPath();
        }
        return "";
    }

    public boolean isRunningInEclipseIde() {
        return SWToolsPlatform.isRunningInEclipseIde();
    }
}

