/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.codgen;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import java.io.File;
import java.util.Map;
import java.util.Objects;

public class Template {
    protected String id;
    protected TemplateType type;
    @Nullable
    protected TemplateFile defaultFile;
    protected TemplateFile[] files;
    private boolean exclusive = true;
    private boolean allowEmpty = false;

    public Template(String _id, TemplateType _type, @Nullable TemplateFile _defaultFile, TemplateFile[] _files, boolean _exclusive, boolean _allowEmpty) {
        this.id = _id;
        this.type = _type;
        this.defaultFile = _defaultFile;
        this.files = (TemplateFile[])_files.clone();
        this.exclusive = _exclusive;
        this.allowEmpty = _allowEmpty;
    }

    public boolean allowEmpty() {
        return this.allowEmpty;
    }

    public @Nullable TemplateFile getDefaultFile() {
        return this.defaultFile;
    }

    public @Nullable TemplateFile getFile() {
        return this.files.length > 0 ? this.files[0] : null;
    }

    public TemplateFile[] getFiles() {
        return (TemplateFile[])this.files.clone();
    }

    public String getId() {
        return this.id;
    }

    public TemplateType getType() {
        return this.type;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public static class TemplateFile {
        private String templateId;
        @Nullable
        private String path;
        private CgenManager.CgenSegment[] segments = new CgenManager.CgenSegment[0];
        private long timestamp;

        public TemplateFile(String _templateId, @Nullable String _path) {
            this.templateId = _templateId;
            this.path = _path;
            this.timestamp = System.currentTimeMillis();
        }

        public String fill(Map<String, String> params) {
            StringBuilder buff = new StringBuilder();
            CgenManager.CgenSegment[] cgenSegmentArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (n2 < n) {
                CgenManager.CgenSegment segment = cgenSegmentArray[n2];
                buff.append(segment.getType() == CgenManager.CgenSegment.CgenSegmentType.LINE_SEP || segment.getType() == CgenManager.CgenSegment.CgenSegmentType.TEXT ? segment.getValue() : params.get(segment.value));
                ++n2;
            }
            return buff.toString();
        }

        public long getModifiedTimestamp() {
            return new File(Objects.requireNonNull(this.path)).lastModified();
        }

        public @Nullable String getPath() {
            return this.path;
        }

        public CgenManager.CgenSegment[] getSegments() {
            return (CgenManager.CgenSegment[])this.segments.clone();
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public void setId(String _id) {
            this.templateId = _id;
        }

        public void setPath(String newPath) {
            this.path = newPath;
        }

        public void setSegments(CgenManager.CgenSegment[] _segments) {
            this.segments = (CgenManager.CgenSegment[])_segments.clone();
        }

        public void setTimestamp(long _timestamp) {
            this.timestamp = _timestamp;
        }

        public String toString() {
            return String.format(Messages.Template_0, this.templateId);
        }

        public boolean wasModified() {
            return this.timestamp - this.getModifiedTimestamp() < 0L;
        }
    }

    public static enum TemplateType {
        CONFIG_INIT("init"),
        TEST_SCRIPTS("scripts"),
        USER_TEST_SCRIPTS("user_scripts");

        public final String dir;

        private TemplateType(String _dir) {
            this.dir = _dir;
        }
    }
}

