/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import com.freescale.s32ds.cdt.core.FSLErrorParserExtensionManagerUtils;
import com.freescale.s32ds.cdt.core.Messages;
import com.freescale.s32ds.cdt.core.internal.errorparsers.FSLRegexErrorParser;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.errorparsers.ErrorParserNamedWrapper;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSLErrorParserExtensionManager {
    private static final String DEFAULT_IDS_FOR_ERRORPARSER = "errorparser.default.ids";
    private static final String EMPTY_LINE = "";
    private static final String ELEMENT_PLUGIN = "plugin";
    private static final String S32DS_ERRORPARSER_EXTENSIONS_LOCATION = "model.extensions.xml";
    private static final String TEST_PLUGIN_ID = "org.eclipse.cdt.core.tests";
    private static final String DEPRECATED = CCorePlugin.getResourceString((String)"CCorePlugin.Deprecated");
    private static final LinkedHashMap<String, IErrorParserNamed> extensionId2ExtensionErrorParsers = new LinkedHashMap();
    private static final LinkedHashMap<String, IErrorParserNamed> parserId2AvailableErrorParsers = new LinkedHashMap();
    private static final Map<String, Set<String>> fErrorParserContextsMap = new HashMap<String, Set<String>>();
    private static LinkedHashMap<String, IErrorParserNamed> fUserDefinedErrorParsersMap = null;
    private static List<String> fDefaultErrorParserIds = null;

    static {
        FSLErrorParserExtensionManager.loadUserDefinedErrorParsers();
        FSLErrorParserExtensionManager.loadDefaultErrorParserIds();
        FSLErrorParserExtensionManager.loadErrorParserExtensions();
    }

    public static synchronized void loadUserDefinedErrorParsers() {
        fUserDefinedErrorParsersMap = null;
        Document document = null;
        try {
            document = XmlUtil.loadXml((URI)FSLErrorParserExtensionManager.getStoreURI(S32DS_ERRORPARSER_EXTENSIONS_LOCATION));
        }
        catch (Exception e) {
            CCorePlugin.log((String)(String.valueOf(Messages.FSLErrorParserExtensionManager_CantLoadPreferencesFrom) + S32DS_ERRORPARSER_EXTENSIONS_LOCATION), (Throwable)e);
        }
        if (document != null) {
            TreeSet<IErrorParserNamed> sortedParsers = new TreeSet<IErrorParserNamed>(new ErrorParserComparator());
            FSLErrorParserExtensionManagerUtils.loadExtensions(document, sortedParsers);
            if (!sortedParsers.isEmpty()) {
                fUserDefinedErrorParsersMap = new LinkedHashMap();
                for (IErrorParserNamed errorParser : sortedParsers) {
                    fUserDefinedErrorParsersMap.put(errorParser.getId(), errorParser);
                }
            }
        }
        FSLErrorParserExtensionManager.refreshAvailableErrorParsers();
    }

    public static synchronized void loadDefaultErrorParserIds() {
        fDefaultErrorParserIds = null;
        IEclipsePreferences eclipsePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
        String iDs = eclipsePreferences.get(DEFAULT_IDS_FOR_ERRORPARSER, EMPTY_LINE);
        if (iDs.equals(EMPTY_LINE)) {
            return;
        }
        fDefaultErrorParserIds = Arrays.asList(iDs.split(String.valueOf(';')));
    }

    private static void refreshAvailableErrorParsers() {
        IErrorParserNamed errorParser;
        parserId2AvailableErrorParsers.clear();
        ArrayList<String> iDs = new ArrayList<String>();
        if (fDefaultErrorParserIds != null) {
            FSLErrorParserExtensionManager.findeAvaliableParsers(iDs);
        }
        TreeSet<IErrorParserNamed> sortedErrorParsers = new TreeSet<IErrorParserNamed>(new ErrorParserComparator());
        if (fUserDefinedErrorParsersMap != null) {
            for (String id : fUserDefinedErrorParsersMap.keySet()) {
                if (iDs.contains(id)) continue;
                errorParser = fUserDefinedErrorParsersMap.get(id);
                sortedErrorParsers.add(errorParser);
            }
        }
        for (String id : extensionId2ExtensionErrorParsers.keySet()) {
            if (iDs.contains(id)) continue;
            errorParser = extensionId2ExtensionErrorParsers.get(id);
            sortedErrorParsers.add(errorParser);
        }
        for (IErrorParserNamed errorParser2 : sortedErrorParsers) {
            parserId2AvailableErrorParsers.put(errorParser2.getId(), errorParser2);
        }
    }

    private static void findeAvaliableParsers(List<String> iDs) {
        for (String id : fDefaultErrorParserIds) {
            IErrorParserNamed iErrorParserNamed = null;
            if (fUserDefinedErrorParsersMap != null) {
                iErrorParserNamed = fUserDefinedErrorParsersMap.get(id);
            }
            if (iErrorParserNamed == null) {
                iErrorParserNamed = extensionId2ExtensionErrorParsers.get(id);
            }
            if (iErrorParserNamed == null) continue;
            parserId2AvailableErrorParsers.put(id, iErrorParserNamed);
            iDs.add(id);
        }
    }

    public static synchronized void loadErrorParserExtensions() {
        TreeSet<IErrorParserNamed> errorParserNameds = new TreeSet<IErrorParserNamed>(new ErrorParserComparator());
        FSLErrorParserExtensionManagerUtils.loadErrorParserExtensions(Platform.getExtensionRegistry(), errorParserNameds, fErrorParserContextsMap);
        extensionId2ExtensionErrorParsers.clear();
        for (IErrorParserNamed iErrorParserNamed : errorParserNameds) {
            extensionId2ExtensionErrorParsers.put(iErrorParserNamed.getId(), iErrorParserNamed);
        }
        FSLErrorParserExtensionManager.refreshAvailableErrorParsers();
    }

    public static void serializeDefinedErrorParsers() throws CoreException {
        try {
            URI uri = FSLErrorParserExtensionManager.getStoreURI(S32DS_ERRORPARSER_EXTENSIONS_LOCATION);
            String eol = Util.getLineSeparator((URI)uri);
            if (eol == null) {
                eol = Util.getDefaultLineSeparator();
            }
            Document document = XmlUtil.newDocument();
            Element element = XmlUtil.appendElement((Node)document, (String)ELEMENT_PLUGIN);
            if (fUserDefinedErrorParsersMap != null) {
                for (Map.Entry<String, IErrorParserNamed> entry : fUserDefinedErrorParsersMap.entrySet()) {
                    IErrorParserNamed errorParser = entry.getValue();
                    FSLErrorParserExtensionManagerUtils.addErrorParserExtension(element, errorParser);
                }
            }
            XmlUtil.serializeXml((Document)document, (URI)uri, (String)eol);
        }
        catch (Exception e) {
            throw new CoreException(CCorePlugin.createStatus((String)Messages.bind((String)Messages.FSLErrorParserExtensionManager_FailedSerializingToFile, (Object)S32DS_ERRORPARSER_EXTENSIONS_LOCATION), (Throwable)e));
        }
    }

    public static String[] getErrorParserAvailableIdsInContext(String context) {
        ArrayList<String> iDs = new ArrayList<String>();
        Set<String> keySet = parserId2AvailableErrorParsers.keySet();
        for (String id : keySet) {
            if (!FSLErrorParserExtensionManager.getContextOfErrorParsers(id).contains(context)) continue;
            iDs.add(id);
        }
        int size = iDs.size();
        return iDs.toArray(new String[size]);
    }

    public static void serializeDefaultErrorParserIds() throws BackingStoreException {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
        String ids = EMPTY_LINE;
        if (fDefaultErrorParserIds != null) {
            ids = ErrorParserManager.toDelimitedString((String[])fDefaultErrorParserIds.toArray(new String[0]));
        }
        preferences.put(DEFAULT_IDS_FOR_ERRORPARSER, ids);
        preferences.flush();
    }

    private static URI getStoreURI(String store) {
        IPath location = CCorePlugin.getDefault().getStateLocation().append(store);
        return URIUtil.toURI((IPath)location);
    }

    public static IErrorParser getErrorParserInternal(String id) {
        IErrorParserNamed iErrorParserNamed = parserId2AvailableErrorParsers.get(id);
        if (iErrorParserNamed instanceof ErrorParserNamedWrapper) {
            return ((ErrorParserNamedWrapper)iErrorParserNamed).getErrorParser();
        }
        return iErrorParserNamed;
    }

    public static void setUserDefinedErrorParsers(IErrorParserNamed[] errorParsers) throws CoreException {
        FSLErrorParserExtensionManager.setDefinedErrorParsersInternal(errorParsers);
        FSLErrorParserExtensionManager.serializeDefinedErrorParsers();
    }

    public static void setDefinedErrorParsersInternal(IErrorParserNamed[] errorParsers) {
        if (errorParsers == null) {
            fUserDefinedErrorParsersMap = null;
        } else {
            TreeSet<IErrorParserNamed> sortedErrorParsers = new TreeSet<IErrorParserNamed>(new ErrorParserComparator());
            sortedErrorParsers.addAll(Arrays.asList(errorParsers));
            fUserDefinedErrorParsersMap = new LinkedHashMap();
            for (IErrorParserNamed errorParser : sortedErrorParsers) {
                fUserDefinedErrorParsersMap.put(errorParser.getId(), errorParser);
            }
        }
        FSLErrorParserExtensionManager.refreshAvailableErrorParsers();
    }

    public static String[] getErrorParserAvailableIds() {
        return parserId2AvailableErrorParsers.keySet().toArray(new String[parserId2AvailableErrorParsers.size()]);
    }

    public static String[] getErrorParserExtensionIds() {
        return extensionId2ExtensionErrorParsers.keySet().toArray(new String[extensionId2ExtensionErrorParsers.size()]);
    }

    public static String[] getUserDefinedErrorParserIds() {
        if (fUserDefinedErrorParsersMap != null) {
            return fUserDefinedErrorParsersMap.keySet().toArray(new String[0]);
        }
        return null;
    }

    public static void setDefaultErrorParserIds(String[] ids) throws BackingStoreException {
        FSLErrorParserExtensionManager.setDefaultErrorParserIdsInternal(ids);
        FSLErrorParserExtensionManager.serializeDefaultErrorParserIds();
    }

    public static void setDefaultErrorParserIdsInternal(String[] ids) {
        fDefaultErrorParserIds = ids != null ? new ArrayList<String>(Arrays.asList(ids)) : null;
        FSLErrorParserExtensionManager.refreshAvailableErrorParsers();
    }

    public static String[] getDefaultErrorParserIds() {
        if (fDefaultErrorParserIds == null) {
            Set<String> keySet = parserId2AvailableErrorParsers.keySet();
            int size = parserId2AvailableErrorParsers.size();
            return keySet.toArray(new String[size]);
        }
        int size = fDefaultErrorParserIds.size();
        return fDefaultErrorParserIds.toArray(new String[size]);
    }

    public static IErrorParserNamed getErrorParserCopy(String iD, boolean isExtension) {
        IErrorParserNamed errorParserNamed = FSLErrorParserExtensionManager.getErrorParserNamed(iD, isExtension);
        try {
            if (errorParserNamed instanceof ErrorParserNamedWrapper) {
                return (ErrorParserNamedWrapper)((ErrorParserNamedWrapper)errorParserNamed).clone();
            }
            if (errorParserNamed instanceof FSLRegexErrorParser) {
                return (FSLRegexErrorParser)((Object)((FSLRegexErrorParser)errorParserNamed).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            CCorePlugin.log((Throwable)e);
        }
        return errorParserNamed;
    }

    private static IErrorParserNamed getErrorParserNamed(String iD, boolean isExtension) {
        IErrorParserNamed errorParserNamed = isExtension ? extensionId2ExtensionErrorParsers.get(iD) : parserId2AvailableErrorParsers.get(iD);
        return errorParserNamed;
    }

    private static Collection<String> getContextOfErrorParsers(String id) {
        Set<String> contexts = fErrorParserContextsMap.get(id);
        if (contexts == null) {
            return Collections.singletonList("build");
        }
        return contexts;
    }

    private static class ErrorParserComparator
    implements Comparator<IErrorParserNamed>,
    Serializable {
        private ErrorParserComparator() {
        }

        @Override
        public int compare(IErrorParserNamed errorParser1, IErrorParserNamed errorParser2) {
            boolean plugin1 = errorParser1.getId().startsWith(FSLErrorParserExtensionManager.TEST_PLUGIN_ID);
            boolean plugin2 = errorParser2.getId().startsWith(FSLErrorParserExtensionManager.TEST_PLUGIN_ID);
            int more = 1;
            int less = -1;
            if (plugin1 && !plugin2) {
                return more;
            }
            if (!plugin1 && plugin2) {
                return less;
            }
            boolean deprecated1 = errorParser1.getName().contains(DEPRECATED);
            boolean deprecated2 = errorParser2.getName().contains(DEPRECATED);
            if (deprecated1 && !deprecated2) {
                return more;
            }
            if (!deprecated1 && deprecated2) {
                return less;
            }
            return errorParser1.getName().compareTo(errorParser2.getName());
        }
    }
}

