/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.gdb;

import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class RemoteCApplicationLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    public static final String BUNDLE_ID = "com.nxp.s32ds.cle.cdt.debugger.gdb";
    private static final String DEBUGGER_ID = "gdb";
    private static final String REMOTE_C_APPLICATION_LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.cdt.launch.remoteApplicationLaunchType";
    private static final String ATTR_DSF_GDB_DEBUG_NAME = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String component;
        IResource launchResource;
        ILaunchConfigurationType debuggerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(REMOTE_C_APPLICATION_LAUNCH_CONFIGURATION_TYPE_ID);
        if (debuggerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(component = LaunchConfigurationUtil.extractComponent(attributes)) + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = debuggerLaunchType.newInstance((IContainer)container, component);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workConfig, Map<String, Object> attributes) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        String toolchainId = LaunchConfigurationUtil.extractHardwareToolchainId(attributes);
        String buildArtifact = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        workConfig.setMappedResources(new IResource[]{project});
        workConfig.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workConfig.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        String extractHardwareDeviceCoreId = LaunchConfigurationUtil.extractHardwareDeviceCoreId(attributes);
        workConfig.setAttribute(ATTR_DSF_GDB_DEBUG_NAME, LaunchConfigurationUtil.getGDBClientValue((String)extractHardwareDeviceCoreId, (String)DEBUGGER_ID, (String)toolchainId));
        workConfig.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, String.format("/home/%s", Paths.get(buildArtifact, new String[0]).getFileName().toString()));
        workConfig.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, String.format("cd /home", Paths.get(buildArtifact, new String[0]).getFileName().toString()));
    }
}

