/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.internal.ui.wizards;

import com.nxp.s32ds.cle.cdt.project.info.core.imports.ProjectInfoImportSettings;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.ProjectInfoImporter;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.ProjectImportUIActivator;
import com.nxp.s32ds.cle.cdt.project.info.internal.ui.wizards.ImportProjectInfoPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizard;

public class ProjectInfoImportWizard
extends ExternalProjectImportWizard {
    protected ImportProjectInfoPage page;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ProjectInfoImportWizard_wizard_title);
        this.page = new ImportProjectInfoPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        ProjectInfoImportSettings settings = this.page.getSettings();
        try {
            this.getContainer().run(true, false, monitor -> {
                try {
                    new ProjectInfoImporter(settings).createProject(monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            ProjectImportUIActivator.getDefault().logWarning(Messages.ProjectInfoImportWizard_project_creation_interruptted);
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String title = Messages.ProjectInfoImportWizard_project_creation_title;
            if (t instanceof CoreException) {
                CoreException ex = (CoreException)t;
                if (275 == ex.getStatus().getCode()) {
                    MessageDialog.open((int)1, (Shell)this.getShell(), (String)title, (String)NLS.bind((String)Messages.ProjectInfoImportWizard_name_0_conflicts_existing, (Object)settings.getProjectName()), (int)0x10000000);
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)Messages.ProjectInfoImportWizard_error_project_creation, (IStatus)ex.getStatus());
                }
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)Messages.ProjectInfoImportWizard_error_project_creation, (IStatus)new Status(4, ProjectImportUIActivator.getDefault().getBundleId(), e.getMessage(), (Throwable)e));
            }
            return false;
        }
        return true;
    }
}

