/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.core;

import com.nxp.s32ds.debug.ide.core.DebuggerLaunchSequence;
import com.nxp.s32ds.debug.ide.core.S32DSGdbServerProcess;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.internal.core.S32DebuggerLaunchSequence;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_12;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class S32DebuggerGdbControl
extends GDBControl_7_12 {
    private static final String PATTERN_EXECUTING = ".*-thread-select 1.*";
    private static final String PATTERN_BREAKPOINT_HIT = ".*stopped,reason=.*";
    private static final String PATTERN_HARDWARE_RESOURCES_ERROR = ".*There are not enough available hardware resources for this watchpoint.*|.*Hardware breakpoints used exceeds limit.*";
    private static final String PATTERN_SECURE_KEY = "py _SECURE_KEY";
    private static final String HANDLER_HARDWARE_RESOURCES_ERRORS = "com.nxp.s32ds.debug.ide.s32debugger.ui.hardwareErrorStatusHandler";
    private static final String DEBUGGER_304_ERROR = ".*\\[S32Debugger\\]Error: 304.*";
    protected DebuggerLaunchSequence lSequence;
    private OutputStream consoleTracingStream = null;
    private OutputStream tracingStream = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String line = new String(b, off, len);
            b = S32DebuggerGdbControl.this.replaceKeywordIfNeeded(line, b);
            if (S32DebuggerGdbControl.this.consoleTracingStream != null) {
                S32DebuggerGdbControl.this.consoleTracingStream.write(b, off, len);
            }
            S32DebuggerGdbControl.this.checkTraceLineForPatterns(line);
        }
    };
    private boolean stoppedFirstTime = false;
    private boolean isExecuting = false;
    private volatile boolean streamClosed = false;
    private volatile boolean onShutdown = false;

    public S32DebuggerGdbControl(DsfSession session, ILaunchConfiguration config, CommandFactory factory) {
        super(session, config, factory);
        super.setMITracingStream(this.tracingStream);
    }

    protected void startCommandProcessing(InputStream inStream, final OutputStream outStream, InputStream errorStream) {
        OutputStream commandStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(ByteBuffer.allocate(4).putInt(b).array());
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                outStream.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                S32DebuggerGdbControl.this.streamClosed = true;
                super.close();
            }
        };
        super.startCommandProcessing(inStream, commandStream, errorStream);
    }

    protected void undoCommandMonitoringStep(RequestMonitor requestMonitor) {
        super.stopCommandProcessing();
        while (!this.streamClosed) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        requestMonitor.done();
    }

    protected Sequence getCompleteInitializationSequence(Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        this.lSequence = new S32DebuggerLaunchSequence(this.getSession(), attributes, rm);
        if (8 == rm.getStatus().getSeverity()) {
            throw new CancellationException();
        }
        return this.lSequence;
    }

    public void shutdown(RequestMonitor rm) {
        this.closeTracingStream();
        super.shutdown(rm);
    }

    public void setTracingStream(OutputStream tracingStream) {
        this.consoleTracingStream = tracingStream;
    }

    private void closeTracingStream() {
        this.setMITracingStream(null);
        try {
            this.tracingStream.close();
        }
        catch (IOException iOException) {
            S32DebuggerCoreActivator.getDefault().logError(S32DebuggerErrorMessages.S32DebuggerCannotCloseTracingStream_message);
        }
    }

    protected boolean matchPattern(String value, String patternStr) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    protected void checkTraceLineForPatterns(String line) {
        if (!this.isExecuting && this.matchPattern(line, PATTERN_EXECUTING)) {
            this.isExecuting = true;
        }
        if (this.isExecuting) {
            if (!this.stoppedFirstTime && this.matchPattern(line, PATTERN_BREAKPOINT_HIT)) {
                this.stoppedFirstTime = true;
                this.postStatus(1, "com.nxp.s32ds.debug.ide.s32debugger.group.launch.s32DebuggerGroupLaunchStatusHandler", "");
            }
            if (this.matchPattern(line, PATTERN_HARDWARE_RESOURCES_ERROR)) {
                this.postStatus(4, HANDLER_HARDWARE_RESOURCES_ERRORS, S32DebuggerErrorMessages.S32DebuggerGDBTracesConsole_message);
            }
            if (this.matchPattern(line, DEBUGGER_304_ERROR)) {
                this.isExecuting = false;
                this.onShutdown = true;
                DebugPlugin.getDefault().asyncExec(() -> S32DSGdbServerProcess.shutdownOnError());
            }
        }
    }

    private void postStatus(int severity, String handlerId, String message) {
        try {
            RcpStatusHandlers.handleStatus((String)handlerId, (IStatus)new Status(severity, S32DebuggerCoreActivator.getDefault().getBundleId(), message), (Object)this.getSession().getModelAdapter(ILaunch.class));
        }
        catch (CoreException coreException) {
            S32DebuggerCoreActivator.getDefault().logError(S32DebuggerErrorMessages.S32DebuggerCannotHandleStatusCall_message);
        }
    }

    private byte[] replaceKeywordIfNeeded(String line, byte[] b) {
        if (line.contains(PATTERN_SECURE_KEY)) {
            boolean replace = false;
            int i = line.indexOf(61);
            while (i < b.length) {
                if (replace) {
                    if (b[i] == 34) break;
                    b[i] = 42;
                } else if (b[i] == 34) {
                    replace = true;
                }
                ++i;
            }
        }
        return b;
    }

    public <V extends ICommandResult> ICommandToken queueCommand(ICommand<V> command, DataRequestMonitor<V> rm) {
        if (this.onShutdown) {
            rm.setStatus(S32DebuggerCoreActivator.getDefault().createWarning(S32DebuggerErrorMessages.S32DebuggerBoardConnection_connection_shut_down));
            rm.done();
            return null;
        }
        return super.queueCommand(command, rm);
    }
}

