/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.wizard.WizardArtifactType;
import com.freescale.s32ds.cross.wizard.backend.IWizardWithData;
import com.freescale.s32ds.cross.wizard.backend.WizardBackend;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.wizards.ICDTCommonProjectWizard;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.IWizardWithMemory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class S32DSAbstractWizard
extends Wizard
implements ICDTCommonProjectWizard,
IWizardWithData,
IWizardWithMemory,
IExecutableExtension,
INewWizard,
IWorkbenchWizard {
    public static final String TOOLCHAIN_VERSION = "toolchain_version";
    public static final String PROJECT_NAME_U = "PROJECT_NAME";
    public static final String TURN_ON_CPU = "TURN_ON_CPU";
    public static final String OP_FLASH_START = "FLASH_START";
    public static final String OP_RAM_START = "RAM_START";
    public static final String OP_PNE_ENABLED = "pne";
    public static final String OP_SEG_ENABLED = "segger";
    public static final String OP_GROUP_NAME = "GROUP_NAME";
    public static final String OP_DEVICE_NAME = "DEVICE_NAME";
    protected IWorkbench workbench;
    protected IConfigurationElement fConfigElement;
    private final String wizardDescription;
    private final String wizardTitle;
    private GeneralContext context;
    private final HWModel model;
    private final WizardBackend backend;
    private final WizardArtifactType type;

    protected S32DSAbstractWizard(String wizardTitle, String wizardDescription, WizardBackend backend, WizardArtifactType type) {
        this.wizardTitle = wizardTitle;
        this.wizardDescription = wizardDescription;
        this.model = Hardware.instance().getProductModel();
        if (this.model != null) {
            this.context = new GeneralContext(this.model);
        }
        this.backend = backend;
        this.type = type;
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(wizardTitle);
    }

    protected S32DSAbstractWizard(String wizardTitle, String wizardDescription, HWModel model, WizardBackend backend, WizardArtifactType type) {
        this.wizardTitle = wizardTitle;
        this.wizardDescription = wizardDescription;
        this.model = model;
        this.context = new GeneralContext(model);
        this.backend = backend;
        this.type = type;
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(wizardTitle);
    }

    public String getWizardDescription() {
        return this.wizardDescription;
    }

    public String getWizadrTitle() {
        return this.wizardTitle;
    }

    public HWModel getModel() {
        return this.model;
    }

    @Override
    public Map<String, String> getProjectData(ProjectContext projectContext) {
        return this.getBackend().getProjectData(projectContext);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setNeedsProgressMonitor(true);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.getBackend().setfConfigElement(config);
    }

    public IProject createIProject(String name, URI location) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IProject createIProject(String name, URI location, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String[] getNatures() {
        return new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature"};
    }

    public String[] getLanguageIDs() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        ArrayList<String> languageIDs = new ArrayList<String>();
        String[] stringArray = this.getContentTypeIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            ILanguage language;
            String typeId = stringArray[n2];
            IContentType contentType = manager.getContentType(typeId);
            if (contentType != null && (language = LanguageManager.getInstance().getLanguage(contentType)) != null && !languageIDs.contains(id = language.getId())) {
                languageIDs.add(id);
            }
            ++n2;
        }
        return languageIDs.toArray(new String[languageIDs.size()]);
    }

    public String[] getExtensions() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        ArrayList<String> extensions = new ArrayList<String>();
        String[] stringArray = this.getContentTypeIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String typeId = stringArray[n2];
            IContentType contentType = manager.getContentType(typeId);
            if (contentType != null) {
                extensions.addAll(Arrays.asList(contentType.getFileSpecs(8)));
            }
            ++n2;
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    public String[] getContentTypeIDs() {
        return new String[]{"org.eclipse.cdt.core.cSource", "org.eclipse.cdt.core.cHeader", "org.eclipse.cdt.core.cxxSource", "org.eclipse.cdt.core.cxxHeader"};
    }

    public String getLastProjectName() {
        throw new UnsupportedOperationException();
    }

    public URI getLastProjectLocation() {
        throw new UnsupportedOperationException();
    }

    public IProject getLastProject() {
        throw new UnsupportedOperationException();
    }

    public void addPages() {
        this.addPage(this.getStartingPage());
    }

    public boolean performCancel() {
        this.getBackend().clearProject();
        return true;
    }

    protected void selectAndReveal(IResource resource) {
        IWorkbenchWindow window;
        if (this.workbench == null) {
            this.workbench = PlatformUI.getWorkbench();
        }
        if ((window = this.workbench.getActiveWorkbenchWindow()) == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        List parts = Stream.concat(Arrays.stream(page.getViewReferences()), Arrays.stream(page.getEditorReferences())).map(r -> r.getPart(false)).filter(Objects::nonNull).collect(Collectors.toList());
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(() -> finalTarget.selectReveal((ISelection)new StructuredSelection((Object)resource)));
        }
    }

    public GeneralContext getContext() {
        return this.context;
    }

    public WizardBackend getBackend() {
        return this.backend;
    }

    public WizardArtifactType getType() {
        return this.type;
    }
}

