/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.providers;

import com.nxp.s32ds.cle.uct.core.Activator;
import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.exceptions.SDKException;
import com.nxp.s32ds.cle.uct.manifest.xml.BoardType;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreType;
import com.nxp.s32ds.cle.uct.manifest.xml.DebugConfigurationType;
import com.nxp.s32ds.cle.uct.manifest.xml.DebugType;
import com.nxp.s32ds.cle.uct.manifest.xml.DeviceType;
import com.nxp.s32ds.cle.uct.manifest.xml.ExampleType;
import com.nxp.s32ds.cle.uct.manifest.xml.ExamplesType;
import com.nxp.s32ds.cle.uct.manifest.xml.FileType;
import com.nxp.s32ds.cle.uct.manifest.xml.IdentifiableType;
import com.nxp.s32ds.cle.uct.manifest.xml.KsdkType;
import com.nxp.s32ds.cle.uct.manifest.xml.LinkerSettingType;
import com.nxp.s32ds.cle.uct.manifest.xml.LinkerSettingsType;
import com.nxp.s32ds.cle.uct.manifest.xml.Manifest;
import com.nxp.s32ds.cle.uct.manifest.xml.NatureType;
import com.nxp.s32ds.cle.uct.manifest.xml.PackageType;
import com.nxp.s32ds.cle.uct.manifest.xml.RoleType;
import com.nxp.s32ds.cle.uct.manifest.xml.SourceType;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainSettingType;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainSettingsType;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainType;
import com.nxp.s32ds.cle.uct.providers.CompareItem;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.providers.SDKManifestFilter;
import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import com.nxp.s32ds.cle.uct.providers.SDKSoftwareProvider;
import com.nxp.s32ds.cle.uct.providers.SDKUIUtils;
import com.nxp.s32ds.ext.orbit.jaxb.OrbitJAXBContextFactory;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.IStorableCdtVariables;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SDKManifest
implements ISDKManifest {
    private static final String KEY_INFO_DEVICE_VERSION = "device.version";
    private static final String KEY_INFO_DEVICE_ID = "device.id";
    private static final String KEY_INFO_SDK_ID = "sdk.id";
    private String packName = null;
    private Manifest instance;
    private boolean packLoaded;
    private boolean isLoaded;
    private boolean legacy = false;
    private final boolean isZip;
    private Object manifestPath;
    private Map<String, File> targetFolders = new HashMap<String, File>();
    private File supportFolder;
    private Map<SourceType, Image> cachedImages = new HashMap<SourceType, Image>();
    private boolean active;
    private IPreferenceStore store;
    private SDKManifestProvider provider = null;
    private ZipFile zipFile;
    private Set<ZipEntry> zipEntries;
    private Map<Object, Object> dataCache = new HashMap<Object, Object>();
    private Schema schema;
    static final SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static Map<ManifestFileItem, String> itemsMap = new HashMap<ManifestFileItem, String>();
    private static Map<ManifestFileItem, Schema> schemasMap = new HashMap<ManifestFileItem, Schema>();
    protected static final Logger LOGGER = LogManager.getLogger(SDKManifest.class);
    private Comparator<ManifestFileItem> manifestComparator = new Comparator<ManifestFileItem>(){

        @Override
        public int compare(ManifestFileItem o1, ManifestFileItem o2) {
            String v1 = "_v3_0";
            String v2 = "_v3_0";
            String n1 = o1.getName();
            String n2 = o2.getName();
            Pattern p = Pattern.compile(".*_manifest(_v[0-9]+_[0-9]+)?.xml");
            Matcher m = p.matcher(n1);
            if (m.find() && m.group(1) != null) {
                v1 = m.group(1);
            }
            if ((m = (p = Pattern.compile(".*_manifest(_v[0-9]+_[0-9]+)?.xml")).matcher(n2)).find() && m.group(1) != null) {
                v2 = m.group(1);
            }
            Version version1 = new Version(v1.replace("_v", "").replace("_", "."));
            Version version2 = new Version(v2.replace("_v", "").replace("_", "."));
            return version1.compareTo(version2);
        }
    };
    private ManifestFileItem manifestFileItem;
    private List<ManifestFileItem> manifestsFiles = new ArrayList<ManifestFileItem>();
    private List<ManifestFileItem> manifestChildFiles = new ArrayList<ManifestFileItem>();

    public SDKManifest(String packName, SDKManifestProvider provider) throws IOException, SAXException, SDKException {
        this.provider = provider;
        this.packName = packName;
        this.isZip = packName.endsWith(".zip");
        this.supportFolder = SDKManifestProvider.getBaseSupportFolder();
        this.store = Activator.getDefault().getPreferenceStore();
        if (!this.packLoaded) {
            try {
                this.loadManifest();
            }
            catch (IOException | JAXBException e) {
                LOGGER.log(Level.INFO, e.getMessage(), e);
            }
        }
        if (this.packLoaded) {
            for (DeviceType device : this.getDevices()) {
                String name = SDKManifestProvider.getDeviceSupportName(device);
                File targetFolder = new File(this.supportFolder, String.valueOf(name) + "_support");
                this.targetFolders.put(name, targetFolder);
            }
            String list = this.store.getString("sdk.manifest.active.pref");
            this.active = list == null || !list.contains(this.getManifestSimpleName());
            this.refreshVariables();
        } else {
            this.dispose();
        }
    }

    public static boolean isLegacySDK(ISDKManifest pack) {
        Version version;
        boolean legacy = false;
        if (pack != null && !pack.getSchemaVersion().isEmpty() && (version = new Version(pack.getSchemaVersion())).compareTo(ISDKManifest.MANIFEST_LEGACY_VERSION) <= 0) {
            legacy = true;
        }
        return legacy;
    }

    private void clearVariables() {
        if (!this.isZip && this.manifestPath instanceof java.nio.file.Path) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPathVariableManager pathMan = workspace.getPathVariableManager();
            if (pathMan.validateName(this.getVariableName(false)).isOK()) {
                try {
                    pathMan.setURIValue(this.getVariableName(false), null);
                    IStorableCdtVariables macros = CCorePlugin.getUserVarSupplier().getWorkspaceVariablesCopy();
                    macros.deleteMacro(this.getVariableName(false));
                    CCorePlugin.getUserVarSupplier().setWorkspaceVariables(macros);
                    CCorePlugin.getUserVarSupplier().storeWorkspaceVariables(true);
                }
                catch (CoreException coreException) {
                    String message = NLS.bind((String)Messages.SDKManifest_InvalidName, (Object[])new Object[]{this.getVariableName(false), this.getManifestSimpleName()});
                    LOGGER.log(Level.SEVERE, message);
                }
            } else {
                String message = NLS.bind((String)Messages.SDKManifest_InvalidName, (Object[])new Object[]{this.getVariableName(false), this.getManifestSimpleName()});
                LOGGER.log(Level.SEVERE, message);
            }
        }
    }

    private void refreshVariables() {
        if (!this.isZip && this.manifestPath instanceof java.nio.file.Path) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPathVariableManager pathMan = workspace.getPathVariableManager();
            String path = ((java.nio.file.Path)this.manifestPath).getParent().toString().replace("\\", "/");
            Path value = new Path(path);
            if (pathMan.validateName(this.getVariableName(false)).isOK() && pathMan.validateValue((IPath)value).isOK()) {
                try {
                    pathMan.setURIValue(this.getVariableName(false), value.toFile().toURI());
                    IStorableCdtVariables macros = CCorePlugin.getUserVarSupplier().getWorkspaceVariablesCopy();
                    macros.createMacro(this.getVariableName(false), 5, value.toOSString());
                    CCorePlugin.getUserVarSupplier().setWorkspaceVariables(macros);
                    CCorePlugin.getUserVarSupplier().storeWorkspaceVariables(true);
                }
                catch (CoreException coreException) {
                    String message = NLS.bind((String)Messages.SDKManifest_InvalidNameOrValue, (Object[])new Object[]{this.getVariableName(false), value, this.getManifestSimpleName()});
                    LOGGER.log(Level.SEVERE, message);
                }
            } else {
                String message = NLS.bind((String)Messages.SDKManifest_InvalidNameOrValue, (Object[])new Object[]{this.getVariableName(false), value, this.getManifestSimpleName()});
                LOGGER.log(Level.SEVERE, message);
            }
        }
    }

    @Override
    public String getVariableName(boolean quote) {
        if (quote) {
            return CdtVariableResolver.createVariableReference((String)this.getVariableName(false));
        }
        return this.getManifestSimpleName().replace(".", "_").replace("-", "_");
    }

    @Override
    public SDKManifestProvider getProvider() {
        return this.provider;
    }

    @Override
    public File getSupportFolder(DeviceType device) {
        String name = SDKManifestProvider.getDeviceSupportName(device);
        return this.targetFolders.get(name);
    }

    @Override
    public String getManifestName() {
        return this.packName;
    }

    @Override
    public void loadManifest() throws IOException, JAXBException {
        if (!this.packLoaded) {
            if (this.isZip) {
                this.loadManifestAsZip();
            } else {
                this.loadManifestAsFolder();
            }
        }
    }

    private void loadManifestAsFolder() throws IOException, JAXBException {
        java.nio.file.Path dir = Paths.get(this.packName, new String[0]);
        this.manifestsFiles.clear();
        this.manifestChildFiles.clear();
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<java.nio.file.Path> stream = Files.newDirectoryStream(dir);){
            for (java.nio.file.Path entry : stream) {
                File file = entry.toFile();
                if (file == null) continue;
                this.addManifestFiles(file.getName(), entry);
            }
            stream.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Collections.sort(this.manifestsFiles, this.manifestComparator);
        if (!this.manifestsFiles.isEmpty()) {
            this.manifestPath = this.getLatestSupported(this.manifestsFiles);
            this.buildModel();
            this.packLoaded = true;
        }
    }

    @Override
    public String getSchemaVersion() {
        if (this.manifestFileItem != null) {
            return this.manifestFileItem.getVersion().toString();
        }
        return "";
    }

    @Override
    public ManifestFileItem getManifestFileItem() {
        return this.manifestFileItem;
    }

    @Override
    public Object getManifestFileName(boolean addPath) {
        if (this.manifestFileItem != null && addPath) {
            return this.manifestFileItem.getManifestPath();
        }
        return this.packName;
    }

    /*
     * Unable to fully structure code
     */
    private Object getLatestSupported(List<ManifestFileItem> items) throws IOException {
        latest = true;
        error = false;
        manifestName = null;
        list = this.store.getString("sdk.manifest.versions.pref");
        if (this.store.getBoolean("sdk.manifests.versions.enabled")) {
            i = items.size() - 1;
            while (i >= 0) {
                zipFile = null;
                stream = null;
                if (this.isZip) {
                    zipFile = new ZipFile(this.packName);
                }
                try {
                    item = items.get(i);
                    if (item.getVersion().compareTo(SDKManifest.MANIFEST_HEAD) > 0) {
                        latest = false;
                        this.legacy = true;
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    } else {
                        jc = OrbitJAXBContextFactory.createContext(Manifest.class);
                        um = jc.createUnmarshaller();
                        root = um.unmarshal((Source)new StreamSource(stream = this.getManifestFile(item.getManifestPath(), zipFile)), Manifest.class);
                        manifestName = ((Manifest)root.getValue()).getId();
                        if (list.contains(manifestName)) {
                            pattern = String.valueOf(manifestName) + "=" + "([0-9]+\\.[0-9]+\\.[0-9]+)[;]?";
                            regex = Pattern.compile(pattern);
                            m = regex.matcher(list);
                            error = true;
                            if (m.find() && (versionToMatch = m.group(1)).equals(item.getVersion().toString())) {
                                if (!latest) {
                                    message = NLS.bind((String)Messages.SDKManifest_SDKManifestWillBeUsed, (Object)item.getName());
                                    SDKManifest.LOGGER.log(Level.WARNING, message);
                                } else {
                                    message = NLS.bind((String)Messages.SDKManifest_UsingSDKManifest, (Object)item.getName());
                                    SDKManifest.LOGGER.log(Level.WARNING, message);
                                }
                                this.manifestFileItem = item;
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                                var19_23 = item.getManifestPath();
                                return var19_23;
                            }
                        }
                    }
                }
                catch (JAXBException e) {
                    SDKManifest.LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                --i;
            }
        }
        if (error) {
            msg = NLS.bind((String)"Unable to find a matching manifest version for SDK ''{0}'' using ''{1}''", manifestName, (Object)list);
            SDKManifest.LOGGER.log(Level.WARNING, msg);
        }
        i = items.size() - 1;
        while (i >= 0) {
            block52: {
                block51: {
                    item = items.get(i);
                    stream = null;
                    if (item.getVersion().compareTo(SDKManifest.MANIFEST_HEAD) > 0) {
                        latest = false;
                        this.legacy = true;
                    } else {
                        block49: {
                            block50: {
                                block47: {
                                    block48: {
                                        status = new ArrayList<Status>();
                                        if (!SDKManifest.schemasMap.containsKey(item) || this.store.getBoolean("sdk.manifests.versions.enabled")) break block47;
                                        this.manifestFileItem = item;
                                        var18_31 = item.getManifestPath();
                                        if (stream == null) break block48;
                                        try {
                                            stream.close();
                                        }
                                        catch (IOException e) {
                                            SDKManifest.LOGGER.log(Level.SEVERE, e.getMessage(), e);
                                        }
                                    }
                                    return var18_31;
                                }
                                jc = OrbitJAXBContextFactory.createContext(Manifest.class);
                                um = jc.createUnmarshaller();
                                zipFile = null;
                                if (this.isZip) {
                                    zipFile = new ZipFile(this.packName);
                                }
                                stream = this.getManifestFile(item.getManifestPath(), zipFile);
                                checkedSchema = SDKManifest.validateSchema(status, um, new StreamSource(stream), "manifest-schema/sdk_manifest_v3.4.xsd");
                                stream.close();
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                                if (checkedSchema == null) break block49;
                                if (!latest) {
                                    message = NLS.bind((String)Messages.SDKManifest_SDKManifestWillBeUsed, (Object)item.getName());
                                    SDKManifest.LOGGER.log(Level.INFO, message);
                                } else {
                                    message = NLS.bind((String)Messages.SDKManifest_UsingSDKManifest, (Object)item.getName());
                                    SDKManifest.LOGGER.log(Level.INFO, message);
                                }
                                SDKManifest.schemasMap.put(item, checkedSchema);
                                this.manifestFileItem = item;
                                var18_32 = item.getManifestPath();
                                if (stream == null) break block50;
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    SDKManifest.LOGGER.log(Level.SEVERE, e.getMessage(), e);
                                }
                            }
                            return var18_32;
                        }
                        try {
                            try {
                                log = new MultiStatus("com.nxp.s32ds.cle.uct.core", 0, "Validation errors of manifest " + item.getManifestPath(), null);
                                for (Status s : status) {
                                    log.add((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", s.getMessage()));
                                }
                                SDKManifest.LOGGER.log(Level.INFO, log.getMessage());
                                latest = false;
                                this.legacy = true;
                                break block51;
                            }
                            catch (IOException | JAXBException | SAXException v0) {
                                latest = false;
                                this.legacy = true;
                                if (stream == null) ** GOTO lbl146
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    SDKManifest.LOGGER.log(Level.SEVERE, e.getMessage(), e);
                                }
                            }
                        }
                        catch (Throwable var17_22) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    SDKManifest.LOGGER.log(Level.SEVERE, e.getMessage(), e);
                                }
                            }
                            throw var17_22;
                        }
                    }
                    break block52;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        SDKManifest.LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            --i;
        }
        throw new IOException(String.valueOf(Messages.SDKManifest_UnableToFindManifest) + this.packName);
    }

    @Override
    public List<ManifestFileItem> getManifestsFiles() {
        return this.manifestsFiles;
    }

    private void loadManifestAsZip() throws IOException, JAXBException {
        ZipFile zipFile = new ZipFile(this.packName);
        this.manifestsFiles.clear();
        this.manifestChildFiles.clear();
        Enumeration<? extends ZipEntry> it = zipFile.entries();
        while (it.hasMoreElements()) {
            ZipEntry entry = it.nextElement();
            if (entry == null) continue;
            this.addManifestFiles(entry.getName(), entry);
        }
        Collections.sort(this.manifestsFiles, this.manifestComparator);
        try {
            if (!this.manifestsFiles.isEmpty()) {
                this.manifestPath = this.getLatestSupported(this.manifestsFiles);
                this.buildModel();
                this.packLoaded = true;
            }
        }
        finally {
            zipFile.close();
        }
    }

    private void buildModel() throws JAXBException, IOException {
        JAXBContext jc = OrbitJAXBContextFactory.createContext(Manifest.class);
        if (!this.isLoaded) {
            Unmarshaller um = jc.createUnmarshaller();
            ZipFile zipFile = null;
            if (this.isZip) {
                zipFile = new ZipFile(this.packName);
            }
            this.instance = this.readManifest(this.manifestPath, um, zipFile);
            if (this.instance != null) {
                Manifest localInstance = null;
                for (ManifestFileItem manifestFileItem : this.manifestChildFiles) {
                    localInstance = this.readManifest(manifestFileItem.getManifestPath(), um, zipFile);
                    if (localInstance == null || !this.instance.getKsdk().getVersion().equals(localInstance.getKsdk().getVersion()) || !this.instance.getKsdk().getId().equals(localInstance.getKsdk().getId())) continue;
                    this.instance.getComponents().getComponent().addAll(localInstance.getComponents().getComponent());
                }
            }
            if (zipFile != null) {
                zipFile.close();
            }
            this.isLoaded = true;
        }
    }

    @Override
    public Manifest getInstance() {
        return this.instance;
    }

    @Override
    public List<Status> validate() throws JAXBException, IOException, SAXException {
        SDKManifestProvider.SDKProviderType type;
        if (!this.packLoaded) {
            this.loadManifest();
        }
        JAXBContext jc = OrbitJAXBContextFactory.createContext(Manifest.class);
        Unmarshaller um = jc.createUnmarshaller();
        ZipFile zipFile = null;
        if (this.isZip) {
            zipFile = new ZipFile(this.packName);
        }
        InputStream stream = this.getManifestFile(this.manifestPath, zipFile);
        ArrayList<Status> status = new ArrayList<Status>();
        this.schema = SDKManifest.validateSchema(status, um, new StreamSource(stream), "manifest-schema/sdk_manifest_v3.4.xsd");
        stream.close();
        if (zipFile != null) {
            zipFile.close();
        }
        if (SDKManifestProvider.SDKProviderType.PROVIDER_INTERNAL.equals((Object)(type = this.provider.getProviderType())) || SDKManifestProvider.SDKProviderType.PROVIDER_PROJECT.equals((Object)type)) {
            status.clear();
        }
        return status;
    }

    public static Schema validateSchema(final List<Status> status, Object um, StreamSource source, String schemaToUse) throws SAXException, IOException {
        String[] stringArray;
        Exception lastException = null;
        if (schemaToUse == null) {
            stringArray = SCHEMAS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = schemaToUse;
        }
        String[] stringArray3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String schemaName = stringArray3[n2];
            try {
                status.clear();
                URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(schemaName), null);
                Schema schema = sf.newSchema(FileLocator.toFileURL((URL)url));
                if (um instanceof Unmarshaller) {
                    ((Unmarshaller)um).setSchema(schema);
                } else if (um instanceof Marshaller) {
                    ((Marshaller)um).setSchema(schema);
                } else {
                    throw new SAXException("Wrong unmarshaller/marchaller");
                }
                Validator validator = schema.newValidator();
                validator.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) throws SAXException {
                        status.add(new Status(2, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
                        LOGGER.warning(exception.getMessage());
                    }

                    @Override
                    public void fatalError(SAXParseException exception) throws SAXException {
                        status.add(new Status(4, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
                        LOGGER.severe(exception.getMessage());
                    }

                    @Override
                    public void error(SAXParseException exception) throws SAXException {
                        status.add(new Status(4, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
                        LOGGER.warning(exception.getMessage());
                    }
                });
                if (source != null) {
                    validator.validate(source, null);
                }
                return schema;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                lastException = e;
                ++n2;
            }
        }
        throw new SAXException(lastException);
    }

    @Override
    public List<BoardType> getBoards() {
        ArrayList<BoardType> boardList = new ArrayList<BoardType>();
        Manifest.Boards boards = this.instance.getBoards();
        if (boards != null) {
            boardList.addAll(boards.getBoard());
        }
        return boardList;
    }

    @Override
    public List<DeviceType> getDevices() {
        Manifest.Devices devices;
        ArrayList<DeviceType> devicesList = new ArrayList<DeviceType>();
        if (this.instance != null && (devices = this.instance.getDevices()) != null) {
            devicesList.addAll(devices.getDevice());
        }
        return devicesList;
    }

    @Override
    public List<BoardType> getSupportedBoards(DeviceType device) {
        ArrayList<BoardType> boardsList = new ArrayList<BoardType>();
        for (BoardType board : this.getBoards()) {
            List<PackageType> packages = device.getPackage();
            for (PackageType p : packages) {
                if (!board.getPackage().getId().equals(p.getId())) continue;
                boardsList.add(board);
            }
        }
        return boardsList;
    }

    @Override
    public List<ComponentType> getComponents(ComponentTypeEnum type, DeviceType device) {
        Manifest.Components components = this.instance.getComponents();
        ArrayList<ComponentType> result = new ArrayList<ComponentType>();
        if (components != null) {
            for (ComponentType component : components.getComponent()) {
                if (!type.equals((Object)component.getType()) || !SDKManifestProvider.isDeviceSupported(component, device) || !SDKManifestProvider.isToolchainSupported(component.getToolchain()) || !SDKManifestProvider.isCompilerSupported(component.getCompiler())) continue;
                result.add(component);
            }
        }
        return result;
    }

    public String toString() {
        return "" + this.manifestPath;
    }

    @Override
    public InputStream getResourceStream(String name, boolean external) throws IOException {
        if (this.isZip && !external) {
            name = name.replace(".//", "");
            name = name.replace("./", "");
            if (this.zipFile == null) {
                this.zipFile = new ZipFile(this.packName);
            }
            if (this.zipEntries == null) {
                Enumeration<? extends ZipEntry> it = this.zipFile.entries();
                this.zipEntries = new HashSet<ZipEntry>();
                while (it.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)it.nextElement();
                    this.zipEntries.add(entry);
                }
            }
            for (ZipEntry entry : this.zipEntries) {
                if (!entry.getName().endsWith(name) && !entry.getName().endsWith(name.replace("\\", "/"))) continue;
                return this.zipFile.getInputStream(entry);
            }
        } else {
            return new FileInputStream(String.valueOf(external ? "" : String.valueOf(this.packName) + File.separator) + name);
        }
        return null;
    }

    @Override
    public void importPackage(boolean recreate) throws FileNotFoundException, IOException, TransformerException, URISyntaxException {
    }

    public static int checkDeviceVersion(File targetFolder, String devId, String devVer, String sdkId) {
        String ver;
        String id;
        block4: {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(new File(targetFolder, "info.properties"));
            props.load(is);
            is.close();
            id = (String)props.get(KEY_INFO_DEVICE_ID);
            ver = (String)props.get(KEY_INFO_DEVICE_VERSION);
            if (sdkId == null || sdkId.equals(props.get(KEY_INFO_SDK_ID))) break block4;
            return -1;
        }
        try {
            if (devId.equals(id) && ver != null) {
                Version version = new Version(devVer);
                Version installedVersion = new Version(ver);
                return version.compareTo(installedVersion);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return -1;
    }

    private void doCopySource(List<String> files, File folder, SDKManifestFilter filter, String path, String mask, String osPath, Map<String, String> filesContent, File dest) throws IOException {
        this.scan(files, folder, filter, filter.adapt(path, mask));
        for (String entry : files) {
            if (entry.contains("$|")) {
                filesContent.put(String.valueOf(osPath) + File.separator + entry, Messages.SDKManifest_WarnSelResources);
                continue;
            }
            if (this.isZip()) {
                Object target;
                String name = new File(entry).getName();
                InputStream stream = this.getResourceStream(entry, false);
                if (dest != null) {
                    target = Paths.get(String.valueOf(dest.getPath()) + File.separator + name, new String[0]);
                    Files.copy(stream, (java.nio.file.Path)target, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    target = null;
                    Object var14_15 = null;
                    try (BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));){
                        filesContent.put(entry, buffer.lines().collect(Collectors.joining("\n")));
                    }
                    catch (Throwable throwable) {
                        if (target == null) {
                            target = throwable;
                        } else if (target != throwable) {
                            ((Throwable)target).addSuppressed(throwable);
                        }
                        throw target;
                    }
                }
                stream.close();
                continue;
            }
            java.nio.file.Path sourceFile = Paths.get(String.valueOf(osPath) + File.separator + entry, new String[0]);
            String name = new File(entry).getName();
            if (dest != null) {
                String actualFilePath = String.valueOf(dest.getPath()) + File.separator + name;
                File actualFile = new File(actualFilePath);
                if (actualFile.exists()) continue;
                FileOutputStream actualFileOutputStream = new FileOutputStream(actualFilePath);
                Files.copy(sourceFile, actualFileOutputStream);
                actualFileOutputStream.close();
                continue;
            }
            StringBuffer buffer = new StringBuffer();
            List<String> lines = Files.readAllLines(sourceFile);
            for (String line : lines) {
                buffer.append(String.valueOf(line) + "\n");
            }
            filesContent.put(sourceFile.toString(), buffer.toString());
        }
    }

    @Override
    public Map<String, String> copySourceType(File dest, SourceType source, SDKManifestFilter filter) {
        HashMap<String, String> filesContent = new HashMap<String, String>();
        if (source != null) {
            if (dest != null && !dest.exists()) {
                dest.mkdir();
            }
            String path = source.getPath();
            for (FileType file : source.getFiles()) {
                ArrayList<String> files = new ArrayList<String>();
                String mask = file.getMask();
                try {
                    String basePath = filter.basePath(path);
                    String osPath = this.getManifestName();
                    File folder = new File(String.valueOf(osPath) + File.separator + basePath);
                    this.doCopySource(files, folder, filter, path, mask, osPath, filesContent, dest);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return filesContent;
    }

    @Override
    public void copyExampleSourceType(File dest, SourceType source, SDKManifestFilter filter, String examplePath) {
        HashMap<String, String> filesContent = new HashMap<String, String>();
        if (source != null) {
            if (dest != null && !dest.exists()) {
                dest.mkdir();
            }
            String path = source.getPath();
            for (FileType file : source.getFiles()) {
                ArrayList<String> files = new ArrayList<String>();
                String mask = file.getMask();
                try {
                    String basePath = filter.basePath(path);
                    String osPath = String.valueOf(this.getManifestName()) + File.separator;
                    File folder = new File(String.valueOf(osPath) + File.separator + examplePath + File.separator + basePath);
                    this.doCopySource(files, folder, filter, path, mask, osPath, filesContent, dest);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
            this.zipFile = null;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        if (this.packLoaded) {
            this.clearVariables();
        }
        itemsMap.remove(this.manifestFileItem);
        schemasMap.remove(this.manifestFileItem);
    }

    @Override
    public InputStream getManifestFile() throws IOException {
        if (this.isZip) {
            int r;
            ZipFile zipFile = new ZipFile(this.packName);
            InputStream is = this.getManifestFile(this.manifestPath, zipFile);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((r = is.read(buf)) != -1) {
                bos.write(buf, 0, r);
            }
            is.close();
            zipFile.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            return bis;
        }
        return this.getManifestFile(this.manifestPath, null);
    }

    private InputStream getManifestFile(Object manifestPath, ZipFile zipFile) throws IOException {
        if (this.isZip && manifestPath instanceof ZipEntry) {
            InputStream stream = zipFile.getInputStream((ZipEntry)manifestPath);
            return stream;
        }
        if (!this.isZip && manifestPath instanceof java.nio.file.Path) {
            return Files.newInputStream((java.nio.file.Path)manifestPath, StandardOpenOption.READ);
        }
        return null;
    }

    @Override
    public boolean isZip() {
        return this.isZip;
    }

    @Override
    public String getManifestVersion(boolean sanitize) {
        if (!this.packLoaded) {
            try {
                this.loadManifest();
            }
            catch (IOException | JAXBException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.getInstance() != null) {
            String version = "UNKNOWN_VERSION";
            KsdkType ksdk = this.getInstance().getKsdk();
            if (ksdk != null && ksdk.getVersion() != null) {
                version = ksdk.getVersion();
            }
            if (sanitize) {
                return version.replace(".", "_");
            }
            return version;
        }
        return null;
    }

    @Override
    public String getManifestRevision() {
        if (!this.packLoaded) {
            try {
                this.loadManifest();
            }
            catch (IOException | JAXBException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.getInstance() != null) {
            String revision = "";
            KsdkType ksdk = this.getInstance().getKsdk();
            if (ksdk != null && ksdk.getRevision() != null) {
                revision = ksdk.getRevision();
            }
            return revision;
        }
        return null;
    }

    @Override
    public String getManifestSimpleName() {
        if (!this.packLoaded) {
            try {
                this.loadManifest();
            }
            catch (IOException | JAXBException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.getInstance() != null) {
            return this.getInstance().getId();
        }
        return null;
    }

    @Override
    public IFile copyFiles(IContainer folder, String name, boolean external, boolean forceOverwrite) throws CoreException, IOException {
        InputStream stream = this.getResourceStream(name, external);
        IFile file = null;
        if (folder instanceof IFolder) {
            file = ((IFolder)folder).getFile(SDKManifestProvider.getSimpleName(name));
        } else if (folder instanceof IProject) {
            file = ((IProject)folder).getFile(SDKManifestProvider.getSimpleName(name));
        } else {
            String message = NLS.bind((String)Messages.SDKManifest_DestIsWrong, (Object)folder, (Object)file);
            LOGGER.log(Level.SEVERE, message);
            stream.close();
            return null;
        }
        boolean contentEqual = forceOverwrite || file.exists() && this.contentEquals(file.getContents(), stream);
        final ISDKManifest.WS_OP[] result = new ISDKManifest.WS_OP[]{ISDKManifest.WS_OP.NONE};
        final InputStream[] resultStream = new InputStream[1];
        if (file.exists() && !contentEqual) {
            BufferedInputStream bis = new BufferedInputStream(this.getResourceStream(name, external));
            String string = SDKManifest.readContent(bis);
            final CompareItem left = new CompareItem(file.getFullPath().toPortableString(), SDKManifest.readContent(file.getContents()), true);
            final CompareItem right = new CompareItem(name, string, false);
            final CompareEditorInput input = new CompareEditorInput(new CompareConfiguration()){

                protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CompareConfiguration conf = this.getCompareConfiguration();
                    conf.setLeftLabel(String.valueOf(Messages.SDKManifest_Workspace) + left.getName());
                    conf.setLeftImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
                    conf.setRightImage(Activator.getDefault().getImage("img.package"));
                    conf.setRightLabel(String.valueOf(Messages.SDKManifest_SDK) + right.getName());
                    conf.setLeftEditable(true);
                    conf.setRightEditable(true);
                    Differencer diff = new Differencer();
                    return diff.findDifferences(false, monitor, null, null, (Object)left, (Object)right);
                }

                public void save(IProgressMonitor pm) {
                    try {
                        result[0] = ISDKManifest.WS_OP.UPDATE;
                        resultStream[0] = right.getContents();
                    }
                    catch (CoreException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            ISDKManifest.COMPONENT_ADD_POLICY policy = SDKUIUtils.openOverwritePrompt(file, SDKManifestProvider.forceFilesOverwrite);
            switch (policy) {
                case COMPARE: {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CompareUI.openCompareDialog((CompareEditorInput)input);
                        }
                    });
                    break;
                }
                case OVERWRITE: {
                    LOGGER.log(Level.WARNING, String.valueOf(Messages.SDKManifest_OverwriteFiles) + file);
                    result[0] = ISDKManifest.WS_OP.RECREATE;
                    resultStream[0] = this.getResourceStream(name, external);
                    break;
                }
                case SKIP: {
                    LOGGER.log(Level.WARNING, String.valueOf(Messages.SDKManifest_SkipFiles) + file);
                    bis.close();
                    return file;
                }
            }
        } else if (!file.exists() || !contentEqual) {
            result[0] = ISDKManifest.WS_OP.CREATE;
            resultStream[0] = this.getResourceStream(name, external);
        }
        while (file.getWorkspace().isTreeLocked()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.performWorkspaceOperation(result[0], resultStream[0], file);
        stream.close();
        return file;
    }

    private void performWorkspaceOperation(ISDKManifest.WS_OP op, InputStream stream, IFile file) {
        try {
            switch (op) {
                case DELETE: {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                case CREATE: {
                    file.create(stream, true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                case UPDATE: {
                    file.setContents(stream, true, true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                case RECREATE: {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    file.create(stream, true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
            }
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static String readContent(InputStream stream) throws IOException {
        String content = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        stream.close();
        return content;
    }

    private boolean contentEquals(InputStream fileContent, InputStream stream) throws IOException {
        int ch2;
        if (fileContent == null || stream == null) {
            return false;
        }
        if (!(fileContent instanceof BufferedInputStream)) {
            fileContent = new BufferedInputStream(fileContent);
        }
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        int ch = fileContent.read();
        while (-1 != ch) {
            ch2 = stream.read();
            if (ch != ch2) {
                fileContent.close();
                return false;
            }
            ch = fileContent.read();
        }
        ch2 = stream.read();
        fileContent.close();
        return ch2 == -1;
    }

    @Override
    public IFile deleteFiles(IContainer folder, String name, boolean external) throws CoreException, IOException {
        InputStream stream = this.getResourceStream(name, external);
        IFile file = null;
        if (folder instanceof IFolder) {
            file = ((IFolder)folder).getFile(SDKManifestProvider.getSimpleName(name));
        } else if (folder instanceof IProject) {
            file = ((IProject)folder).getFile(SDKManifestProvider.getSimpleName(name));
        } else {
            String message = NLS.bind((String)Messages.SDKManifest_DestIsWrong, (Object)folder, (Object)file);
            LOGGER.log(Level.SEVERE, message);
            stream.close();
            return null;
        }
        boolean contentEqual = file.exists() && this.contentEquals(file.getContents(), stream);
        final ISDKManifest.WS_OP[] result = new ISDKManifest.WS_OP[]{ISDKManifest.WS_OP.NONE};
        InputStream[] resultStream = new InputStream[1];
        if (file.exists() && !contentEqual) {
            InputStream compareStream = this.getResourceStream(name, external);
            BufferedInputStream bis = new BufferedInputStream(compareStream);
            String string = SDKManifest.readContent(bis);
            final CompareItem left = new CompareItem(String.valueOf(Messages.SDKManifest_Workspace) + file.getFullPath().toPortableString(), SDKManifest.readContent(file.getContents()), false);
            final CompareItem right = new CompareItem(name, string, false);
            final CompareEditorInput input = new CompareEditorInput(new CompareConfiguration()){

                protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CompareConfiguration conf = this.getCompareConfiguration();
                    conf.setLeftLabel(String.valueOf(Messages.SDKManifest_SDK) + left.getName());
                    conf.setRightImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
                    conf.setLeftImage(Activator.getDefault().getImage("img.package"));
                    conf.setRightLabel(String.valueOf(Messages.SDKManifest_Workspace) + right.getName());
                    conf.setLeftEditable(false);
                    conf.setRightEditable(false);
                    Differencer diff = new Differencer();
                    return diff.findDifferences(false, monitor, null, null, (Object)left, (Object)right);
                }

                public Object getSelectedEdition() {
                    return StructuredSelection.EMPTY;
                }

                public String getOKButtonLabel() {
                    return IDialogConstants.OK_LABEL;
                }

                public boolean isEditionSelectionDialog() {
                    return true;
                }

                public boolean okPressed() {
                    result[0] = ISDKManifest.WS_OP.DELETE;
                    return super.okPressed();
                }
            };
            ISDKManifest.COMPONENT_DELETE_POLICY policy = SDKUIUtils.openDeletePrompt(file);
            switch (policy) {
                case COMPARE: {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CompareUI.openCompareDialog((CompareEditorInput)input);
                        }
                    });
                    break;
                }
                case DELETE: {
                    result[0] = ISDKManifest.WS_OP.DELETE;
                    break;
                }
                case SKIP: {
                    result[0] = ISDKManifest.WS_OP.NONE;
                    return file;
                }
            }
        } else if (file.exists() && contentEqual) {
            result[0] = ISDKManifest.WS_OP.DELETE;
        }
        while (file.getWorkspace().isTreeLocked()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.performWorkspaceOperation(result[0], resultStream[0], file);
        stream.close();
        return file;
    }

    @Override
    public IFile linkFiles(IContainer folder, String name, boolean external, boolean forceOverwrite) throws CoreException, IOException, URISyntaxException {
        InputStream stream = this.getResourceStream(name, external);
        IFile file = null;
        if (folder instanceof IFolder) {
            file = ((IFolder)folder).getFile(SDKManifestProvider.getSimpleName(name));
        } else if (folder instanceof IProject) {
            file = ((IProject)folder).getFile(SDKManifestProvider.getSimpleName(name));
        } else {
            String message = NLS.bind((String)Messages.SDKManifest_DestIsWrongLinkFile, (Object)folder, (Object)file);
            LOGGER.log(Level.SEVERE, message);
            stream.close();
            return null;
        }
        if (this.isZip && !external) {
            if (!file.exists()) {
                file.create(stream, true, (IProgressMonitor)new NullProgressMonitor());
            }
        } else if (!file.exists()) {
            String variable = this.getVariableName(false);
            if (external) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPathVariableManager pathMan = workspace.getPathVariableManager();
                URI uri = pathMan.convertToRelative(new File(name).toURI(), true, variable);
                file.createLink(uri, 16, (IProgressMonitor)new NullProgressMonitor());
            } else {
                String location = String.valueOf(variable) + File.separator + name;
                location = location.replace("\\", "/");
                file.createLink(new URI(location), 16, (IProgressMonitor)new NullProgressMonitor());
            }
        } else {
            String message = NLS.bind((String)Messages.SDKManifest_FileNotExist, (Object)(String.valueOf(external ? "" : String.valueOf(this.packName) + File.separator) + name));
            LOGGER.log(Level.SEVERE, message);
        }
        stream.close();
        return file;
    }

    @Override
    public void scan(List<String> list, File folder, SDKManifestFilter filter, String mask) throws IOException {
        if (this.isZip) {
            mask = mask.replace("\\", "/");
            mask = mask.replace(".//", "");
            mask = mask.replace("./", "");
            ZipFile zipFile = new ZipFile(this.packName);
            Enumeration<? extends ZipEntry> it = zipFile.entries();
            while (it.hasMoreElements()) {
                ZipEntry entry = it.nextElement();
                if (entry == null || !SDKManifestFilter.match(entry.getName(), mask)) continue;
                list.add(entry.getName());
            }
            zipFile.close();
        } else if (folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!mask.contains("!*") || !file.isDirectory()) {
                        this.scan(list, file, filter, mask);
                    }
                    ++n2;
                }
            }
        } else {
            mask = mask.replace(".\\", "").replace("!*", "*");
            if (SDKManifestFilter.match(folder.getAbsolutePath(), mask)) {
                String packName = new File(this.manifestPath.toString()).getParent();
                String path = folder.getAbsolutePath().substring(packName.toString().length() + 1);
                list.add(path);
            }
        }
    }

    @Override
    public List<ComponentType> getComponentsById(String id, boolean exact) {
        ArrayList<ComponentType> result = new ArrayList<ComponentType>();
        Manifest.Components components = this.instance.getComponents();
        if (components != null) {
            for (ComponentType component : components.getComponent()) {
                if (!component.getId().equals(id) && (exact || !this.matchPartialID(component, id))) continue;
                result.add(component);
            }
        }
        return result;
    }

    private boolean matchPartialID(ComponentType component, String id) {
        try {
            int endIndex = component.getId().lastIndexOf(".");
            if (endIndex != -1) {
                String partial = component.getId().substring(0, endIndex);
                return partial.equals(id);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }

    @Override
    public Map<Boolean, List<ExampleType>> getExamples(BoardType board, DeviceType device, CompilerEnum compiler, boolean getExternal) throws JAXBException, IOException {
        ExamplesType container;
        HashMap<Boolean, List<ExampleType>> map = new HashMap<Boolean, List<ExampleType>>();
        ArrayList<ExampleType> external = new ArrayList<ExampleType>();
        ArrayList<ExampleType> internal = new ArrayList<ExampleType>();
        if (board != null && (container = board.getExamples()) != null) {
            if (container.getExternal() != null) {
                external.addAll(this.handleExternal(container.getExternal(), ExampleType.class));
            } else if (container.getExample() != null && !container.getExample().isEmpty()) {
                for (ExampleType ex : container.getExample()) {
                    if (ex.getExternal() != null) {
                        try {
                            if (getExternal) {
                                external.addAll(this.handleExternal(ex.getExternal(), ExampleType.class));
                                continue;
                            }
                            external.add(ex);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                        continue;
                    }
                    internal.add(ex);
                }
            }
            map.put(Boolean.FALSE, internal);
            map.put(Boolean.TRUE, external);
        }
        return map;
    }

    @Override
    public LinkerSettingsType getLinkerSettings(String chip, int nature) {
        LinkerSettingsType settings = null;
        for (DeviceType device : this.getDevices()) {
            List<LinkerSettingsType> container;
            if (!device.getId().equals(chip) || (container = device.getLinkerSettings()) == null) continue;
            for (LinkerSettingsType entry : container) {
                NatureType entryNature = entry.getNature();
                switch (nature) {
                    case 2: {
                        if (entryNature.equals((Object)NatureType.C_NATURE)) {
                            settings = entry;
                            break;
                        }
                        if (!entryNature.equals((Object)NatureType.CPP_NATURE)) break;
                        settings = entry;
                        break;
                    }
                    case 0: {
                        if (!entryNature.equals((Object)NatureType.C_NATURE)) break;
                        settings = entry;
                        break;
                    }
                    case 1: {
                        if (!entryNature.equals((Object)NatureType.CPP_NATURE)) break;
                        settings = entry;
                    }
                }
            }
            if (settings != null) break;
        }
        return settings;
    }

    @Override
    public LinkerSettingsType.Linker getLinkerSetting(String chip, int nature, LinkerSettingType type) {
        LinkerSettingsType settings = this.getLinkerSettings(chip, nature);
        if (settings != null) {
            for (LinkerSettingsType.Linker setting : settings.getLinker()) {
                if (!setting.getProperty().equals((Object)type)) continue;
                return setting;
            }
        }
        return null;
    }

    @Override
    public Version getVersion() {
        if (this.getManifestVersion(false) == null) {
            return new Version(0, 0, 0);
        }
        return new Version(this.getManifestVersion(false));
    }

    @Override
    public <T> List<T> handleExternal(SourceType external, Class<T> cls) {
        ArrayList<IdentifiableType> list = new ArrayList<IdentifiableType>();
        Class containerClass = null;
        try {
            if (cls == ExampleType.class) {
                containerClass = ExamplesType.class;
            } else if (cls == DebugConfigurationType.class) {
                containerClass = DebugType.class;
            } else if (cls == ToolchainSettingType.class) {
                containerClass = ToolchainSettingsType.class;
            } else if (cls == ToolchainSettingsType.class) {
                containerClass = ToolchainSettingsType.class;
            } else {
                throw new Exception("Class " + cls + " not allowed.");
            }
            JAXBContext jc = OrbitJAXBContextFactory.createContext(containerClass);
            String path = external.getPath();
            for (FileType file : external.getFiles()) {
                Unmarshaller um = jc.createUnmarshaller();
                um.setSchema(this.schema);
                InputStream stream = this.getResourceStream(SDKManifestFilter.EMPTY.adapt(path, file.getMask()), false);
                StreamSource source = new StreamSource(stream);
                JAXBElement root = um.unmarshal((Source)source, containerClass);
                Object container = root.getValue();
                if (container instanceof ExamplesType) {
                    ExamplesType examples = (ExamplesType)container;
                    list.addAll(examples.getExample());
                } else if (container instanceof ToolchainSettingsType) {
                    ToolchainSettingsType settings = (ToolchainSettingsType)container;
                    list.addAll(settings.getToolchainSetting());
                } else if (container instanceof DebugType) {
                    DebugType debug = (DebugType)container;
                    list.addAll(debug.getDebugConfiguration());
                }
                stream.close();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return list;
    }

    @Override
    public DeviceType getDevice(PackageType pkg) {
        for (DeviceType device : this.getDevices()) {
            for (PackageType p : device.getPackage()) {
                if (!p.getId().equals(pkg.getId())) continue;
                return device;
            }
        }
        return SDKManifestProvider.getDevice(pkg);
    }

    @Override
    public Image getImage(SourceType source) {
        if (source != null) {
            Image cachedImage = this.cachedImages.get(source);
            if (cachedImage != null) {
                return cachedImage;
            }
            String path = source.getPath();
            if (!source.getFiles().isEmpty()) {
                FileType file = source.getFiles().get(0);
                try {
                    InputStream stream = this.getResourceStream(SDKManifestFilter.EMPTY.adapt(path, file.getMask()), false);
                    if (stream != null) {
                        Image image = new Image((Device)Display.getDefault(), stream);
                        this.cachedImages.put(source, image);
                        stream.close();
                        return image;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    @Override
    public void getDependencies(ComponentType component, List<ComponentType> dependencies) throws Exception {
        if (dependencies != null && component != null) {
            for (ComponentType dep : component.getDependency()) {
                if (dependencies.contains(dep)) continue;
                dependencies.add(dep);
                try {
                    this.getDependencies(dep, dependencies);
                }
                catch (StackOverflowError stackOverflowError) {
                    throw new Exception(Messages.SDKManifest_WrongManifestStructure);
                }
            }
        }
    }

    @Override
    public ComponentType getBoardComponent(String boardId, DeviceType device) {
        for (ComponentType component : this.getComponents(ComponentTypeEnum.PROJECT_TEMPLATE, device)) {
            if (!component.getName().equals(boardId)) continue;
            return component;
        }
        return SDKSoftwareProvider.getBoardComponent(boardId, device);
    }

    @Override
    public void setActiveVersion(ManifestFileItem active) {
        String manifestName;
        String list = this.store.getString("sdk.manifest.versions.pref");
        if (list.contains(manifestName = this.getManifestSimpleName())) {
            String pattern = String.valueOf(manifestName) + "=" + "[0-9]+\\.[0-9]+\\.[0-9]+;";
            list = list.replaceAll(pattern, String.valueOf(manifestName) + "=" + active.getVersion().toString() + ";");
        } else {
            list = String.valueOf(list) + manifestName + "=" + active.getVersion().toString() + ";";
        }
        this.store.setValue("sdk.manifest.versions.pref", list);
    }

    @Override
    public void setActive(boolean state) {
        String list = this.store.getString("sdk.manifest.active.pref");
        this.active = state;
        if (state) {
            this.refreshVariables();
        } else {
            this.clearVariables();
        }
        if (state) {
            list = list.replace(String.valueOf(this.getManifestSimpleName()) + ";", "");
        } else {
            list = String.valueOf(list.concat(this.getManifestSimpleName())) + ";";
            HashMap<String, Integer> activeDevices = new HashMap<String, Integer>();
            for (SDKManifestProvider provider : SDKManifestProvider.getInstance()) {
                for (ISDKManifest pack : provider.getManifests()) {
                    if (!pack.isActive() || pack.equals(this)) continue;
                    for (DeviceType device : pack.getDevices()) {
                        Integer count = (Integer)activeDevices.get(device.getId());
                        if (count == null) {
                            count = new Integer(0);
                        }
                        count = count + 1;
                        activeDevices.put(device.getId(), count);
                    }
                }
            }
            for (DeviceType device : this.getDevices()) {
                Integer count = (Integer)activeDevices.get(device.getId());
                if (count != null && count > 0) {
                    String message = NLS.bind((String)Messages.SDKManifest_DeviceAvailAnotherSDK, (Object)device.getId());
                    LOGGER.log(Level.INFO, message);
                    continue;
                }
                String name = SDKManifestProvider.getDeviceSupportName(device);
                File targetFolder = this.targetFolders.get(name);
                java.nio.file.Path directory = Paths.get(targetFolder.getAbsolutePath(), new String[0]);
                try {
                    Files.walkFileTree(directory, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                        @Override
                        public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        this.store.setValue("sdk.manifest.active.pref", list);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public <T extends IdentifiableType> T findReference(Manifest.ExternalDefinitions.Definition definition, Class<T> clz) {
        Manifest.CoreSlaveRolesDefinitions roles;
        String id = definition.getExtID();
        IdentifiableType element = null;
        if (CompilerType.class.equals(clz)) {
            if (this.getInstance().getCompilers() != null) {
                for (CompilerType compiler : this.getInstance().getCompilers().getCompiler()) {
                    if (!compiler.getId().equals(id)) continue;
                    element = compiler;
                    break;
                }
            }
        } else if (ToolchainType.class.equals(clz)) {
            if (this.getInstance().getToolchains() != null) {
                for (ToolchainType toolchain : this.getInstance().getToolchains().getToolchain()) {
                    if (!toolchain.getId().equals(id)) continue;
                    element = toolchain;
                    break;
                }
            }
        } else if (DebugConfigurationType.class.equals(clz)) {
            if (this.getInstance().getToolchains() != null) {
                block4: for (ToolchainType toolchain : this.getInstance().getToolchains().getToolchain()) {
                    if (!toolchain.getType().equals(ToolchainEnum.MCUXPRESSO) || toolchain.getDebug() == null) continue;
                    for (DebugConfigurationType dbg : toolchain.getDebug().getDebugConfiguration()) {
                        if (!dbg.getId().equals(id)) continue;
                        element = dbg;
                        continue block4;
                    }
                }
            }
        } else if (ComponentType.class.equals(clz)) {
            if (this.getInstance().getComponents() != null) {
                for (ComponentType component : this.getInstance().getComponents().getComponent()) {
                    if (!component.getId().equals(id)) continue;
                    element = component;
                    break;
                }
            }
        } else if (BoardType.class.equals(clz)) {
            if (this.getInstance().getBoards() != null) {
                for (BoardType board : this.getInstance().getBoards().getBoard()) {
                    if (!board.getId().equals(id)) continue;
                    element = board;
                    break;
                }
            }
        } else if (ExampleType.class.equals(clz)) {
            for (BoardType board : this.getBoards()) {
                try {
                    DeviceType device = this.getDevice(board.getPackage());
                    Map<Boolean, List<ExampleType>> examples = this.getExamples(board, device, CompilerEnum.GCC, false);
                    Set<Boolean> keys = examples.keySet();
                    block9: for (Boolean key : keys) {
                        List<ExampleType> list = examples.get(key);
                        for (ExampleType example : list) {
                            if (!example.getId().equals(id)) continue;
                            element = example;
                            continue block9;
                        }
                    }
                }
                catch (IOException | JAXBException e) {
                    LOGGER.log(Level.INFO, e.getMessage(), e);
                }
            }
        } else if (CoreType.class.equals(clz)) {
            if (this.getInstance().getDevices() != null) {
                block11: for (DeviceType device : this.getInstance().getDevices().getDevice()) {
                    for (CoreType core : device.getCore()) {
                        if (!core.getId().equals(id)) continue;
                        element = core;
                        continue block11;
                    }
                }
            }
        } else if (RoleType.class.equals(clz) && (roles = this.getInstance().getCoreSlaveRolesDefinitions()) != null) {
            for (RoleType refRole : roles.getSlaveRole()) {
                if (!refRole.getId().equals(definition.getExtID())) continue;
                element = refRole;
                break;
            }
        }
        if (element == null) {
            LOGGER.log(Level.SEVERE, String.valueOf(Messages.SDKManifest_UnableToFindXMLElem) + id + " (" + clz + ")");
        }
        return (T)element;
    }

    @Override
    public Map<Object, Object> getDataCache() {
        if (Platform.inDevelopmentMode()) {
            return new HashMap<Object, Object>();
        }
        return this.dataCache;
    }

    @Override
    public boolean isLegacy() {
        return this.legacy;
    }

    @Override
    public boolean isLoaded() {
        return this.packLoaded;
    }

    public int hashCode() {
        return this.packName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ISDKManifest) {
            ISDKManifest manifest = (ISDKManifest)obj;
            return manifest.getManifestName().equals(this.packName);
        }
        return super.equals(obj);
    }

    private Manifest readManifest(Object manifestFilePath, Unmarshaller unmarshaller, ZipFile zipFile) {
        Manifest localInstance = null;
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (InputStream stream = this.getManifestFile(manifestFilePath, zipFile);){
                StreamSource source = new StreamSource(stream);
                JAXBElement root = unmarshaller.unmarshal((Source)source, Manifest.class);
                localInstance = (Manifest)root.getValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "The manifest file couldn't be read: " + e.getMessage());
        }
        catch (IllegalArgumentException | JAXBException e) {
            LOGGER.log(Level.SEVERE, "Errors when trying to convert the file to manifest object: " + e.getMessage());
        }
        return localInstance;
    }

    private void addManifestFiles(String fileName, Object entry) {
        if (fileName.matches(".*_itm_manifest(_v[0-9]+_[0-9]+)?.xml")) {
            this.manifestChildFiles.add(new ManifestFileItem(entry, fileName));
        } else if (fileName.matches(".*_manifest(_v[0-9]+_[0-9]+)?.xml")) {
            this.manifestsFiles.add(new ManifestFileItem(entry, fileName));
        }
    }

    public class ManifestFileItem {
        private Object manifestPath;
        private String name;

        public ManifestFileItem(Object manifestPath, String name) {
            this.manifestPath = manifestPath;
            this.name = name;
        }

        public Object getManifestPath() {
            return this.manifestPath;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            String v1 = "_v3_0";
            Pattern p = Pattern.compile(".*_manifest(_v[0-9]+_[0-9]+)?.xml");
            Matcher m = p.matcher(this.getName());
            if (m.find() && m.group(1) != null) {
                v1 = m.group(1);
            }
            return new Version(v1.replace("_v", "").replace("_", "."));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ManifestFileItem) {
                ManifestFileItem item = (ManifestFileItem)obj;
                return item.manifestPath.equals(this.getManifestPath()) && item.getName().equals(this.getName()) && item.getVersion().equals((Object)this.getVersion());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.getName()) + " " + this.getManifestPath() + " " + this.getVersion();
        }
    }
}

