/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.core;

import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.core.ProjectContextHelper;
import com.nxp.s32ds.cle.uct.core.UctDescriptor;
import com.nxp.s32ds.cle.uct.core.UctDescriptors;
import com.nxp.s32ds.cle.uct.internal.core.UctEclipseProjectAdapterParams;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.ImportToolchainProjectFactory;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class UctCore {
    public static final String SOURCE_FOLDER_DEFAULT = "board";
    private static final String EP_TEMPLATES_ID = "com.nxp.s32ds.cle.uct.templates";
    private static final String EXT_ATTR_DEVICE = "deviceId";
    private static final String EXT_ATTR_CORE = "coreId";
    private static final String EXT_ATTR_PATH = "path";
    private static final String EXT_ATTR_SDKID = "sdkId";
    private static final String EXT_ATTR_RESTRICTED = "sdk_required";

    public static void init() {
        IExtensionPoint templates = Platform.getExtensionRegistry().getExtensionPoint(EP_TEMPLATES_ID);
        IConfigurationElement[] iConfigurationElementArray = templates.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String deviceId = element.getAttribute(EXT_ATTR_DEVICE);
            String coreId = element.getAttribute(EXT_ATTR_CORE);
            String sdkId = element.getAttribute(EXT_ATTR_SDKID);
            String templatePath = element.getAttribute(EXT_ATTR_PATH);
            boolean restrictBySdk = Boolean.parseBoolean(element.getAttribute(EXT_ATTR_RESTRICTED));
            UctDescriptors.addUctDescriptor(new UctDescriptor(deviceId, coreId, sdkId, templatePath, restrictBySdk));
            ++n2;
        }
    }

    public static IFile addMexConfigurationFile(IProject target, Map<String, String> context, IProgressMonitor monitor) throws CoreException {
        if (target == null) {
            return null;
        }
        IFile file = ConfigurationUtils.findConfigurationInEclipseProject((IProject)target);
        if (file != null && file.exists()) {
            return file;
        }
        IToolchainProjectWithSdk adapted = (IToolchainProjectWithSdk)Adapters.adapt((Object)((Object)new UctEclipseProjectAdapterParams(null, target, context)), IToolchainProjectWithSdk.class, (boolean)true);
        if (adapted == null) {
            return null;
        }
        String sdkId = adapted.getSdkVersion();
        if (sdkId == null || sdkId.isEmpty()) {
            Status error = new Status(4, "com.nxp.s32ds.cle.uct.core", "Sdk id was not found for project " + target.getName(), (Throwable)new NullPointerException());
            throw new CoreException((IStatus)error);
        }
        ProjectContextHelper projectHelper = new ProjectContextHelper(target);
        String mexTemplatePath = UctCore.getMexTemplatePath(adapted.getProcessor(), projectHelper.getCoreType(), sdkId);
        if (mexTemplatePath != null) {
            file = target.getFile(adapted.getPartNumber().concat(".mex"));
            try {
                Throwable throwable = null;
                Object var9_13 = null;
                try (FileOutputStream dest = new FileOutputStream(file.getLocation().toOSString());){
                    UctCore.writeMexFile(dest, mexTemplatePath);
                    file.refreshLocal(0, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Status error = new Status(4, "com.nxp.s32ds.cle.uct.core", e.getMessage(), (Throwable)new NullPointerException());
                throw new CoreException((IStatus)error);
            }
            return file;
        }
        ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(1, "com.nxp.s32ds.cle.uct.core", "Start generating mex file..."));
        file = target.getFile(String.valueOf(target.getName()) + ".mex");
        String msg = ImportToolchainProjectFactory.createConfigurationForS32Project((IToolchainProjectWithSdk)adapted, (String)file.getLocation().toOSString(), (IProgressMonitor)monitor);
        if (msg != null) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", "Failed to generate mex file: " + msg));
            return null;
        }
        return file;
    }

    @Deprecated
    private static String getMexTemplatePath(String processorId, String coreTypeId, String sdkId) throws CoreException {
        if (processorId == null || coreTypeId == null) {
            Status error = new Status(4, "com.nxp.s32ds.cle.uct.core", "Cannot find template", (Throwable)new NullPointerException());
            throw new CoreException((IStatus)error);
        }
        String dataDir = DataDirectoryUtils.getDataDir();
        String templatePath = UctDescriptors.getTemplatePathByDeviceCoreSdkId(processorId, coreTypeId, sdkId);
        if (templatePath == null || templatePath.isEmpty()) {
            templatePath = UctDescriptors.getTemplatePathByDeviceCore(processorId, coreTypeId);
        }
        if (templatePath != null && !templatePath.isEmpty()) {
            templatePath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(templatePath, true);
            IPath template = Path.fromOSString((String)templatePath);
            if (!template.toFile().exists()) {
                template = Path.fromOSString((String)dataDir).append(templatePath);
            }
            if (template.toFile().exists()) {
                return template.toOSString();
            }
            String msg = NLS.bind((String)Messages.UCT_Template_NotFound_Error, (Object)template);
            Status status = new Status(4, "com.nxp.s32ds.cle.uct.core", msg);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        } else {
            String msg = NLS.bind((String)Messages.UCT_Template_NotRegister_Error, (Object)processorId, (Object)coreTypeId);
            Status status = new Status(4, "com.nxp.s32ds.cle.uct.core", msg);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
        return null;
    }

    private static void writeMexFile(OutputStream dest, String sourcePath) throws CoreException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(sourcePath);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(dest);
            transformer.transform(source, result);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            Status error = new Status(4, "com.nxp.s32ds.cle.uct.core", e.getMessage(), (Throwable)new NullPointerException());
            throw new CoreException((IStatus)error);
        }
    }
}

