/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.dcd.model.settings.Action;
import com.nxp.swtools.dcd.model.settings.AllowedAddressRanges;
import com.nxp.swtools.dcd.model.settings.Command;
import com.nxp.swtools.dcd.model.settings.DCDCommandsSetting;
import com.nxp.swtools.dcd.model.settings.DCDModel;
import com.nxp.swtools.dcd.model.settings.DCDSourceTemplates;
import com.nxp.swtools.dcd.model.settings.HeaderParameters;
import com.nxp.swtools.dcd.model.settings.ICommand;
import com.nxp.swtools.dcd.model.settings.ICommandSetting;
import com.nxp.swtools.dcd.model.settings.IProcessorModel;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.Commit;

public class ProcessorModel
extends DCDModel
implements IProcessorModel {
    private List<ICommandSetting> commandSettings = CollectionsUtils.emptyList();
    private List<ICommand> commands = CollectionsUtils.emptyList();

    @Commit
    public void commit() {
        this.initCommands();
    }

    @Override
    public List<ICommandSetting> getCommandSettings() {
        return this.commandSettings;
    }

    @Override
    public List<ICommand> getCommands() {
        return this.commands;
    }

    private void initCommands() {
        ArrayList<ICommandSetting> cmdSettings = new ArrayList<ICommandSetting>();
        ArrayList<ICommand> cmds = new ArrayList<ICommand>();
        DCDCommandsSetting dcdCommandsSetting = this.getCommandsSetting();
        cmdSettings.add(dcdCommandsSetting.getWriteCommandSetting());
        cmdSettings.add(dcdCommandsSetting.getCheckCommandSetting());
        cmdSettings.add(dcdCommandsSetting.getNopCommandSetting());
        this.commandSettings = cmdSettings;
        for (ICommandSetting cmdSetting : cmdSettings) {
            HeaderParameters params = cmdSetting.getHeader().getParameters();
            if (params != null && !params.getActionSetting().getItems().isEmpty()) {
                for (Action item : params.getActionSetting().getItems()) {
                    cmds.add(new Command(cmdSetting.getCommandType(), cmdSetting, item));
                }
                continue;
            }
            cmds.add(new Command(cmdSetting.getCommandType(), cmdSetting));
        }
        this.commands = cmds;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public List<String> getTemplateFilePaths() {
        DCDSourceTemplates templates = this.getSourceTemplates();
        return templates != null ? templates.getTemplateFilePaths() : new ArrayList<String>();
    }

    @Override
    public @Nullable List<AllowedAddressRanges.AddressRange> getAllowedDcdAddressRanges() {
        AllowedAddressRanges allowedRanges = super.getAllowedAddressRanges();
        return allowedRanges != null ? allowedRanges.getAddressRanges() : null;
    }
}

