/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.checkers.core;

import com.nxp.s32ds.ext.cdt.checkers.core.CdtLaunchConfigurationAbstractChecker;
import com.nxp.s32ds.ext.ide.validation.core.GdbClientLaunchConfigurationMarker;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class GdbClientLaunchConfigurationChecker
extends CdtLaunchConfigurationAbstractChecker {
    private static final String ATTR_GDB_CLIENT_NAME = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String GDB_CLIENT_PATTERN = "";
    private Collection<String> launchTypes;

    public GdbClientLaunchConfigurationChecker(Collection<String> launchTypes) {
        this.launchTypes = launchTypes;
    }

    @Override
    protected IStatus check(List<IFile> listLaunchFiles, IProject project) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        for (IFile launchFile : listLaunchFiles) {
            if (!launchFile.exists()) continue;
            ILaunchConfiguration launchConfiguration = launchManager.getLaunchConfiguration(launchFile);
            try {
                String lcType = launchConfiguration.getType().getIdentifier();
                if (!this.launchTypes.contains(lcType)) continue;
                if (GdbClientLaunchConfigurationChecker.isGdbClientToBeUpdated(launchConfiguration)) {
                    if (GdbClientLaunchConfigurationMarker.containsMarker((IResource)launchFile)) continue;
                    GdbClientLaunchConfigurationMarker.createMarker((IResource)launchFile, (IProject)project, (String)project.getName());
                    continue;
                }
                GdbClientLaunchConfigurationMarker.delete((IResource)launchFile);
            }
            catch (CoreException coreException) {}
        }
        return Status.OK_STATUS;
    }

    private static boolean isGdbClientToBeUpdated(ILaunchConfiguration launchConfiguration) throws CoreException {
        boolean result = false;
        return result;
    }
}

