/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.handlers;

import com.nxp.s32ds.debug.ide.s32debugger.flash.core.GenericProgressDialogStatusHandler;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.S32DebuggerFlashProgrammerCoreActivator;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class GenericProgressDialogStatusHandlerImpl
implements GenericProgressDialogStatusHandler {
    private static final Object RUNNABLE_SYNCHRONIZER = new Object();
    private static final int PROGRESS_FOR_DIALOG = 100;
    private static ProgressMonitorDialog dialog;
    private static DialogRunnable runnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Object object = RUNNABLE_SYNCHRONIZER;
        synchronized (object) {
            int severity = status.getSeverity();
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (4 == severity) {
                this.cleanUp();
            } else {
                if (severity == 0 && runnable == null) {
                    Object dialogSynchronizer;
                    runnable = new DialogRunnable();
                    Object object2 = dialogSynchronizer = new Object();
                    synchronized (object2) {
                        display.asyncExec(() -> {
                            dialog = new ProgressMonitorDialog(display.getActiveShell());
                            Object object2 = dialogSynchronizer;
                            synchronized (object2) {
                                dialogSynchronizer.notify();
                            }
                            try {
                                dialog.run(true, false, (IRunnableWithProgress)runnable);
                            }
                            catch (InterruptedException | InvocationTargetException ex) {
                                S32DebuggerFlashProgrammerCoreActivator.getDefault().logError(ex.getMessage());
                            }
                        });
                        while (dialog == null) {
                            try {
                                dialogSynchronizer.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                if (8 == severity && runnable != null) {
                    this.cleanUp();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void worked(int workDone) {
        Object object = RUNNABLE_SYNCHRONIZER;
        synchronized (object) {
            if (runnable != null && workDone > 0) {
                runnable.progress(workDone);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskName(String name) {
        Object object = RUNNABLE_SYNCHRONIZER;
        synchronized (object) {
            if (runnable != null && name != null && !name.isEmpty()) {
                runnable.setTaskName(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubTask(String name) {
        Object object = RUNNABLE_SYNCHRONIZER;
        synchronized (object) {
            if (runnable != null && name != null) {
                runnable.setSubTask(name);
            }
        }
    }

    public int getFullTaskProgress() {
        return 100;
    }

    private void cleanUp() {
        if (runnable == null) {
            return;
        }
        runnable.closeDialog();
        runnable = null;
        dialog = null;
    }

    private static class DialogRunnable
    implements IRunnableWithProgress {
        private final Object synchronizer = new Object();
        private IProgressMonitor rootMonitor;
        private String startTask;
        private boolean close = false;

        private DialogRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.rootMonitor = monitor;
            if (this.startTask == null) {
                this.startTask = "Process initializing...";
            }
            this.rootMonitor.beginTask(this.startTask, 100);
            Object object = this.synchronizer;
            synchronized (object) {
                while (!this.close) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        this.synchronizer.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeDialog() {
            this.close = true;
            Object object = this.synchronizer;
            synchronized (object) {
                this.synchronizer.notify();
            }
        }

        public void setTaskName(String task) {
            if (this.rootMonitor != null) {
                this.rootMonitor.setTaskName(task);
            } else {
                this.startTask = task;
            }
        }

        public void setSubTask(String task) {
            if (this.rootMonitor != null) {
                this.rootMonitor.subTask(task);
            }
        }

        public void progress(int value) {
            if (this.rootMonitor != null) {
                this.rootMonitor.worked(value);
            }
        }
    }
}

