/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.model.utils;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.utils.GtmXmlSettingsUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class GtmExpressions {
    public static final Pattern GET_VALUE_EXPR_REGEX = Pattern.compile("(getValue)\\((.*)\\)", 8);
    private static final Logger LOGGER = LogManager.getLogger(GtmExpressions.class);

    public static long getLongValueFromExpression(IGtmMcu selectedMcu, String expression) {
        ABaseUIComponentSetting componentSetting;
        String componentId;
        long value = 0L;
        Matcher valueMatcher = GET_VALUE_EXPR_REGEX.matcher(expression);
        if (valueMatcher.find() && valueMatcher.groupCount() == 2 && (componentId = valueMatcher.group(2)) != null && (componentSetting = GtmUtils.getUIComponentSettingById(selectedMcu, componentId)) != null) {
            value = componentSetting.getValueToWrite();
        }
        return value;
    }

    public static long getLongValueFromExpression(String expression, GtmStructSetting parentSetting) {
        String valueId;
        long value = 0L;
        Matcher valueMatcher = GET_VALUE_EXPR_REGEX.matcher(expression);
        if (valueMatcher.find() && valueMatcher.groupCount() == 2 && (valueId = valueMatcher.group(2)) != null) {
            return GtmExpressions.getValue(valueId, parentSetting);
        }
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        if (engine != null) {
            try {
                String valueResult = String.valueOf(engine.eval(expression));
                if (NumberFormatValidator.isValidDecimal((String)valueResult)) {
                    value = Long.parseLong(valueResult);
                }
            }
            catch (NumberFormatException | ScriptException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
            }
        }
        return value;
    }

    private static long getValue(String componentId, GtmStructSetting parentSetting) {
        String childComponentId;
        long value = 0L;
        if (componentId.contains(".")) {
            String[] componentsIds = componentId.split("\\.");
            childComponentId = componentsIds[componentsIds.length - 1];
        } else {
            childComponentId = componentId;
        }
        GtmIntegerSetting integerSetting = GtmXmlSettingsUtils.getIntegerSettingById(parentSetting.getIntegerSettings(), String.valueOf(parentSetting.getId()) + "." + childComponentId);
        if (integerSetting != null) {
            value = integerSetting.getValueToWrite();
        }
        return value;
    }
}

