/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.CalculatedTimingScale;
import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TimingScale
implements Iterable<BigRational> {
    @NonNull
    protected static final BigInteger ZERO = BigRational.NewBigInteger((int)0);
    @NonNull
    protected static final BigInteger ONE = BigRational.NewBigInteger((int)1);
    @NonNull
    protected static final BigInteger TWO = BigRational.NewBigInteger((int)2);
    @NonNull
    protected static final BigInteger LASTINT = BigRational.NewBigInteger((int)Integer.MAX_VALUE);
    @NonNull
    protected static final BigInteger LASTLONG = BigRational.NewBigInteger((long)0x7FFFFFFFFFFFFFFL);
    @NonNull
    public static final BigRational defaultAccuracy = BigRational.ZERO;
    @NonNull
    protected BigRational from = BigRational.ONE;
    @NonNull
    protected BigInteger numOfScales = ONE;
    @Nullable
    protected INextVal nxt = null;
    @NonNull
    protected BigRational to = BigRational.ONE;
    @NonNull
    protected EScaleType type = EScaleType.Base;

    protected static @NonNull BigInteger addNN(@NonNull BigInteger a, @NonNull BigInteger b) {
        BigInteger res = a.add(b);
        assert (res != null) : "BigInteger addition failed";
        return res;
    }

    protected static @NonNull BigInteger subNN(@NonNull BigInteger a, @NonNull BigInteger b) {
        BigInteger res = a.subtract(b);
        assert (res != null) : "BigInteger subtraction failed";
        return res;
    }

    protected static @NonNull BigInteger mulNN(@NonNull BigInteger a, @NonNull BigInteger b) {
        BigInteger res = a.multiply(b);
        assert (res != null) : "BigInteger multiplication failed";
        return res;
    }

    protected static @NonNull BigInteger divNN(@NonNull BigInteger a, @NonNull BigInteger b) {
        BigInteger res = a.divide(b);
        assert (res != null) : "BigInteger division failed";
        return res;
    }

    protected static final @NonNull BigRational powBI(@NonNull BigRational n, int k) {
        @NonNull BigRational tmpc = BigRational.ONE;
        int texp = k;
        while (texp > 0) {
            BigRational x = n;
            int i = 1;
            while (i * 2 < texp) {
                x = x.multiply(x);
                i *= 2;
            }
            if (i * 2 == texp) {
                i *= 2;
                x = x.multiply(x);
            }
            tmpc = tmpc.multiply(x);
            texp -= i;
        }
        return tmpc;
    }

    public int hashCode() {
        return this.from.getNumerator().intValue() ^ this.to.getNumerator().intValue() ^ this.numOfScales.intValue() ^ this.type.hashCode();
    }

    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null) {
            return false;
        }
        if (arg.getClass() != this.getClass()) {
            return false;
        }
        TimingScale as = (TimingScale)arg;
        if (this.type != as.type) {
            return false;
        }
        if (!this.from.equals((Object)as.from)) {
            return false;
        }
        if (!this.to.equals((Object)as.to)) {
            return false;
        }
        if (!this.numOfScales.equals(as.numOfScales)) {
            return false;
        }
        return this.nxt == as.nxt;
    }

    public void printVals() {
        INextVal tmpNxt = this.nxt;
        assert (tmpNxt != null);
        @NonNull BigRational p = this.from;
        @NonNull BigInteger i = ZERO;
        while (!i.equals(this.numOfScales)) {
            System.out.println(p);
            i = TimingScale.addNN(i, ONE);
            p = tmpNxt.op(p);
        }
    }

    public boolean inRange(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(this.from) >= 0 && value.compareTo(this.to) <= 0;
    }

    public boolean elem(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        if (!this.inRange(value)) {
            return false;
        }
        INextVal tmpNxt = this.nxt;
        assert (tmpNxt != null);
        @NonNull BigRational p = this.from;
        @NonNull BigInteger i = ZERO;
        while (!i.equals(this.numOfScales)) {
            if (value.equals((Object)p)) {
                return true;
            }
            i = TimingScale.addNN(i, ONE);
            p = tmpNxt.op(p);
        }
        return false;
    }

    public @NonNull BigRational closest(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        INextVal tmpNxt = this.nxt;
        assert (tmpNxt != null);
        @NonNull BigRational actual = this.from;
        @NonNull BigRational last = this.from;
        while (value.compareTo(actual) > 0) {
            last = actual;
            actual = tmpNxt.op(actual);
        }
        if (value.compareTo(last) == 0) {
            return last;
        }
        if (value.subtract(last).compareTo(value.subtract(actual).negate()) < 0) {
            return last;
        }
        return actual;
    }

    public @Nullable BigRational closestUp(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return null;
        }
        INextVal tmpNxt = this.nxt;
        assert (tmpNxt != null);
        @NonNull BigRational actual = this.from;
        while (value.compareTo(actual) > 0) {
            actual = tmpNxt.op(actual);
        }
        return actual;
    }

    public @Nullable BigRational closestDown(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return null;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        INextVal tmpNxt = this.nxt;
        assert (tmpNxt != null);
        @NonNull BigRational actual = this.from;
        @NonNull BigRational last = this.from;
        while (value.compareTo(actual) > 0) {
            last = actual;
            actual = tmpNxt.op(actual);
        }
        if (value.compareTo(actual) == 0) {
            return actual;
        }
        return last;
    }

    @Override
    public Iterator<BigRational> iterator() {
        Iterator<BigRational> it = new Iterator<BigRational>(){
            @NonNull
            private BigRational p;
            @NonNull
            private BigInteger i;
            {
                this.p = TimingScale.this.from;
                this.i = ZERO;
            }

            @Override
            public boolean hasNext() {
                return this.i.compareTo(TimingScale.this.numOfScales) < 0;
            }

            @Override
            public BigRational next() {
                if (this.i.compareTo(TimingScale.this.numOfScales) > 0) {
                    throw new NoSuchElementException();
                }
                BigRational ret = this.p;
                if (!$assertionsDisabled && TimingScale.this.nxt == null) {
                    throw new AssertionError();
                }
                this.p = TimingScale.this.nxt.op(ret);
                this.i = TimingScale.addNN(this.i, ONE);
                return ret;
            }
        };
        if (this instanceof CalculatedTimingScale) {
            this.numOfScales = BigInteger.ONE;
        }
        return it;
    }

    public @NonNull IntervalNarrowingContext getInitialMiddle() {
        throw new UnsupportedOperationException("Method getInitialMiddle node is not applicable.");
    }

    @NonNull IntervalNarrowingContext getValInMiddleR(@NonNull IntervalNarrowingContext interval) {
        throw new UnsupportedOperationException("Method getValInMiddleR node is not applicable.");
    }

    public @NonNull TimingScale shrinkScale(@Nullable BigInteger maxNumberOfScales) {
        if (maxNumberOfScales == null || maxNumberOfScales.compareTo(this.numOfScales) >= 0) {
            return this;
        }
        throw new UnsupportedOperationException("Method shrinkScale node is not applicable.");
    }

    public @Nullable INextVal getNextValFun() {
        return this.nxt;
    }

    public @Nullable INextVal getPrevValFun() {
        return null;
    }

    public @Nullable BigRational setRequiredRatio(@NonNull BigRational ratio) {
        return ratio;
    }

    static class BigIntIntervalNarrowingContext
    extends IntervalNarrowingContext {
        @NonNull
        BigInteger numOfVals;
        @NonNull
        BigInteger numFromMid;
        @NonNull
        BigRational coefficient;

        public BigIntIntervalNarrowingContext(@NonNull BigRational fromVal, @NonNull BigRational midVal, @NonNull BigRational toVal, @NonNull BigInteger nums, @NonNull BigInteger numFromMid, @NonNull BigRational coef) {
            super(fromVal, midVal, toVal);
            this.numOfVals = nums;
            this.numFromMid = numFromMid;
            this.coefficient = coef;
        }

        @Override
        public void halfMidVal() {
            this.numFromMid = TimingScale.addNN(TimingScale.divNN(this.numOfVals, TWO), ONE);
        }

        @Override
        public void newMidVal() {
            this.midVal = this.fromVal.add(this.coefficient.multiply(TimingScale.divNN(this.numOfVals, TWO)));
        }

        @Override
        public boolean halfTotalValLow() {
            this.numOfVals = TimingScale.subNN(this.numFromMid, ONE);
            return this.numOfVals.compareTo(ZERO) > 0;
        }

        @Override
        public boolean halfTotalValHigh() {
            this.numOfVals = TimingScale.subNN(this.numOfVals, this.numFromMid);
            return this.numOfVals.compareTo(ZERO) > 0;
        }

        @Override
        public @NonNull BigRational getOneDownFromMiddle() {
            return this.midVal.subtract(this.coefficient);
        }

        @Override
        public @NonNull BigRational getOneUpFromMiddle() {
            return this.midVal.add(this.coefficient);
        }

        @Override
        public Iterator<BigRational> iterator() {
            Iterator<BigRational> it = new Iterator<BigRational>(){
                @NonNull
                private BigRational actItVal;
                @NonNull
                private BigRational lastVal;
                @NonNull
                private BigRational coef;
                {
                    this.actItVal = bigIntIntervalNarrowingContext.fromVal;
                    this.lastVal = bigIntIntervalNarrowingContext.toVal;
                    this.coef = bigIntIntervalNarrowingContext.coefficient;
                }

                @Override
                public boolean hasNext() {
                    return this.actItVal.compareTo(this.lastVal) <= 0;
                }

                @Override
                public BigRational next() {
                    if (this.actItVal.compareTo(this.lastVal) > 0) {
                        throw new NoSuchElementException();
                    }
                    @NonNull BigRational ret = this.actItVal;
                    this.actItVal = this.actItVal.add(this.coef);
                    return ret;
                }
            };
            return it;
        }

        @Override
        public Iterator<BigRational> reverseIterator() {
            Iterator<BigRational> it = new Iterator<BigRational>(){
                @NonNull
                private BigRational actItVal;
                @NonNull
                private BigRational lastVal;
                @NonNull
                private BigRational coef;
                {
                    this.actItVal = bigIntIntervalNarrowingContext.toVal;
                    this.lastVal = bigIntIntervalNarrowingContext.fromVal;
                    this.coef = bigIntIntervalNarrowingContext.coefficient;
                }

                @Override
                public boolean hasNext() {
                    return this.actItVal.compareTo(this.lastVal) >= 0;
                }

                @Override
                public BigRational next() {
                    if (this.actItVal.compareTo(this.lastVal) < 0) {
                        throw new NoSuchElementException();
                    }
                    @NonNull BigRational ret = this.actItVal;
                    this.actItVal = this.actItVal.subtract(this.coef);
                    return ret;
                }
            };
            return it;
        }
    }

    static interface INextVal {
        public @NonNull BigRational op(@NonNull BigRational var1);
    }

    static class IntIntervalNarrowingContext
    extends IntervalNarrowingContext {
        int numOfVals;
        int numFromMid;
        @NonNull
        BigRational coefficient;
        boolean isGeometric = false;

        public IntIntervalNarrowingContext(@NonNull BigRational fromVal, @NonNull BigRational midVal, @NonNull BigRational toVal, int nums, int numFromMid, @NonNull BigRational coef, boolean isGeometric) {
            super(fromVal, midVal, toVal);
            this.numOfVals = nums;
            this.numFromMid = numFromMid;
            this.coefficient = coef;
            this.isGeometric = isGeometric;
        }

        @Override
        public void halfMidVal() {
            this.numFromMid = this.numOfVals / 2 + 1;
        }

        @Override
        public void newMidVal() {
            if (this.isGeometric) {
                this.midVal = this.fromVal.multiply(TimingScale.powBI(this.coefficient, this.numOfVals / 2));
            }
            this.midVal = this.fromVal.add(this.coefficient.multiply(this.numOfVals / 2));
        }

        @Override
        public boolean halfTotalValLow() {
            this.numOfVals = this.numFromMid - 1;
            return this.numOfVals > 0;
        }

        @Override
        public boolean halfTotalValHigh() {
            this.numOfVals -= this.numFromMid;
            return this.numOfVals > 0;
        }

        @Override
        public @NonNull BigRational getOneDownFromMiddle() {
            if (this.isGeometric) {
                return this.midVal.divide(this.coefficient);
            }
            return this.midVal.subtract(this.coefficient);
        }

        @Override
        public @NonNull BigRational getOneUpFromMiddle() {
            if (this.isGeometric) {
                return this.midVal.multiply(this.coefficient);
            }
            return this.midVal.add(this.coefficient);
        }

        @Override
        public Iterator<BigRational> iterator() {
            Iterator<BigRational> it = new Iterator<BigRational>(){
                @NonNull
                private BigRational actualItVal;
                @NonNull
                private BigRational lastVal;
                @NonNull
                private BigRational coef;
                private boolean isGeom;
                {
                    this.actualItVal = intIntervalNarrowingContext.fromVal;
                    this.lastVal = intIntervalNarrowingContext.toVal;
                    this.coef = intIntervalNarrowingContext.coefficient;
                    this.isGeom = intIntervalNarrowingContext.isGeometric;
                }

                @Override
                public boolean hasNext() {
                    return this.actualItVal.compareTo(this.lastVal) <= 0;
                }

                @Override
                public BigRational next() {
                    if (this.actualItVal.compareTo(this.lastVal) > 0) {
                        throw new NoSuchElementException();
                    }
                    @NonNull BigRational ret = this.actualItVal;
                    this.actualItVal = this.isGeom ? this.actualItVal.multiply(this.coef) : this.actualItVal.add(this.coef);
                    return ret;
                }
            };
            return it;
        }

        @Override
        public Iterator<BigRational> reverseIterator() {
            Iterator<BigRational> it = new Iterator<BigRational>(){
                @NonNull
                private BigRational actualItVal;
                @NonNull
                private BigRational lastVal;
                @NonNull
                private BigRational coef;
                private boolean isGeom;
                {
                    this.actualItVal = intIntervalNarrowingContext.toVal;
                    this.lastVal = intIntervalNarrowingContext.fromVal;
                    this.coef = intIntervalNarrowingContext.coefficient;
                    this.isGeom = intIntervalNarrowingContext.isGeometric;
                }

                @Override
                public boolean hasNext() {
                    return this.actualItVal.compareTo(this.lastVal) >= 0;
                }

                @Override
                public BigRational next() {
                    if (this.actualItVal.compareTo(this.lastVal) < 0) {
                        throw new NoSuchElementException();
                    }
                    @NonNull BigRational ret = this.actualItVal;
                    this.actualItVal = this.isGeom ? this.actualItVal.divide(this.coef) : this.actualItVal.subtract(this.coef);
                    return ret;
                }
            };
            return it;
        }
    }

    static class IntervalNarrowingContext
    implements Iterable<BigRational> {
        @NonNull
        BigRational fromVal;
        @NonNull
        BigRational toVal;
        @NonNull
        BigRational midVal;

        public IntervalNarrowingContext(@NonNull BigRational fromVal, @NonNull BigRational midVal, @NonNull BigRational toVal) {
            this.fromVal = fromVal;
            this.midVal = midVal;
            this.toVal = toVal;
        }

        public void halfMidVal() {
            throw new UnsupportedOperationException("Method halfMidVal is not applicable for this class.");
        }

        public boolean halfTotalValLow() {
            throw new UnsupportedOperationException("Method halfTotalValLow is not applicable for this class.");
        }

        public boolean halfTotalValHigh() {
            throw new UnsupportedOperationException("Method halfTotalValHigh is not applicable for this class.");
        }

        public void newMidVal() {
            throw new UnsupportedOperationException("Method newMidVal is not applicable for this class.");
        }

        public @NonNull BigRational getOneDownFromMiddle() {
            throw new UnsupportedOperationException("Method getOneDownFromMiddle is not applicable for this class.");
        }

        public @NonNull BigRational getOneUpFromMiddle() {
            throw new UnsupportedOperationException("Method getOneUpFromMiddle is not applicable for this class.");
        }

        @Override
        public Iterator<BigRational> iterator() {
            throw new UnsupportedOperationException("Method iterator is not applicable for this class.");
        }

        public Iterator<BigRational> reverseIterator() {
            throw new UnsupportedOperationException("Method iterator is not applicable for this class.");
        }
    }

    static class LongIntervalNarrowingContext
    extends IntervalNarrowingContext {
        long numOfVals;
        long numFromMid;
        @NonNull
        BigRational coefficient;

        public LongIntervalNarrowingContext(@NonNull BigRational fromVal, @NonNull BigRational midVal, @NonNull BigRational toVal, long nums, long numFromMid, @NonNull BigRational coef) {
            super(fromVal, midVal, toVal);
            this.numOfVals = nums;
            this.numFromMid = numFromMid;
            this.coefficient = coef;
        }

        @Override
        public void halfMidVal() {
            this.numFromMid = this.numOfVals / 2L + 1L;
        }

        @Override
        public void newMidVal() {
            this.midVal = this.fromVal.add(this.coefficient.multiply(this.numOfVals / 2L));
        }

        @Override
        public boolean halfTotalValLow() {
            this.numOfVals = this.numFromMid - 1L;
            return this.numOfVals > 0L;
        }

        @Override
        public boolean halfTotalValHigh() {
            this.numOfVals -= this.numFromMid;
            return this.numOfVals > 0L;
        }

        @Override
        public @NonNull BigRational getOneDownFromMiddle() {
            return this.midVal.subtract(this.coefficient);
        }

        @Override
        public @NonNull BigRational getOneUpFromMiddle() {
            return this.midVal.add(this.coefficient);
        }

        @Override
        public Iterator<BigRational> iterator() {
            Iterator<BigRational> it = new Iterator<BigRational>(){
                @NonNull
                private BigRational actItVal;
                @NonNull
                private BigRational lastVal;
                @NonNull
                private BigRational coef;
                {
                    this.actItVal = longIntervalNarrowingContext.fromVal;
                    this.lastVal = longIntervalNarrowingContext.toVal;
                    this.coef = longIntervalNarrowingContext.coefficient;
                }

                @Override
                public boolean hasNext() {
                    return this.actItVal.compareTo(this.lastVal) <= 0;
                }

                @Override
                public BigRational next() {
                    if (this.actItVal.compareTo(this.lastVal) > 0) {
                        throw new NoSuchElementException();
                    }
                    @NonNull BigRational ret = this.actItVal;
                    this.actItVal = this.actItVal.add(this.coef);
                    return ret;
                }
            };
            return it;
        }

        @Override
        public Iterator<BigRational> reverseIterator() {
            Iterator<BigRational> it = new Iterator<BigRational>(){
                @NonNull
                private BigRational actItVal;
                @NonNull
                private BigRational lastVal;
                @NonNull
                private BigRational coef;
                {
                    this.actItVal = longIntervalNarrowingContext.toVal;
                    this.lastVal = longIntervalNarrowingContext.fromVal;
                    this.coef = longIntervalNarrowingContext.coefficient;
                }

                @Override
                public boolean hasNext() {
                    return this.actItVal.compareTo(this.lastVal) >= 0;
                }

                @Override
                public BigRational next() {
                    if (this.actItVal.compareTo(this.lastVal) < 0) {
                        throw new NoSuchElementException();
                    }
                    @NonNull BigRational ret = this.actItVal;
                    this.actItVal = this.actItVal.subtract(this.coef);
                    return ret;
                }
            };
            return it;
        }
    }

    static class SetIntervalNarrowingContext
    extends IntervalNarrowingContext {
        int numOfVals;
        int numFromMid;
        @NonNull
        @NonNull BigRational @NonNull [] scaleArray;
        int low;
        int high;
        int middle;

        public SetIntervalNarrowingContext(@NonNull BigRational fromVal, @NonNull BigRational toVal, int nums, int numFromMid, @NonNull BigRational @NonNull [] scales) {
            super(fromVal, scales[(nums - 1) / 2], toVal);
            this.numOfVals = nums;
            this.numFromMid = numFromMid;
            this.low = 0;
            this.high = nums - 1;
            this.middle = this.high / 2;
            this.scaleArray = scales;
        }

        @Override
        public void halfMidVal() {
            this.numFromMid = (this.high - this.low) / 2 + 1;
            this.middle = (this.high + this.low) / 2;
        }

        @Override
        public void newMidVal() {
            this.midVal = this.scaleArray[this.middle];
        }

        @Override
        public boolean halfTotalValLow() {
            this.high = this.middle - 1;
            this.numOfVals = this.high - this.low + 1;
            return this.numOfVals > 0;
        }

        @Override
        public boolean halfTotalValHigh() {
            this.low = this.middle + 1;
            this.numOfVals = this.high - this.low + 1;
            return this.numOfVals > 0;
        }

        @Override
        public @NonNull BigRational getOneDownFromMiddle() {
            return this.scaleArray[this.middle - 1];
        }

        @Override
        public @NonNull BigRational getOneUpFromMiddle() {
            return this.scaleArray[this.middle + 1];
        }

        @Override
        public Iterator<BigRational> iterator() {
            Iterator<BigRational> it = new Iterator<BigRational>(){
                private int idxActVal;
                private int idxLastVal;
                @NonNull
                private @NonNull BigRational @NonNull [] scales;
                {
                    this.idxActVal = setIntervalNarrowingContext.low;
                    this.idxLastVal = setIntervalNarrowingContext.high;
                    this.scales = setIntervalNarrowingContext.scaleArray;
                }

                @Override
                public boolean hasNext() {
                    return this.idxActVal <= this.idxLastVal;
                }

                @Override
                public BigRational next() {
                    if (this.idxActVal > this.idxLastVal) {
                        throw new NoSuchElementException();
                    }
                    @NonNull BigRational ret = this.scales[this.idxActVal++];
                    return ret;
                }
            };
            return it;
        }

        @Override
        public Iterator<BigRational> reverseIterator() {
            Iterator<BigRational> it = new Iterator<BigRational>(){
                private int idxActVal;
                private int idxLastVal;
                @NonNull
                private @NonNull BigRational @NonNull [] scales;
                {
                    this.idxActVal = setIntervalNarrowingContext.high;
                    this.idxLastVal = setIntervalNarrowingContext.low;
                    this.scales = setIntervalNarrowingContext.scaleArray;
                }

                @Override
                public boolean hasNext() {
                    return this.idxActVal >= this.idxLastVal;
                }

                @Override
                public BigRational next() {
                    if (this.idxActVal < this.idxLastVal) {
                        throw new NoSuchElementException();
                    }
                    @NonNull BigRational ret = this.scales[this.idxActVal--];
                    return ret;
                }
            };
            return it;
        }
    }
}

