/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ADivMul;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.GeometricTimingScale;
import com.nxp.swtools.clocks.model.LinearTimingScale;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.SetTimingScale;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.regex.Pattern;

public class Divider
extends ADivMul {
    public Divider(@NonNull String id) {
        super(id, ENodeType.Divider);
    }

    public Divider(@NonNull String id, @NonNull TimingScale scaler) {
        super(id, ENodeType.Divider, scaler);
    }

    public Divider(@NonNull String id, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, ENodeType.Divider, scaler, defaultScale);
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(clock)) {
            res = false;
        }
        BigRational xxSetScale = this.setScale;
        BigRational xxDefaultScale = this.defaultScale;
        BigRational xxOutputClock = null;
        if (xxSetScale != null) {
            xxOutputClock = clock.divide(xxSetScale);
        } else {
            assert (this.useDefaults) : "Default scale value is used when forbidden in " + this.id;
            assert (xxDefaultScale != null);
            xxOutputClock = clock.divide(xxDefaultScale);
        }
        if (!this.checkOutputFreq(xxOutputClock)) {
            res = false;
        }
        assert (xxOutputClock != null);
        this.outputClock = xxOutputClock;
        if (this.child.compute(this, xxOutputClock)) {
            return res;
        }
        return false;
    }

    @Override
    protected @NonNull BigRational getCScale(@NonNull BigRational inClock, @NonNull BigRational outClock) {
        BigRational k = inClock.divide(outClock);
        @NonNull BigRational tmpTo = this.scaler.to;
        @NonNull BigRational tmpFrm = this.scaler.from;
        BigRational res = k.compareTo(tmpTo) > 0 ? tmpTo : (k.compareTo(tmpFrm) < 0 ? tmpFrm : this.scaler.closest(k));
        return res;
    }

    @Override
    protected @NonNull BigRational evalOp(@NonNull BigInteger k, @NonNull BigRational in) {
        return in.divide(k);
    }

    @Override
    protected @NonNull BigRational evalOp(@NonNull BigRational k, @NonNull BigRational in) {
        return in.divide(k);
    }

    @Override
    protected @NonNull BigRational evalInverseOp(@NonNull BigInteger k, @NonNull BigRational out) {
        return out.multiply(k);
    }

    @Override
    protected @NonNull BigRational evalInverseOp(@NonNull BigRational k, @NonNull BigRational out) {
        return out.multiply(k);
    }

    private @NonNull EErrorType computeAutoWithMiddleSearch(@NonNull BigRational clock) {
        TimingScale.IntervalNarrowingContext interval = this.scaler.getInitialMiddle();
        BigRational xxCompScale = interval.midVal;
        @NonNull BigRational newClock = BigRational.ZERO;
        @NonNull EErrorType subResult = EErrorType.None;
        BigRational xxDefaultScale = this.defaultScale;
        if (xxDefaultScale != null && xxDefaultScale.compareTo(xxCompScale) != 0 && (subResult = this.testOutputFreq(newClock = clock.divide(xxDefaultScale))) == EErrorType.None) {
            this.lastComp = ECompState.OnceSatisfied;
            subResult = this.child.computeAutoWR(this, newClock);
            if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxDefaultScale;
                return EErrorType.None;
            }
        }
        newClock = clock.divide(xxCompScale);
        subResult = this.testOutputFreq(newClock);
        EErrorType rangeError = EErrorType.None;
        while (true) {
            if (subResult == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                subResult = this.child.computeAutoWR(this, newClock);
                if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compScale = xxCompScale;
                    return EErrorType.None;
                }
                if (this.stopComputation) {
                    return EErrorType.None;
                }
            }
            if (subResult == EErrorType.TooSlow) {
                if (rangeError == EErrorType.None) {
                    rangeError = EErrorType.TooSlow;
                } else if (rangeError == EErrorType.TooFast) {
                    rangeError = EErrorType.CannotSetup;
                }
                if (!interval.halfTotalValLow()) {
                    return rangeError;
                }
                interval.toVal = interval.getOneDownFromMiddle();
            } else {
                if (subResult != EErrorType.TooFast) break;
                if (rangeError == EErrorType.None) {
                    rangeError = EErrorType.TooFast;
                } else if (rangeError == EErrorType.TooSlow) {
                    rangeError = EErrorType.CannotSetup;
                }
                if (!interval.halfTotalValHigh()) {
                    return rangeError;
                }
                interval.fromVal = interval.getOneUpFromMiddle();
            }
            interval = this.scaler.getValInMiddleR(interval);
            xxCompScale = interval.midVal;
            newClock = clock.divide(xxCompScale);
            subResult = this.testOutputFreq(newClock);
        }
        if (subResult == EErrorType.BothFastSlow) {
            return subResult;
        }
        for (BigRational xxIntervalScale : interval) {
            assert (xxIntervalScale != null);
            newClock = clock.divide(xxIntervalScale);
            subResult = this.testOutputFreq(newClock);
            if (subResult == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                subResult = this.child.computeAutoWR(this, newClock);
                if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compScale = xxIntervalScale;
                    return EErrorType.None;
                }
                if (this.stopComputation) {
                    return EErrorType.None;
                }
            }
            if (subResult != EErrorType.TooSlow) continue;
            return EErrorType.CannotSetup;
        }
        return EErrorType.CannotSetup;
    }

    private @NonNull EErrorType computeAutoWithDefaultAll(@NonNull BigRational clock) {
        BigRational xxCompScale2 = this.defaultScale;
        assert (xxCompScale2 != null);
        @NonNull BigRational newClock = clock.divide(xxCompScale2);
        EErrorType sbr = this.testOutputFreq(newClock);
        @NonNull BigRational fromValue = this.scaler.from;
        @NonNull BigRational toValue = this.scaler.to;
        if (sbr == EErrorType.None) {
            this.lastComp = ECompState.OnceSatisfied;
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale2;
                return EErrorType.None;
            }
        }
        if (sbr == EErrorType.TooFast) {
            fromValue = xxCompScale2;
        } else if (sbr == EErrorType.TooSlow) {
            toValue = xxCompScale2;
        }
        boolean thisTimeSatisfied = false;
        EErrorType searchError = EErrorType.None;
        for (BigRational xxCompScale2 : this.scaler) {
            assert (xxCompScale2 != null);
            if (xxCompScale2.compareTo(fromValue) < 0) continue;
            if (xxCompScale2.compareTo(toValue) > 0) break;
            newClock = clock.divide(xxCompScale2);
            sbr = this.testOutputFreq(newClock);
            if (sbr == EErrorType.TooFast) {
                searchError = sbr;
                continue;
            }
            if (sbr == EErrorType.TooSlow) {
                if (searchError == EErrorType.None) {
                    searchError = sbr;
                    break;
                }
                searchError = EErrorType.CannotSetup;
                break;
            }
            thisTimeSatisfied = true;
            this.lastComp = ECompState.OnceSatisfied;
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale2;
                return EErrorType.None;
            }
            if (sbr == EErrorType.TooSlow) {
                if (xxCompScale2.compareTo(fromValue) == 0) {
                    return EErrorType.TooSlow;
                }
                return EErrorType.CannotSetup;
            }
            if (!this.stopComputation) continue;
            return EErrorType.None;
        }
        if (searchError == EErrorType.None || searchError == EErrorType.CannotSetup) {
            return EErrorType.CannotSetup;
        }
        if (!thisTimeSatisfied) {
            return searchError;
        }
        return EErrorType.CannotSetup;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        EErrorType sbr;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        if ((sbr = this.testInputFreq(clock)) != EErrorType.None) {
            return sbr;
        }
        this.inputClock = clock;
        assert (this.scaler != null) : "Null scaler in divider " + this.id;
        assert (this.child != null) : "Null child in divider " + this.id;
        Object xxCompScale = this.setScale != null ? this.setScale : (this.useDefaults && this.defaultScale != null ? this.defaultScale : null);
        if (xxCompScale != null) {
            BigRational newClock = clock.divide(xxCompScale);
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.compScale = xxCompScale;
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return nres;
        }
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (xxSetOutputFreq != null) {
            if (xxSetOutputFreq.equals((Object)BigRational.ZERO)) {
                return EErrorType.CannotSetup;
            }
            if (this.scaler.setRequiredRatio(clock.divide(xxSetOutputFreq)) == null) {
                return EErrorType.BothFastSlow;
            }
            if (clock.divide(this.scaler.from).compareTo(xxSetOutputFreq.divide(BigRational.ONE.add(this.accuracy))) < 0) {
                return EErrorType.TooSlow;
            }
            if (clock.divide(this.scaler.to).compareTo(xxSetOutputFreq.multiply(BigRational.ONE.add(this.accuracy))) > 0) {
                return EErrorType.TooFast;
            }
            xxCompScale = this.getCScale(clock, xxSetOutputFreq);
            BigRational newClock = clock.divide(xxCompScale);
            BigRational ac = xxSetOutputFreq.compareTo(newClock) < 0 ? newClock.divide(xxSetOutputFreq).subtract(BigRational.ONE) : xxSetOutputFreq.divide(newClock).subtract(BigRational.ONE);
            if (ac.compareTo(this.accuracy) > 0) {
                return EErrorType.CannotSetup;
            }
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
            return nres;
        }
        if (this.scaler instanceof LinearTimingScale || this.scaler instanceof GeometricTimingScale || this.scaler instanceof SetTimingScale) {
            return this.computeAutoWithMiddleSearch(clock);
        }
        if (this.defaultScale != null) {
            this.scaler.setRequiredRatio(this.defaultScale);
        }
        xxCompScale = this.scaler.from;
        BigRational xxDefaultScale = this.defaultScale;
        if (xxDefaultScale != null && xxDefaultScale.compareTo(xxCompScale) != 0) {
            return this.computeAutoWithDefaultAll(clock);
        }
        @NonNull BigRational newClock = clock.divide(xxCompScale);
        sbr = this.testOutputFreq(newClock);
        if (sbr == EErrorType.TooSlow) {
            return sbr;
        }
        if (sbr == EErrorType.TooFast) {
            Iterator<BigRational> its = this.scaler.iterator();
            its.next();
            Divider.updateRequiredRatio(this.scaler, xxCompScale);
            while (its.hasNext()) {
                xxCompScale = its.next();
                assert (xxCompScale != null);
                newClock = clock.divide(xxCompScale);
                sbr = this.testOutputFreq(newClock);
                if (sbr != EErrorType.TooFast) break;
                Divider.updateRequiredRatio(this.scaler, xxCompScale);
            }
            if (sbr != EErrorType.None) {
                if (sbr == EErrorType.TooFast) {
                    return sbr;
                }
                return EErrorType.CannotSetup;
            }
            this.lastComp = ECompState.OnceSatisfied;
            do {
                if ((sbr = this.child.computeAutoWR(this, newClock)) == EErrorType.None || sbr == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compScale = xxCompScale;
                    return EErrorType.None;
                }
                if (sbr == EErrorType.TooSlow) {
                    return EErrorType.CannotSetup;
                }
                if (!its.hasNext()) {
                    return sbr;
                }
                xxCompScale = its.next();
                assert (xxCompScale != null);
                newClock = clock.divide(xxCompScale);
                sbr = this.testOutputFreq(newClock);
                if (sbr == EErrorType.None) continue;
                return sbr;
            } while (!this.stopComputation);
            return EErrorType.None;
        }
        this.lastComp = ECompState.OnceSatisfied;
        sbr = this.child.computeAutoWR(this, newClock);
        if (sbr == EErrorType.TooSlow) {
            return sbr;
        }
        if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
            this.outputClock = newClock;
            this.lastComp = ECompState.OnceSubtreeOK;
            this.compScale = xxCompScale;
            return EErrorType.None;
        }
        xxCompScale = this.scaler.to;
        assert (xxCompScale != null);
        newClock = clock.divide(xxCompScale);
        sbr = this.testOutputFreq(newClock);
        if (sbr != EErrorType.TooSlow) {
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.TooFast) {
                return sbr;
            }
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
        }
        Iterator<BigRational> its = this.scaler.iterator();
        its.next();
        while (its.hasNext()) {
            xxCompScale = its.next();
            assert (xxCompScale != null);
            newClock = clock.divide(xxCompScale);
            sbr = this.testOutputFreq(newClock);
            if (sbr != EErrorType.None) {
                return EErrorType.CannotSetup;
            }
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return EErrorType.None;
            }
            if (sbr == EErrorType.TooSlow) break;
            if (!this.stopComputation) continue;
            return EErrorType.None;
        }
        return EErrorType.CannotSetup;
    }

    private static boolean updateRequiredRatio(@NonNull TimingScale xxMultiplier, @NonNull BigRational imul) {
        String nextImulInteger;
        String val;
        BigRational nextImul = xxMultiplier.setRequiredRatio(imul.add(new BigRational(1, 10)));
        if (nextImul == null && (nextImul = xxMultiplier.setRequiredRatio(BigRational.parse((String)(val = Long.toString(Math.round(imul.add(new BigRational(1, 10)).doubleValue())))))) == null) {
            return false;
        }
        String imulInteger = imul.toString(4).split(Pattern.quote("."))[0];
        if (imulInteger.compareTo(nextImulInteger = nextImul.toString(4).split(Pattern.quote("."))[0]) != 0) {
            nextImul = BigRational.tryParse((String)nextImulInteger);
            assert (nextImul != null);
            xxMultiplier.setRequiredRatio(nextImul);
        }
        return true;
    }
}

