/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.application;

import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.cmd.ICmdApplication;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.MigrationHelper;
import com.nxp.swtools.periphs.controller.PeripheralsProblem;
import com.nxp.swtools.periphs.controller.ValidationParams;
import com.nxp.swtools.periphs.controller.report.PeriphsHtmlReportGenerator;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.IDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.OverriddenDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import com.nxp.swtools.utils.wizards.exportWizard.ExportUtils;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CmdApplication
implements ICmdApplication {
    protected static final String INTERNAL_PLUGIN_ID = "com.nxp.swtools.periphs.internal";
    protected static final String INTERNAL_DEVELOPMENT_ELEMENT = "internal_development";
    protected static final String INTERNAL_DEVELOPMENT_CLASS_ATTRIBUTE = "class";
    protected static final Logger LOGGER = LogManager.getLogger(CmdApplication.class);

    public boolean run(CmdSection cmdSection) {
        boolean result = true;
        Set keys = cmdSection.cmdMap.keySet();
        for (String key : keys) {
            String path;
            if (key.equals("-ExportAll") && !(path = cmdSection.getOptionValue("-ExportAll")).isEmpty()) {
                result &= CmdApplication.exportSources(path, false);
                result &= CmdApplication.exportHTML(path);
            }
            if (key.equals("-ExportSrc") && !(path = cmdSection.getOptionValue("-ExportSrc")).isEmpty()) {
                result &= CmdApplication.exportSources(path, false);
            }
            if (key.equals("-ExportMcuTemplate") && !(path = cmdSection.getOptionValue("-ExportMcuTemplate")).isEmpty()) {
                result &= CmdApplication.exportSources(path, true);
            }
            if (key.equals("-ExportHTML") && !(path = cmdSection.getOptionValue("-ExportHTML")).isEmpty()) {
                result &= CmdApplication.exportHTML(path);
            }
            if (!key.equals("-MigrateComponentsToToolchainVersion")) continue;
            result &= CmdApplication.migrateComponents();
        }
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(INTERNAL_PLUGIN_ID, INTERNAL_DEVELOPMENT_ELEMENT, INTERNAL_DEVELOPMENT_CLASS_ATTRIBUTE);
        Collection extensions = extensionProvider.getExtensions();
        for (ICmdApplication internalCmdApplication : extensions) {
            result &= internalCmdApplication.run(cmdSection);
        }
        CmdApplication.logValidationProblems();
        return result;
    }

    public static boolean exportSources(String path, boolean template) {
        ScriptResult scriptResult = Controller.getInstance().waitAndGetGeneratedCode();
        if (scriptResult != null) {
            boolean result = true;
            Map generatedCode = scriptResult.getOpenedFiles();
            ICustomCopyrightHeaderRead configPref = SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getCustomCopyright();
            if (!generatedCode.isEmpty()) {
                result = ExportUtils.exportSources((Collection)SourceFileProviderFactory.buildSourceFileList((Map)generatedCode, (ICustomCopyrightHeaderRead)configPref), (String)path);
            }
            boolean flatten = Controller.getInstance().getMcu().getCores().size() <= 1;
            for (String core : scriptResult.getCores()) {
                generatedCode = scriptResult.getOpenedFiles(core);
                if (generatedCode == null || generatedCode.isEmpty()) continue;
                Collection getFiles = SourceFileProviderFactory.buildSourceFileList((Map)generatedCode, (ICustomCopyrightHeaderRead)configPref);
                if (template) {
                    getFiles = ExportUtils.removePackageIdFromGenCode((Collection)getFiles);
                    getFiles = ExportUtils.removeCoreIdFromGenCode((Collection)getFiles);
                }
                Path corePath = flatten ? Paths.get(path, new String[0]) : Paths.get(path, new String[0]).resolve(core);
                result &= ExportUtils.exportSources((Collection)getFiles, (String)UtilsText.safeString((String)corePath.toString()));
            }
            return result;
        }
        LOGGER.severe("[TOOL] Export sources did not finish correctly. Code wasn't generated");
        StoragePeriphsTool configTool = SharedConfigurationFactory.getSharedConfigurationSingleton().getTools().getPeripherals();
        if (configTool == null) {
            LOGGER.severe("[TOOL] Generating code for not configured Peripherals tool");
        } else if (!configTool.isEnabled()) {
            LOGGER.severe("[TOOL] Generating code for disabled Peripherals tool");
        }
        return false;
    }

    private static boolean exportHTML(String path) {
        AExportWizard.GenerationResult result = PeriphsHtmlReportGenerator.generateReport();
        if (result.wasSuccessful) {
            Collection report = result.getGeneratedSourceFiles();
            assert (report != null);
            return ExportUtils.exportToFolder((IDestinationPathProvider)new OverriddenDestinationPathProvider(Paths.get(path, new String[0]), SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getOutputPathOverrides()), (Collection)report, (boolean)false);
        }
        return false;
    }

    private static boolean migrateComponents() {
        return MigrationHelper.migrateFromCmd(Controller.getInstance());
    }

    private static void logValidationProblems() {
        List functionalGroups = Controller.getInstance().getProfile().getFunctionalGroups();
        for (IFunctionalGroup functionalGroup : functionalGroups) {
            ValidationParams params = new ValidationParams((IChildProvidable)functionalGroup, functionalGroup.getId());
            List problems = params.getProblems().stream().distinct().collect(Collectors.toList());
            for (GenericProblem problem : problems) {
                if (!(problem instanceof PeripheralsProblem) || problem.getProblemLevel() != 2) continue;
                PeripheralsProblem peripheralProblem = (PeripheralsProblem)problem;
                LOGGER.severe(MessageFormat.format("[TOOL] The resource: {0} from functional group: {1} has the following error: {2}", peripheralProblem.getResource(), peripheralProblem.getFunctionalGroupName(), peripheralProblem.getMessage()));
            }
        }
    }
}

