/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.model.data.InitializationPriorities;
import com.nxp.swtools.periphs.model.data.InitializationPrioritiesGroup;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class InitializationPrioritiesHelper {
    public static List<IComponentInstanceConfig> sortInstancesByPriorityGroups(Collection<IComponentInstanceConfig> instances, InitializationPriorities priorities) {
        ArrayList<IComponentInstanceConfig> instancesCopy = new ArrayList<IComponentInstanceConfig>(instances);
        HashMap<String, List<IComponentInstanceConfig>> workingMap = new HashMap<String, List<IComponentInstanceConfig>>();
        List<InitializationPrioritiesGroup> sortedGroups = InitializationPrioritiesHelper.getInitializationPriorityGroupsOrdered(priorities);
        String defaultGroupName = priorities.getDefaultGroupName();
        for (InitializationPrioritiesGroup group : sortedGroups) {
            List<IComponentInstanceConfig> componentsOfGroup = InitializationPrioritiesHelper.getComponentsOfGroup(instancesCopy, group);
            workingMap.put(group.getId(), componentsOfGroup);
            instancesCopy.removeAll(componentsOfGroup);
        }
        ((List)workingMap.get(defaultGroupName)).addAll(instancesCopy);
        LinkedList<IComponentInstanceConfig> result = new LinkedList<IComponentInstanceConfig>();
        for (InitializationPrioritiesGroup group : sortedGroups) {
            result.addAll((Collection)workingMap.get(group.getId()));
        }
        return result;
    }

    public static List<InitializationPrioritiesGroup> getInitializationPriorityGroupsOrdered(InitializationPriorities priorities) {
        return priorities.getSortedGroups();
    }

    public static List<IComponentInstanceConfig> getComponentsOfGroup(Collection<IComponentInstanceConfig> instances, InitializationPrioritiesGroup group) {
        ArrayList<IComponentInstanceConfig> result = new ArrayList<IComponentInstanceConfig>();
        List componentsInGroup = (List)group.getComponents().stream().map(component -> component.getName()).collect(CollectorsUtils.toList());
        for (IComponentInstanceConfig instance : instances) {
            String type = instance.getType();
            if (!componentsInGroup.contains(type) || instance.isNoInit()) continue;
            result.add(instance);
        }
        return result;
    }
}

