/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.utils.Messages;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IGenericProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;

@NonNullByDefault
public class McuNotSelectedProblemHelper {
    public static void registerMcuSelectedListener(ISharedConfiguration configuration) {
        McuNotSelectedProblemHelper.checkMcuNotSelectedProblem(configuration);
        configuration.addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(ISharedConfiguration sharedConfiguration, ConfigChangeReason reason) {
                McuNotSelectedProblemHelper.checkMcuNotSelectedProblem(sharedConfiguration);
            }

            public void commonConfigurationChanged(ISharedConfiguration sharedConfiguration) {
                McuNotSelectedProblemHelper.checkMcuNotSelectedProblem(sharedConfiguration);
            }
        });
    }

    protected static void checkMcuNotSelectedProblem(ISharedConfiguration configuration) {
        UIJobHelper.runUIJob(() -> {
            String mcuNotSelectedMsg = Messages.get().Tools_McuNotSelected;
            IGenericProblem problem = ValidationEngineFactory.createProblem((String)"McuConfiguration", (int)0, (String)mcuNotSelectedMsg, (String)"McuConfiguration", (String)"McuConfiguration", (String)mcuNotSelectedMsg);
            ICommonConfig mcu = configuration.getCommonConfig();
            if (mcu.getMcu().isEmpty()) {
                ValidationEngineFactory.addProblem((IGenericProblem)problem);
            } else {
                ValidationEngineFactory.deleteProblem((IBaseProblem)problem);
            }
        }, (String)"Check the MCU is not selected problem", (boolean)true);
    }
}

