/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.orti.model;

import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import java.util.LinkedList;
import java.util.List;

public class OrtiAttributeTraceElement {
    protected LinkedList<TracedValue> fTraceValues = new LinkedList();
    private boolean fTraced;
    protected String fID;
    private int lastSampleCount;
    private OrtiObjectAttribute fAttr;
    private String fImplObject;

    public OrtiAttributeTraceElement(String id, OrtiObjectAttribute attr, String implObject) {
        this.fID = id;
        this.fAttr = attr;
        this.fImplObject = implObject;
    }

    public int getCount() {
        return this.fTraceValues.size();
    }

    public void addTraceValues(int epochId, Integer[] values, Integer[] errorIdxVals) {
        int size = this.fTraceValues.size();
        int over = size + values.length - 50;
        if (over > 0) {
            this.fTraceValues.subList(size - over, size).clear();
        }
        TracedValue trval = null;
        int i = 0;
        while (i < values.length) {
            trval = new TracedValue(values[i], epochId);
            int j = 0;
            while (j < errorIdxVals.length) {
                if (errorIdxVals[j] == i) {
                    trval.erroneous = true;
                    break;
                }
                ++j;
            }
            this.fTraceValues.addFirst(trval);
            ++i;
        }
        this.lastSampleCount = values.length;
    }

    public TracedValue[] getLastValues(int nSlots) {
        int size = this.fTraceValues.size();
        TracedValue[] retVal = null;
        if (size <= nSlots) {
            retVal = this.fTraceValues.toArray(new TracedValue[0]);
        } else {
            List list = this.fTraceValues.subList(0, nSlots);
            retVal = list.toArray(new TracedValue[0]);
        }
        return retVal;
    }

    public TracedValue[] getValues() {
        return this.fTraceValues.toArray(new TracedValue[0]);
    }

    public void setTraced(boolean fTraced) {
        this.fTraced = fTraced;
    }

    public boolean isTraced() {
        return this.fTraced;
    }

    public String getID() {
        return this.fID;
    }

    public int getLastSampleCount() {
        return this.lastSampleCount;
    }

    public OrtiObjectAttribute getAttribute() {
        return this.fAttr;
    }

    public String getImplObject() {
        return this.fImplObject;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Id=" + this.fID + ", fTraced=" + this.fTraced);
        str.append(", Attribute={" + this.fAttr.implAttribute.name + ", " + this.fAttr.attrID + "}");
        str.append(", {");
        for (TracedValue tv : this.fTraceValues) {
            str.append(tv.toString());
        }
        str.append("}]");
        return str.toString();
    }

    public boolean checkID(int i) {
        return false;
    }

    public static class TracedValue {
        public int value;
        public int epochID;
        public boolean erroneous;

        public TracedValue(int val, int epID) {
            this.value = val;
            this.epochID = epID;
            this.erroneous = false;
        }

        public String toString() {
            return "[value=" + this.value + ", epochID=" + this.epochID + "]";
        }
    }
}

