/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.tutorial.recorder;

import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.tutorial.recorder.TestIdInspectHandler;
import com.nxp.swtools.utils.TestIDs;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TestIdInspector {
    @NonNull
    public static final String KEY_RECORDER = "recorder";
    @NonNull
    private static final String TEST_ID = "test-id";
    private static final int OVERLAY_OPACITY = 200;
    @NonNull
    public Shell shell;
    @NonNull
    public Shell overlayShell;
    @NonNull
    Canvas canvas;
    @Nullable
    Control selectedControl = null;
    @NonNull
    @NonNull Set<@NonNull Rectangle> rects = new HashSet<Rectangle>();
    @NonNull
    Text textBox;

    private TestIdInspector(@NonNull Shell shell) {
        this.shell = shell;
        final Display display = shell.getDisplay();
        this.overlayShell = new Shell(shell, 8);
        this.overlayShell.setData(KEY_RECORDER, (Object)Boolean.TRUE);
        this.overlayShell.setBounds(shell.getBounds());
        this.overlayShell.setAlpha(200);
        this.overlayShell.setBackground(display.getSystemColor(1));
        this.overlayShell.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == 'q') {
                    TestIdInspector.this.overlayShell.close();
                } else if (e.keyCode == 27) {
                    if ((e.stateMask & 0x40000) == 262144) {
                        TestIdInspector.this.overlayShell.close();
                    } else {
                        display.asyncExec(() -> {
                            TestIdInspector.this.overlayShell.close();
                            display.timerExec(2000, () -> {
                                Shell shell = TestIdInspectHandler.lastShell = null;
                            });
                        });
                    }
                }
            }
        });
        this.overlayShell.open();
        this.rects = this.findHighlightRects((Control)shell);
        this.canvas = new Canvas((Composite)this.overlayShell, 0);
        FontFactory.scaleFontSize((Control)this.canvas, (double)5.0);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(display.getSystemColor(3));
                for (Rectangle rect : TestIdInspector.this.rects) {
                    e.gc.drawRectangle(rect);
                }
                Control control = TestIdInspector.this.selectedControl;
                if (control != null) {
                    e.gc.setBackground(display.getSystemColor(5));
                    Point location = control.getDisplay().map((Control)control.getParent(), (Control)TestIdInspector.this.overlayShell, control.getLocation());
                    Point size = control.getSize();
                    Rectangle highlightRect = new Rectangle(location.x, location.y, size.x + 1, size.y + 1);
                    e.gc.fillRectangle(highlightRect);
                }
            }
        });
        this.canvas.setSize(this.overlayShell.getSize());
        this.canvas.setBackground(display.getSystemColor(1));
        this.canvas.setLayout((Layout)new GridLayout(1, false));
        this.textBox = new Text((Composite)this.canvas, 10);
        this.textBox.setBackground(this.textBox.getDisplay().getSystemColor(2));
        this.textBox.setForeground(this.textBox.getDisplay().getSystemColor(1));
        this.textBox.setLayoutData((Object)new GridData(4, 128, true, false));
        this.textBox.setLocation(5, 5);
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TestIdInspector.this.selectControlAt(e.x, e.y);
                TestIdInspector.this.canvas.setToolTipText(TestIdInspector.this.selectedControl != null ? Objects.requireNonNull(TestIdInspector.this.selectedControl.getData(TestIdInspector.TEST_ID)).toString() : "");
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TestIdInspector.this.selectedControl != null) {
                    String testId = UtilsText.safeString((String)Objects.requireNonNull(TestIdInspector.this.selectedControl.getData(TestIdInspector.TEST_ID)).toString());
                    TestIdInspector.this.textBox.setText(String.valueOf(testId) + "\n" + TestIdInspector.findTestIdField(testId));
                    TestIdInspector.this.textBox.setSize(TestIdInspector.this.textBox.computeSize(-1, -1));
                } else {
                    TestIdInspector.this.textBox.setSize(0, 0);
                }
            }
        });
    }

    public static @NonNull TestIdInspector inspect(@NonNull Shell shell) {
        return new TestIdInspector(shell);
    }

    static @NonNull String findTestIdField(@NonNull String testId) {
        String result = TestIdInspector.findTestIdField(testId, true);
        if (result == null) {
            result = TestIdInspector.findTestIdField(testId, false);
        }
        return UtilsText.safeString((String)result);
    }

    private static @Nullable String findTestIdField(@NonNull String testId, boolean fullMatch) {
        Field[] fieldArray = TestIDs.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                if ((field.getModifiers() & 8) != 0 && (field.getModifiers() & 0x10) != 0) {
                    boolean found;
                    String fieldValue = field.get(null).toString();
                    boolean bl = found = fullMatch ? testId.equals(fieldValue) : testId.startsWith(fieldValue);
                    if (found) {
                        String result = String.valueOf(TestIDs.class.getSimpleName()) + "." + field.getName();
                        if (testId.length() > fieldValue.length()) {
                            result = String.valueOf(result) + " + \"" + testId.substring(fieldValue.length()) + "\"";
                        }
                        return result;
                    }
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return null;
    }

    public void selectControlAt(int x, int y) {
        Control newHighlight = this.findControl(x, y, (Control)this.shell);
        if (this.selectedControl != newHighlight) {
            this.selectedControl = newHighlight;
            this.canvas.redraw();
        }
    }

    public @NonNull Set<@NonNull Rectangle> findHighlightRects(@Nullable Control in) {
        Control[] children;
        HashSet<@NonNull Rectangle> result = new HashSet<Rectangle>();
        if (in instanceof Composite && (children = ((Composite)in).getChildren()) != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                result.addAll(this.findHighlightRects(child));
                if (child.getData(TEST_ID) != null) {
                    Point location = child.getDisplay().map((Control)child.getParent(), (Control)this.overlayShell, child.getLocation());
                    Point size = child.getSize();
                    Rectangle rect = new Rectangle(location.x, location.y, size.x, size.y);
                    result.add(rect);
                }
                ++n2;
            }
        }
        return result;
    }

    @Nullable Control findControl(int x, int y, Control in) {
        Control[] children;
        Control result = null;
        if (in instanceof Composite && (children = ((Composite)in).getChildren()) != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Point location = child.getDisplay().map((Control)child.getParent(), (Control)this.overlayShell, child.getLocation());
                Point size = child.getSize();
                Rectangle rect = new Rectangle(location.x, location.y, size.x, size.y);
                if (rect.contains(x, y)) {
                    Control subResult = this.findControl(x, y, child);
                    if (subResult != null) {
                        return subResult;
                    }
                    if (child.getData(TEST_ID) != null) {
                        result = child;
                    }
                }
                ++n2;
            }
        }
        return result;
    }
}

