/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.wizards.exportWizard;

import com.nxp.swtools.clocks.data.model.EmptyProfile;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.IAbstractFileAccess;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.IDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.wizards.CannotExportWizardPage;
import com.nxp.swtools.utils.wizards.exportWizard.AExportSourcesWizard;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import com.nxp.swtools.utils.wizards.exportWizard.ExportUtils;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.IWizardPage;

public class ExportClocksSourcesWizard
extends AExportSourcesWizard {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ExportClocksSourcesWizard.class);
    @Nullable
    private CannotExportWizardPage pageCannotExport;

    public ExportClocksSourcesWizard() {
        super(UtilsText.safeString((String)Messages.get().ExportClocksSources_ExportSourcesPageTitle), "clocks_sources", "Clocks");
        IClocksProfile currentProfile = UiController.getInstance().getProfile();
        if (currentProfile.containsErrors()) {
            String title = UtilsText.safeString((String)Messages.get().ExportClocksSources_CannotExportTitle);
            String message = Tools.whyToolNotRunning((ISharedConfiguration)SharedConfigurationFactory.getSharedConfigurationSingleton(), (String)"Clocks");
            String pageContent = currentProfile instanceof EmptyProfile ? UtilsText.safeString((String)Messages.get().ExportClocksSources_NoConfiguration) : UtilsText.safeString((String)Messages.get().ExportClocksSources_CannotExportMessage);
            this.pageCannotExport = new CannotExportWizardPage(title, pageContent);
            if (message != null) {
                this.pageCannotExport.setErrorMessage(message);
            }
        }
    }

    public void addPages() {
        if (UiController.getInstance().getProfile().containsErrors()) {
            this.addPage((IWizardPage)this.pageCannotExport);
        } else {
            super.addPages();
        }
    }

    public static final AExportWizard.GenerationResult getGeneratedSources() {
        IClocksProfile profile = UiController.getInstance().getProfile();
        ScriptResult scriptResult = profile.getGeneratedCode();
        if (profile instanceof EmptyProfile && SWToolsProperties.isHeadlessOn()) {
            LOGGER.warning("Source generation not possible for empty profile:" + scriptResult.getErrors());
            return AExportWizard.GenerationResult.fromScriptResult((ScriptResult)scriptResult);
        }
        AExportWizard.GenerationResult generationResult = AExportWizard.GenerationResult.fromScriptResult((ScriptResult)scriptResult);
        boolean clocksEnabled = UiController.getInstance().isEnabled();
        if (clocksEnabled && !generationResult.wasSuccessful) {
            if (SWToolsProperties.isHeadlessOn()) {
                LOGGER.severe("[SDK/Data] Sources generation finished with error(s): " + scriptResult.getErrors());
            } else {
                LOGGER.warning("Sources generation finished with error(s): " + scriptResult.getErrors());
            }
        }
        return generationResult;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable Collection<@NonNull String> generateSourcesToFolder(@NonNull IDestinationPathProvider destination, @NonNull IAbstractFileAccess fileAccess, boolean template) {
        AExportWizard.GenerationResult result = ExportClocksSourcesWizard.getGeneratedSources();
        if (result.wasSuccessful) {
            @NonNull Collection files = result.getGeneratedSourceFiles();
            assert (files != null);
            if (template) {
                files = ExportUtils.removePackageIdFromGenCode((Collection)files);
            }
            if (ExportUtils.exportToFolder((IDestinationPathProvider)destination, (Collection)files, (IAbstractFileAccess)fileAccess, (String)KEPreferences.getLineEnding(), null, (boolean)true)) {
                return SourceFileProviderFactory.getGeneratedRelFileNames((Collection)files).collect(Collectors.toList());
            }
        }
        return null;
    }

    public AExportWizard.GenerationResult generateFiles() {
        return AExportWizard.GenerationResult.fail((String)"This wizard should use another method.");
    }

    protected AExportWizard.GenerationResult generateCoreFiles(@NonNull ProcessorCore coreInfo, @NonNull String destination) {
        return ExportClocksSourcesWizard.getGeneratedSources();
    }
}

