/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.utils;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.ErrorHelper;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.elements.SettingIdResolver;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ClockSelectSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.PowerModeSetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.utils.ClockElementUtils;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.clocks.utils.ToolTipFormatter;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public class ToolTipBuilder {
    @NonNull
    private static final String DASH_UNICODE = " \u2013 ";
    @NonNull
    private static final String CONSTRAINT_INDEX_SEPARATOR = ") ";

    public static @Nullable String create(@NonNull IClockElement element, @NonNull ISetting setting, @NonNull IClocksConfig config) {
        if (element.getMainSetting() == setting) {
            SettingValue value = config.getSettingsConfig().getSettingValue(setting);
            String valueString = ToolTipBuilder.getValueText(setting, value);
            boolean showOutputFrequency = element.getOutputFrequencySetting() != setting;
            boolean showLockInfo = setting.isUserLockable() && config.getSettingsConfig().isLocked(setting);
            LockState lockState = showLockInfo ? config.getSettingsConfig().getLockState(setting) : null;
            BigRational accuracy = lockState == null ? null : lockState.getAccuracy();
            String accuracyText = accuracy == null ? "" : " " + Text.accuracyToPercent(accuracy);
            String lockText = lockState == null ? null : String.valueOf(ToolTipBuilder.getValueText(setting, lockState.getValue())) + accuracyText;
            return ToolTipBuilder.create(element, config, valueString, showOutputFrequency, lockText);
        }
        String description = setting.getDescription();
        return description == null ? null : ToolTipBuilder.resolveText(description, config.getMcu());
    }

    public static @Nullable String create(@NonNull ISetting setting, @NonNull IClocksConfig config) {
        if (setting instanceof BitFieldSetting) {
            return ToolTipBuilder.create((BitFieldSetting)setting, config);
        }
        if (setting instanceof PowerModeSetting) {
            return ToolTipBuilder.create((PowerModeSetting)setting, config);
        }
        String result = setting.getDescription();
        return result == null ? null : ToolTipBuilder.resolveText(result, config.getMcu());
    }

    private static @Nullable String create(@NonNull BitFieldSetting setting, @NonNull IClocksConfig config) {
        String status = null;
        BitFieldElement bitField = setting.getBitField();
        Set<@NonNull String> controlSettings = config.getMcu().getControlSettings(setting.getId());
        if (controlSettings != null && !controlSettings.isEmpty()) {
            status = String.valueOf(Messages.get().ToolTipBuilder_SettingIsControlled) + UtilsText.join(controlSettings, (String)", ");
        }
        String name = String.format("%s [%s]", bitField.getName(), "bit field");
        return ToolTipBuilder.create(bitField.getName(), null, name, null, bitField.getDescription(), status, null, null, null, null, null, null, null, null, null, null, null, null, config);
    }

    public static @NonNull String create(@NonNull Pin pin, @Nullable String component, @NonNull IClocksConfig config) {
        String status = null;
        EnableSetting settings = pin.getEnableSetting();
        if (settings != null) {
            status = settings.getToolTipText(config);
        }
        String signals = pin.getSignalRef().getSignal();
        return ToolTipBuilder.create(pin.getID(), component, pin.getName(), pin.getClass().getSimpleName(), pin.getDescription(), status, null, null, null, null, null, null, null, null, null, null, null, signals, config);
    }

    private static @Nullable String create(@NonNull PowerModeSetting setting, @NonNull IClocksConfig config) {
        String valueName = null;
        String valueDescription = null;
        SettingValue currentValue = config.getSettingsConfig().getSettingValue(setting);
        Object selectedMode = currentValue.getValue();
        if (selectedMode instanceof PowerMode) {
            valueName = currentValue.getUiValue();
            valueDescription = ((PowerMode)selectedMode).getDescription();
        }
        return ToolTipBuilder.create(setting.getId(), null, setting.getName(), null, setting.getDescription(), null, null, null, valueName, valueDescription, null, null, null, null, null, null, null, null, config);
    }

    public static @NonNull String create(@NonNull IClockElement element, @NonNull IClocksConfig config) {
        ISetting setting = element.getMainSetting();
        if (setting == null) {
            return ToolTipBuilder.create(element, config, null, true, null);
        }
        return UtilsText.safeString((String)ToolTipBuilder.create(element, setting, config));
    }

    public static @NonNull String createForNonavailable(@NonNull String id, @Nullable String component) {
        return ToolTipBuilder.create(id, component, null, null, null, Messages.get().ToolTipBuilder_UnavailableElementToolTip, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private static @NonNull String create(@NonNull String id, @Nullable String component, @Nullable String name, @Nullable String objectType, @Nullable String description, @Nullable String status, @Nullable String errorMsg, @Nullable String warningMsg, @Nullable String value, @Nullable String valueDescription, @Nullable String clockSourceType, @Nullable String constraints, @Nullable String consumers, @Nullable String enableDisableReason, @Nullable String outputFreq, @Nullable String requiredValue, @Nullable String pinSignals, @Nullable String masterSlaveInfo, @Nullable IClocksConfig config) {
        StringBuilder result = new StringBuilder();
        StringBuilder nameBld = new StringBuilder();
        if (!UtilsText.isEmpty((String)name)) {
            nameBld.append(UtilsText.htmlB((String)name));
        }
        nameBld.append(" ").append('[');
        if (!UtilsText.isEmpty((String)objectType)) {
            nameBld.append(Messages.get().ToolTipBuilder_ElementType).append(objectType).append(',').append(" ");
        }
        nameBld.append(Messages.get().ToolTipBuilder_Id).append(" ").append(id);
        if (!UtilsText.isEmpty((String)component)) {
            nameBld.append(',').append(" ").append(Messages.get().ToolTipBuilder_Component).append(" ").append(component);
        }
        nameBld.append(']');
        result.append((CharSequence)nameBld).append("<br/>");
        if (!UtilsText.isEmpty((String)description)) {
            result.append(description).append("<br/>");
        }
        if (result.length() > 0) {
            result.append("<br/>");
        }
        if (!UtilsText.isEmpty((String)clockSourceType)) {
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_ClockSourceType)).append("<br/>").append(clockSourceType).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)consumers)) {
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_ConsumedBy)).append("<br/>").append(consumers).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)pinSignals)) {
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_PinSignals)).append("<br/>").append(pinSignals).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)status)) {
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_StatusInfo)).append("<br/>").append(status).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)errorMsg)) {
            assert (errorMsg != null);
            result.append(UtilsText.htmlB((String)ToolTipBuilder.colorize(Messages.get().ToolTipBuilder_Errors, "red"))).append("<br/>").append(errorMsg.replace("\n", "<br/>")).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)warningMsg)) {
            assert (warningMsg != null);
            result.append(UtilsText.htmlB((String)ToolTipBuilder.colorize(Messages.get().ToolTipBuilder_Warnings, "orange"))).append("<br/>").append(warningMsg.replace("\n", "<br/>")).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)enableDisableReason)) {
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_EnableDisable)).append("<br/>").append(enableDisableReason).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)masterSlaveInfo)) {
            result.append(masterSlaveInfo).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)constraints)) {
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_Constraints)).append("<br/>").append(constraints).append("<br/>");
        }
        StringBuilder valueBld = new StringBuilder();
        if (!UtilsText.isEmpty((String)requiredValue)) {
            valueBld.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_Requirement)).append("<br/>").append(requiredValue).append("<br/>");
        }
        if (!UtilsText.isEmpty((String)value)) {
            valueBld.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_Value)).append("<br/>").append(value);
        }
        if (!UtilsText.isEmpty((String)valueDescription)) {
            valueBld.append(" \u2012 ");
            valueBld.append(valueDescription);
        }
        if (valueBld.length() > 0) {
            valueBld.append("<br/>");
        }
        result.append((CharSequence)valueBld);
        if (!UtilsText.isEmpty((String)outputFreq)) {
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_Output)).append("<br/>").append(outputFreq).append("<br/>");
        }
        String resultMsg = null;
        resultMsg = config != null ? ToolTipBuilder.resolveText(result.toString(), config.getMcu()) : ToolTipFormatter.format(UtilsText.safeString((String)result.toString()));
        return UtilsText.safeString((String)resultMsg);
    }

    private static @NonNull String colorize(@Nullable String text, @NonNull String color) {
        if (Rap.isActive()) {
            return UtilsText.htmlSpan((String)text, (String)color);
        }
        return UtilsText.htmlFont((String)text, (String)color);
    }

    public static @NonNull String create(@NonNull IConfigElement element, @NonNull IClocksConfig config) {
        SettingValue enableSettingValue;
        EnableSetting enableSetting;
        String valueName = null;
        String valueDescription = null;
        StringBuilder status = new StringBuilder();
        IConfigElementItem activeItem = element.getActiveItem(config);
        if (activeItem == null) {
            valueName = element.getName();
            valueDescription = element.getDescription();
        } else {
            valueName = activeItem.getName();
            valueDescription = activeItem.getDescription();
        }
        if (element.isDisabled(config) && (enableSetting = element.getEnableSetting()) != null && (enableSettingValue = enableSetting.createCurrentValue(config)).getValue() instanceof EnableSetting.EnableType) {
            EnableSetting.EnableType enableValue = (EnableSetting.EnableType)((Object)enableSettingValue.getValue());
            String enable = enableSetting.activeCase(config, new HashSet<String>()).getDescription();
            switch (enableValue) {
                case HARD_DISABLE: {
                    status.append(Messages.get().ToolTipBuilder_ElementIsDisabled);
                    status.append(DASH_UNICODE).append(enable);
                    break;
                }
                case SOFT_DISABLE: {
                    status.append(Messages.get().ToolTipBuilder_ElementIsInactive);
                    break;
                }
            }
        }
        return ToolTipBuilder.create(element.getID(), null, element.getName(), null, element.getDescription(), status.toString(), ToolTipBuilder.getErrors(config, element.getID()), ToolTipBuilder.getWarnings(config, element.getID()), valueName, valueDescription, null, null, null, null, null, null, null, null, config);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull String create(@NonNull IClockElement element, @NonNull IClocksConfig config, @Nullable String currentValue, boolean showOutputFrequency, @Nullable String lock) {
        IClockComponent component;
        List<IClockElement> internals;
        List<String> consumersList;
        String enable = element.getEnableText(config);
        String error = ToolTipBuilder.getErrors(config, element.getID());
        String warning = ToolTipBuilder.getWarnings(config, element.getID());
        StringBuilder status = new StringBuilder();
        ISetting frequencyModifierSetting = element.getFrequencyModifierSetting();
        Set<String> controlSettings = null;
        if (frequencyModifierSetting != null) {
            controlSettings = config.getMcu().getControlSettings(frequencyModifierSetting.getId());
        }
        if (element.isDisabled(config) || controlSettings != null) {
            SettingValue enableSettingValue;
            EnableSetting enableSetting;
            if (element.isDisabled(config) && (enableSetting = element.getEnableSetting()) != null && (enableSettingValue = SettingProvider.getValueBySettingId(enableSetting.getId(), config.getMcu(), config.getSettingsConfig())) != null && enableSettingValue.getValue() instanceof EnableSetting.EnableType) {
                EnableSetting.EnableType enableValue = (EnableSetting.EnableType)((Object)enableSettingValue.getValue());
                switch (enableValue) {
                    case HARD_DISABLE: {
                        status.append(Messages.get().ToolTipBuilder_ElementIsDisabled);
                        if (enable == null) break;
                        status.append(DASH_UNICODE).append(enable);
                        break;
                    }
                    case SOFT_DISABLE: {
                        status.append(Messages.get().ToolTipBuilder_ElementIsInactive);
                        break;
                    }
                }
            }
            if (controlSettings != null && !controlSettings.isEmpty()) {
                if (status.length() > 0) {
                    status.append("<br/>");
                }
                status.append(String.valueOf(Messages.get().ToolTipBuilder_SettingIsControlled) + UtilsText.join(controlSettings, (String)", "));
            }
        }
        String consumers = null;
        if (element instanceof ClockOutput && !(consumersList = ClockElementUtils.getClocksOutputConsumers((ClockOutput)element, config)).isEmpty()) {
            consumers = Text.collectionToString(consumersList);
        }
        String clockSourceType = null;
        if (element instanceof ClockSource) {
            boolean fixedRange;
            ClockSource clockSource = (ClockSource)element;
            String frequencySettings = ToolTipBuilder.getFrequencySettings(clockSource, config);
            boolean bl = fixedRange = ToolTipBuilder.hasFixedRange(clockSource, config) && frequencySettings == null;
            if (clockSource.isFixed() || fixedRange) {
                clockSourceType = Messages.get().ToolTipBuilder_FixedClockSource;
            } else if (clockSource.isTrimmable()) {
                clockSourceType = Messages.get().ToolTipBuilder_TrimmableClockSource;
            } else if (frequencySettings != null) {
                clockSourceType = MessageFormat.format(Messages.get().ToolTipBuilder_VariableFrequencyListClockSource, frequencySettings);
            } else {
                String rangesText = "";
                ValueMap activeValueMap = clockSource.getActiveValueMap(config);
                if (activeValueMap != null) {
                    Collection<@NonNull Object> ranges = activeValueMap.getControlValues();
                    rangesText = Text.collectionToString(ranges);
                }
                clockSourceType = MessageFormat.format(Messages.get().ToolTipBuilder_VariableClockSource, rangesText);
            }
        }
        StringBuilder constraints = new StringBuilder();
        @Nullable String @Nullable [] conditions = element.getConstraintsText(config);
        if (element instanceof AClockElement && (internals = ((AClockElement)element).getInternalElements()) != null) {
            for (IClockElement internal : internals) {
                @Nullable String @Nullable [] internalConditions = internal.getConstraintsText(config);
                if (internalConditions == null) continue;
                int i = 0;
                while (i < internalConditions.length) {
                    internalConditions[i] = String.valueOf(UtilsText.htmlB((String)(String.valueOf(internal.getName()) + ": "))) + internalConditions[i];
                    ++i;
                }
                if (conditions == null) {
                    conditions = (String[])internalConditions.clone();
                    continue;
                }
                ArrayList<String> conditionsAsList = new ArrayList<String>(Arrays.asList(conditions));
                conditionsAsList.addAll(Arrays.asList(internalConditions));
                conditions = conditionsAsList.toArray(new String[0]);
            }
        }
        if (constraints.length() != 0) {
            constraints.append("<br/>");
        }
        constraints.append(ToolTipBuilder.formatConstraints(conditions));
        StringBuilder masterText = new StringBuilder();
        if (element instanceof Prescaler) {
            IConfigElement cfgElemMaster = ((Prescaler)element).getMasterIfCorrect(config);
            if (cfgElemMaster != null) {
                masterText.append(String.valueOf(UtilsText.htmlB((String)"CLOCK GROUP:")) + "<br/>" + "This prescaler belongs to clock group controlled by " + cfgElemMaster.getName());
            } else {
                ENodeType elementType;
                @NonNull List masters = element.getDevice().getListOfMasters();
                if (!masters.isEmpty()) {
                    ArrayList<@NonNull String> masterNames = new ArrayList<String>();
                    for (String masterID : masters) {
                        IClockElement masterElement = config.getMcu().getClockElement(masterID);
                        if (masterElement == null) continue;
                        masterNames.add(masterElement.getName());
                    }
                    if (!masterNames.isEmpty()) {
                        masterText.append(String.valueOf(UtilsText.htmlB((String)"MASTERS:")) + "<br/>" + "This prescaler is slave to these prescalers and it's scale value must integer divide scale value of each master. Master prescalers: " + UtilsText.join((String[])masterNames.toArray(new String[0]), (String)", "));
                    }
                }
                if ((elementType = element.getDevice().getType()) == ENodeType.DivMaster || elementType == ENodeType.DivMasterSlave) {
                    if (!UtilsText.isEmpty((String)masterText.toString())) {
                        masterText.append("<br/>");
                    }
                    ArrayList<@NonNull String> slaveNames = new ArrayList<String>();
                    for (IClockElement slave : ((Prescaler)element).getSlaves(config)) {
                        slaveNames.add(slave.getName());
                    }
                    if (!slaveNames.isEmpty()) {
                        masterText.append(String.valueOf(UtilsText.htmlB((String)"SLAVES:")) + "<br/>" + "This prescaler is master to these slave prescalers: " + UtilsText.join((String[])slaveNames.toArray(new String[0]), (String)", "));
                    }
                }
            }
        }
        String otherPMConstraints = ToolTipBuilder.otherPowerModeConstraints(element, config);
        constraints.append(otherPMConstraints);
        String outputFreq = null;
        ISetting outFreqSetting = element.getOutputFrequencySetting();
        SettingValue outputValue = config.getSettingsConfig().getSettingValue(outFreqSetting);
        if (showOutputFrequency && !outputValue.isN_A()) {
            outputFreq = ToolTipBuilder.getValueText(outFreqSetting, outputValue);
        }
        String compName = (component = element.getParentComponent(config.getMcu())) == null ? null : component.getName();
        return ToolTipBuilder.create(element.getID(), compName, element.getName(), element.getType(), element.getDescription(), status.toString(), error, warning, currentValue, null, clockSourceType, constraints.toString(), consumers, enable, outputFreq, lock, null, masterText.toString(), config);
    }

    private static @NonNull String getValueText(@NonNull ISetting setting, @NonNull SettingValue value) {
        boolean isFrequencyOutput = setting.getType().equals((Object)SettingType.FREQUENCY_OUTPUT);
        boolean isClockSelect = setting instanceof ClockSelectSetting;
        boolean showUiValue = value.isN_A() || !isFrequencyOutput || setting.toString(value).contains("/");
        boolean showValue = !value.isN_A() && (isFrequencyOutput || isClockSelect);
        String result = "";
        if (showUiValue && showValue) {
            result = UtilsText.safeString((String)String.format("%s (%s)", value.getUiValue(), setting.toString(value)));
        } else if (showUiValue) {
            result = value.getUiValue();
        } else if (showValue) {
            result = setting.toString(value);
        }
        return result;
    }

    private static final @Nullable String resolveText(@Nullable String text, @NonNull IMcu mcu) {
        String result = null;
        if (text != null) {
            result = SettingIdResolver.resolve(text, mcu);
        }
        return result;
    }

    private static boolean hasFixedRange(@NonNull AClockElement element, @NonNull IClocksConfig config) {
        ISetting mainSetting = element.getMainSetting();
        if (mainSetting != null) {
            Range rangeOfValues = mainSetting.getRangeOfValues(config);
            if (rangeOfValues != null) {
                return rangeOfValues.isFixed();
            }
            ValueMap activeValueMap = element.getActiveValueMap(config);
            if (activeValueMap != null) {
                return CollectionsUtils.getInstancesOf(activeValueMap.getControlValues(), Range.class).allMatch(x -> x.isFixed());
            }
        }
        return false;
    }

    private static @Nullable String getFrequencySettings(@NonNull AClockElement element, @NonNull IClocksConfig config) {
        ValueMap activeValueMap;
        ISetting mainSetting = element.getMainSetting();
        if (mainSetting != null && (activeValueMap = element.getActiveValueMap(config)) != null) {
            StringJoiner joiner = new StringJoiner(", ");
            CollectionsUtils.getInstancesOf(activeValueMap.getControlValues(), Frequency.class).forEach(x -> {
                StringJoiner stringJoiner2 = joiner.add(x.toString());
            });
            String result = joiner.toString();
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    private static @NonNull String otherPowerModeConstraints(@NonNull IClockElement element, @NonNull IClocksConfig config) {
        SettingValue powerModeValue;
        PowerModeSetting powerModeSetting = (PowerModeSetting)config.getMcu().getSettings().getGlobalSettings().stream().filter(x -> x instanceof PowerModeSetting).findFirst().get();
        List<@NonNull SettingValue> availablePowerModes = powerModeSetting.getValues(config);
        if (availablePowerModes == null) {
            return "";
        }
        List<@NonNull Constraint> elemConstraints = element.getElementConstraints();
        Map<@NonNull PowerMode, Frequency[]> table = new HashMap<PowerMode, Frequency[]>();
        for (Constraint constraint : elemConstraints) {
            table = ToolTipBuilder.addConstraintToMap(constraint, table, availablePowerModes);
        }
        Object value = config.getSettingsConfig().getSettingValue(powerModeSetting).getValue();
        PowerMode activePowerMode = null;
        if (value instanceof PowerMode) {
            activePowerMode = (PowerMode)value;
        } else if (value instanceof String && (powerModeValue = powerModeSetting.fromString((String)value, config)) != null && powerModeValue.getValue() instanceof PowerMode) {
            activePowerMode = (PowerMode)powerModeValue.getValue();
        }
        if (activePowerMode != null) {
            table.remove(activePowerMode);
            if (!table.isEmpty()) {
                StringBuilder tableBuilder = new StringBuilder();
                tableBuilder.append("<br/>").append(UtilsText.htmlB((String)Messages.get().ToolTipBuilder_OtherPowerModes)).append("<br/>");
                table.forEach((k, v) -> {
                    String inputToolTip;
                    if (((Frequency[])v).length != 4) {
                        throw new IllegalArgumentException("Frequency array for each PowrMode is expected to have 4 values!");
                    }
                    tableBuilder.append(k.getName()).append(": ");
                    String outputToolTip = ErrorHelper.extractFrequencyErrorMessage(false, v[0], v[1], null);
                    if (outputToolTip != null) {
                        tableBuilder.append(outputToolTip);
                    }
                    if ((inputToolTip = ErrorHelper.extractFrequencyErrorMessage(true, v[2], v[3], null)) != null) {
                        tableBuilder.append(inputToolTip);
                    }
                    tableBuilder.append("<br/>");
                });
                return tableBuilder.toString();
            }
        }
        return "";
    }

    private static Map<@NonNull PowerMode, Frequency[]> addConstraintToMap(@NonNull Constraint constraint, Map<@NonNull PowerMode, Frequency[]> map, @NonNull Collection<@NonNull SettingValue> availablePowerModes) {
        Collection<@NonNull PowerMode> relatedPowerModes = constraint.getInfluencedPowerModes(availablePowerModes);
        for (PowerMode powerMode : relatedPowerModes) {
            Frequency min = constraint.getMinFrequency();
            Frequency max = constraint.getMaxFrequency();
            if (!map.containsKey(powerMode)) {
                if (constraint.isOnInput()) {
                    Frequency[] frequencyArray = new Frequency[4];
                    frequencyArray[2] = min;
                    frequencyArray[3] = max;
                    map.put(powerMode, frequencyArray);
                    continue;
                }
                Frequency[] frequencyArray = new Frequency[4];
                frequencyArray[0] = min;
                frequencyArray[1] = max;
                map.put(powerMode, frequencyArray);
                continue;
            }
            int minIndex = 0;
            int maxIndex = 1;
            if (constraint.isOnInput()) {
                minIndex = 2;
                maxIndex = 3;
            }
            Frequency[] updated = new Frequency[4];
            Frequency[] old = Objects.requireNonNull(map.get(powerMode));
            if (old[minIndex] == null) {
                updated[minIndex] = min;
            } else if (old[minIndex].compareTo(min) < 0) {
                updated[minIndex] = min;
            }
            if (old[maxIndex] == null) {
                updated[maxIndex] = max;
            } else if (old[maxIndex].compareTo(max) > 0) {
                updated[maxIndex] = max;
            }
            map.put(powerMode, updated);
        }
        return map;
    }

    private static @NonNull String formatConstraints(@Nullable String @Nullable [] constraints) {
        if (constraints == null || constraints.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int constraintIndex = 1;
        String[] stringArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            String constraint = stringArray[n2];
            result.append(String.valueOf(constraintIndex) + CONSTRAINT_INDEX_SEPARATOR + constraint);
            if (constraintIndex < constraints.length) {
                result.append("<br/>");
            }
            ++constraintIndex;
            ++n2;
        }
        return result.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull String getErrors(@NonNull IClocksConfig config, @NonNull String elementId) {
        @NonNull @NonNull List problemsOfElement = (List)config.getProblemsOfElement(elementId, 2).stream().map(ClocksProblem::getTooltip).collect(CollectorsUtils.toList());
        return UtilsText.join((Collection)problemsOfElement, (String)"\n");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull String getWarnings(@NonNull IClocksConfig config, @NonNull String elementId) {
        @NonNull @NonNull List problemsOfElement = (List)config.getProblemsOfElement(elementId, 1).stream().map(ClocksProblem::getTooltip).collect(CollectorsUtils.toList());
        return UtilsText.join((Collection)problemsOfElement, (String)"\n");
    }
}

