/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.toolbar;

import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.elements.ValueConfigElement;
import com.nxp.swtools.clocks.data.model.ClocksConfig;
import com.nxp.swtools.clocks.data.model.EmptyConfig;
import com.nxp.swtools.clocks.data.model.EmptyMcu;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.clocks.ui.toolbar.FunctionElementValueChangeListener;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.utils.dialog.FnGroupPrefix;
import com.nxp.swtools.utils.dialog.IChangeListener;
import com.nxp.swtools.utils.dialog.IFunctionPrefix;
import com.nxp.swtools.utils.dialog.IFunctionalGroupUpdateListener;
import com.nxp.swtools.utils.dialog.ISelectedFunctionProvider;
import com.nxp.swtools.utils.dialog.ISpecificContent;
import com.nxp.swtools.utils.dialog.SpecificContent;
import com.nxp.swtools.utils.dialog.ToolFunctionBuffer;
import com.nxp.swtools.utils.dialog.ToolFunctionModification;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.text.TextBoxHelper;
import com.nxp.swtools.utils.toolbar.AFunctionManager;
import com.nxp.swtools.utils.tools.IToolFunction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ClocksFunctionManager
extends AFunctionManager {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ClocksFunctionManager.class);
    @Nullable
    private ToolFunctionBuffer functionsBuffer;

    public ClocksFunctionManager() {
        GuiController.getInstance().addListener(370, new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (event.originator != ClocksFunctionManager.this) {
                    ClocksFunctionManager.this.updateFunctionBar();
                }
            }
        });
    }

    public boolean removeFunction(@NonNull IToolFunction function) {
        if (!(function instanceof IClocksConfig)) {
            return false;
        }
        return GuiController.getInstance().removeConfig((IClocksConfig)function);
    }

    public List<? extends @NonNull IToolFunction> getFunctions() {
        return GuiController.getInstance().getProfile().getConfigs();
    }

    public @NonNull IToolFunction getWorkingFunction() {
        IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
        return activeConfig == null ? new EmptyConfig(new EmptyMcu(""), "") : activeConfig;
    }

    public void setWorkingFunction(@NonNull IToolFunction function) {
        if (!(function instanceof IClocksConfig)) {
            return;
        }
        GuiController.getInstance().getProfile().setActiveConfig((IClocksConfig)function);
        GuiController.getInstance().getProfile().regenerateCode();
        GuiController.getInstance().fireListeners(new ToolEvent.Builder(32).setOriginator((Object)this).build());
        this.updateFunctionBar();
    }

    public void setWorkingFunction(@NonNull IToolFunction function, boolean isUndoAction) {
        if (!(function instanceof IClocksConfig)) {
            return;
        }
        if (isUndoAction) {
            IClocksConfig config = (IClocksConfig)function;
            config.getSettingsConfig().clearChanges();
        }
        this.setWorkingFunction(function);
    }

    public void setCalledFromDefaultInit(@NonNull IToolFunction function, boolean called) {
        if (!(function instanceof IClocksConfig)) {
            return;
        }
        UiController uiController = UiController.getInstance();
        uiController.setConfigOfDefaultInit(called ? (IClocksConfig)function : null);
    }

    public boolean allowMultipleCallFromInit() {
        return false;
    }

    public IFunctionalGroupUpdateListener createSpecificProperties(@NonNull Composite parent, @NonNull ISelectedFunctionProvider selectedFunctionProvider, @NonNull List<@NonNull ToolFunctionModification> functions, @NonNull IChangeListener changeListener) {
        ToolFunctionModification function = selectedFunctionProvider.getSelectedFunction();
        if (function != null) {
            this.getFunctions();
            FnGroupPrefix fnGroupPrefix = new FnGroupPrefix(parent, selectedFunctionProvider, changeListener, Messages.get().FnGroupDialog_IdPrefixTooltip, ClocksFunctionManager::getToolSpecific, MessageFormat.format(Messages.get().FnGroupDialog_CustomIdPrefixTooltip, "#define"), Messages.get().FnGroupDialog_CustomIdPrefixText, Messages.get().FnGroupDialog_IdPrefixText, false);
            fnGroupPrefix.setFunctionsBuffer(this.functionsBuffer);
            IClocksProfile profile = GuiController.getInstance().getProfile();
            SettingsDB settingsDb = profile.getMcu().getSettings();
            ArrayList<@NonNull AGlobalSetting> globalSettings = new ArrayList<AGlobalSetting>(settingsDb.getGlobalSettings());
            HashMap<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos = new HashMap<AGlobalSetting, InstantSearchList>();
            HashMap<@NonNull AGlobalSetting, @NonNull Text> textFields = new HashMap<AGlobalSetting, Text>();
            IClocksConfig config = ClocksFunctionManager.getSelectedConfig(selectedFunctionProvider);
            for (AGlobalSetting setting : globalSettings) {
                Label title = new Label(parent, 0);
                title.setText(setting.getName());
                if (setting.getElement() instanceof ValueConfigElement) {
                    Text textField = new Text(parent, 2048);
                    textField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    textField.setTextLimit(250);
                    textFields.put(setting, textField);
                    TextBoxHelper.attachModifyListeners((Text)textField, c -> {
                        String selectedValue = UtilsText.safeString((String)textField.getText());
                        IClocksConfig selectedConfig = ClocksFunctionManager.getSelectedConfig(selectedFunctionProvider);
                        if (!selectedConfig.getSettingsConfig().getSettingValue(setting).getUiValue().equals(selectedValue) && !selectedValue.isEmpty()) {
                            SettingEditorHelper.setValue(setting, selectedConfig, selectedValue, new SettingValueChangeListener(textField));
                            ClocksFunctionManager.updateContent(combos, textFields, selectedConfig, fnGroupPrefix, selectedFunctionProvider);
                            if (!parent.isDisposed()) {
                                changeListener.propertiesChange();
                                textField.setSelection(selectedValue.length());
                                textField.setFocus();
                            }
                        }
                    });
                    ClocksFunctionManager.updateGlobalSettingsValues(textField, setting, config);
                    ClocksFunctionManager.updateGlobalSettingsState((Control)textField, setting, config);
                    continue;
                }
                InstantSearchList combo = new InstantSearchList(parent, 2048);
                combos.put(setting, combo);
                SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "comboBox_" + setting.getId());
                combo.addSelectionListener((SelectionListener)ClocksFunctionManager.createGlobalSettingsSelectionChangeListener(selectedFunctionProvider, changeListener, combos, textFields, setting, fnGroupPrefix));
                combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                ClocksFunctionManager.updateGlobalSettingsValues(combo, setting, config);
                ClocksFunctionManager.updateGlobalSettingsState((Control)combo, setting, config);
            }
            return ClocksFunctionManager.createFunctionalGroupUpdateListener(selectedFunctionProvider, combos, textFields, fnGroupPrefix);
        }
        LOGGER.warning("[CLOCKS] No functional group selected.");
        return null;
    }

    private static @NonNull IFunctionalGroupUpdateListener createFunctionalGroupUpdateListener(final @NonNull ISelectedFunctionProvider selectedFunctionProvider, final @NonNull Map<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos, final @NonNull Map<@NonNull AGlobalSetting, @NonNull Text> textFields, final @NonNull FnGroupPrefix fnGroupPrefix) {
        return new IFunctionalGroupUpdateListener(){

            public void updateFunctionalGroup(@NonNull ToolFunctionModification function) {
                IClocksConfig selectedConfig = ClocksFunctionManager.getSelectedConfig(selectedFunctionProvider);
                ClocksFunctionManager.updateContent(combos, textFields, selectedConfig, fnGroupPrefix, selectedFunctionProvider);
            }
        };
    }

    private static @NonNull SelectionAdapter createGlobalSettingsSelectionChangeListener(final @NonNull ISelectedFunctionProvider selectedFunctionProvider, final IChangeListener changeListener, final @NonNull Map<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos, final @NonNull Map<@NonNull AGlobalSetting, @NonNull Text> textFields, final @NonNull AGlobalSetting setting, final @NonNull FnGroupPrefix fnGroupPrefix) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedValue = UtilsText.safeString((String)e.text);
                IClocksConfig selectedConfig = ClocksFunctionManager.getSelectedConfig(selectedFunctionProvider);
                if (SettingEditorHelper.setValue(setting, selectedConfig, selectedValue, new FunctionElementValueChangeListener(combos))) {
                    ClocksFunctionManager.updateContent(combos, textFields, selectedConfig, fnGroupPrefix, selectedFunctionProvider);
                    changeListener.propertiesChange();
                }
            }
        };
    }

    static @NonNull IClocksConfig getSelectedConfig(ISelectedFunctionProvider selectedFunctionProvider) {
        IClocksConfig config;
        ToolFunctionModification selectedFunction = selectedFunctionProvider.getSelectedFunction();
        IClocksConfig iClocksConfig = config = selectedFunction != null && selectedFunction.getOriginalFunction() instanceof IClocksConfig ? (IClocksConfig)selectedFunction.getOriginalFunction() : GuiController.getInstance().getProfile().getActiveConfig();
        assert (config != null);
        return config;
    }

    static void updateGlobalSettingsValues(@NonNull Text textField, @NonNull AGlobalSetting setting, @NonNull IClocksConfig config) {
        if (textField.isDisposed()) {
            return;
        }
        SettingValue value = config.getSettingsConfig().getSettingValue(setting);
        textField.setText(value.getUiValue());
        boolean editable = setting.isEnabled(config) && setting.isEditable(config);
        textField.setEditable(editable);
        textField.setEnabled(editable);
    }

    static void updateGlobalSettingsValues(@NonNull InstantSearchList combo, @NonNull AGlobalSetting setting, @NonNull IClocksConfig config) {
        if (combo.isDisposed()) {
            return;
        }
        List<SettingValue> settingValues = setting.getValues(config);
        int size = settingValues == null ? 0 : settingValues.size();
        String[] values = new String[size];
        HashSet<@NonNull String> errorItems = new HashSet<String>();
        HashMap<String, String> itemToolTips = new HashMap<String, String>();
        int i = 0;
        while (i < size) {
            String value;
            assert (settingValues != null);
            SettingValue settingValue = settingValues.get(i);
            values[i] = value = settingValue.getUiValue();
            if (setting.hasConflicts(settingValue, config)) {
                errorItems.add(value);
            }
            String itemTooltip = setting.getToolTipText(settingValue, config);
            itemToolTips.put(value, com.nxp.swtools.clocks.utils.Text.replaceNewLinesWithSpace(itemTooltip));
            ++i;
        }
        combo.setItems(values);
        Image errorImg = ToolsImages.getStatusIcon((int)2);
        combo.setStatusItemProvider(it -> errorItems.contains(it) ? errorImg : null);
        itemToolTips.entrySet().forEach(x -> combo.addItemToolTip(UtilsText.safeString((String)((String)x.getKey())), (String)x.getValue()));
        SettingValue value = config.getSettingsConfig().getSettingValue(setting);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)combo, setting.getToolTipText(config));
        combo.select(value.getUiValue());
    }

    static void updateGlobalSettingsState(@NonNull Control control, @NonNull AGlobalSetting setting, @NonNull IClocksConfig config) {
        if (control.isDisposed()) {
            return;
        }
        control.setEnabled(setting.isEnabled(config) && setting.isEditable(config));
        SettingValue value = SettingProvider.getValueBySettingId(setting.getId(), config.getMcu(), config.getSettingsConfig());
        if (value != null) {
            Color comboBg = setting.isValid(value, config) ? null : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG");
            control.setBackground(comboBg);
            control.setForeground(setting.isValid(value, config) ? control.getDisplay().getSystemColor(21) : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_FG"));
        }
    }

    public boolean isToolSpecificPropertiesValid(@NonNull ToolFunctionModification function, @NonNull List<@NonNull ToolFunctionModification> functions) {
        ISpecificContent toolSpecific = function.getToolSpecific();
        if (toolSpecific instanceof IFunctionPrefix) {
            IFunctionPrefix functionPrefix = (IFunctionPrefix)toolSpecific;
            return FnGroupPrefix.isPrefixValid((IFunctionPrefix)functionPrefix) && !FnGroupPrefix.isPrefixEmpty((IFunctionPrefix)functionPrefix) && FnGroupPrefix.isPrefixUnique((IFunctionPrefix)functionPrefix, functions);
        }
        return true;
    }

    public void update(@NonNull List<@NonNull ToolFunctionModification> toolFunctions) {
        this.update(toolFunctions, false);
    }

    private void update(@NonNull List<@NonNull ToolFunctionModification> toolFunctions, boolean canceled) {
        GuiController controller = GuiController.getInstance();
        IClocksProfile profile = controller.getProfile();
        profile.removeAllConfigs();
        toolFunctions.forEach(x -> {
            if (!(x.getOriginalFunction() instanceof IClocksConfig)) {
                LOGGER.warning("Can't update Clocks Functional Group with name: " + x.getName());
            } else {
                IClocksConfig config = (IClocksConfig)x.getOriginalFunction();
                config.setCalledFromDefaultInit(x.isCalledFromDefaultInit());
                config.setName(x.getName());
                config.setDescription(x.getDescription());
                SpecificContent specific = ClocksFunctionManager.getToolSpecific(x);
                config.setPrefixUserDefined(specific.isPrefixUserDefined());
                if (specific.isPrefixUserDefined()) {
                    config.setIdPrefix(specific.getPrefix());
                } else {
                    config.setIdPrefix(x.getName());
                }
                HashMap<@NonNull ISetting, @Nullable SettingValue> lastlyChanged = new HashMap<ISetting, SettingValue>(config.getSettingsConfig().getLastlyChanged());
                config.recompute(null);
                lastlyChanged.entrySet().forEach(e -> config.getSettingsConfig().addLastlyChangedSetting((ISetting)e.getKey(), (SettingValue)e.getValue()));
                profile.addConfig(config);
                IClocksConfig activeConfig = profile.getActiveConfig();
                if (activeConfig != null && config.getName().equals(activeConfig.getName())) {
                    profile.setActiveConfig(config);
                }
            }
        });
        profile.regenerateCode();
        if (!canceled) {
            controller.fireListeners(new ToolEvent.Builder(-1).setOriginator((Object)this).build());
        } else {
            controller.fireListeners(new ToolEvent.Builder(256).setOriginator((Object)this).build());
        }
    }

    public String getReservedFunctionName() {
        return "BOARD_InitBootClocks";
    }

    public @NonNull IToolFunction createNewFunction(@NonNull String functionName) {
        IClocksProfile profile = GuiController.getInstance().getProfile();
        IClocksConfig newDefaultConfig = profile.createDefaultConfig();
        newDefaultConfig.setCalledFromDefaultInit(false);
        newDefaultConfig.setName(functionName);
        newDefaultConfig.setDescription("");
        newDefaultConfig.setPrefixUserDefined(false);
        newDefaultConfig.setIdPrefix(functionName);
        return newDefaultConfig;
    }

    public int getMaxToolFunctions() {
        return 20;
    }

    public @NonNull String getDefaultFunctionName() {
        return "ClocksFunc_";
    }

    public @NonNull IToolFunction copyFunction(@NonNull ToolFunctionModification functionToCopy) {
        IClocksConfig originalFunction = (IClocksConfig)functionToCopy.getOriginalFunction();
        IClocksConfig newFunction = originalFunction.clone(originalFunction.getClocksModel());
        return newFunction;
    }

    public @Nullable StorageTool getStorageTool() {
        return SWToolsPlatform.getSharedConfigurationSingleton().getTools().getClock();
    }

    public void setFunctionsBuffer(ToolFunctionBuffer functionsBuffer) {
        this.functionsBuffer = this.getUnModifiedFunctionBuffer(functionsBuffer);
    }

    private @NonNull ToolFunctionBuffer getUnModifiedFunctionBuffer(@NonNull ToolFunctionBuffer buffer) {
        ArrayList<@NonNull E> functions = new ArrayList();
        buffer.getFunctions().forEach(f -> {
            IToolFunction copy = this.copyFunction((ToolFunctionModification)f);
            functions.add(copy);
        });
        return new ToolFunctionBuffer(functions, this.getWorkingFunction().getName());
    }

    static void updateContent(@NonNull Map<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos, @NonNull Map<@NonNull AGlobalSetting, @NonNull Text> textFields, @NonNull IClocksConfig selectedConfig, @NonNull FnGroupPrefix fnGroupPrefix, @NonNull ISelectedFunctionProvider selectedFunctionProvider) {
        combos.entrySet().forEach(entry -> ClocksFunctionManager.updateGlobalSettingsValues((InstantSearchList)entry.getValue(), (AGlobalSetting)entry.getKey(), selectedConfig));
        combos.entrySet().forEach(entry -> ClocksFunctionManager.updateGlobalSettingsState((Control)entry.getValue(), (AGlobalSetting)entry.getKey(), selectedConfig));
        textFields.entrySet().forEach(entry -> ClocksFunctionManager.updateGlobalSettingsValues((Text)entry.getValue(), (AGlobalSetting)entry.getKey(), selectedConfig));
        textFields.entrySet().forEach(entry -> ClocksFunctionManager.updateGlobalSettingsState((Control)entry.getValue(), (AGlobalSetting)entry.getKey(), selectedConfig));
        ToolFunctionModification function = selectedFunctionProvider.getSelectedFunction();
        if (function != null) {
            fnGroupPrefix.updateTextAndSelection(function);
        }
    }

    private static @NonNull SpecificContent getToolSpecific(ToolFunctionModification function) {
        SpecificContent specificContent = (SpecificContent)function.getToolSpecific();
        if (specificContent == null) {
            ClocksConfig functionalGroup = (ClocksConfig)function.getOriginalFunction();
            specificContent = new SpecificContent();
            specificContent.setPrefix(functionalGroup.getIdPrefix());
            specificContent.setPrefixUserDefined(functionalGroup.isPrefixUserDefined());
            function.setToolSpecific((ISpecificContent)specificContent);
        }
        return specificContent;
    }

    public void rollback() {
        if (this.functionsBuffer != null) {
            this.update(this.functionsBuffer.getFunctions(), true);
        }
    }
}

