/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.table;

import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.ValueConfigElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.platform.IPlatformSpecific;
import com.nxp.swtools.clocks.platform.PlatformSpecificFactory;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.IValueChangeListener;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.SettingValueDialog;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.ASettingEditingSupport;
import com.nxp.swtools.clocks.ui.table.BaseSettingColumnLabelProvider;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.clocks.ui.table.SettingsContentProvider;
import com.nxp.swtools.clocks.ui.table.SettingsInput;
import com.nxp.swtools.clocks.utils.ToolTipBuilder;
import com.nxp.swtools.common.ui.utils.editors.InstantSearchCellEditor;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.ScrollPersister;
import com.nxp.swtools.common.ui.utils.swt.ScrollState;
import com.nxp.swtools.common.ui.utils.swt.grid.ExpandedState;
import com.nxp.swtools.common.ui.utils.swt.grid.TreeExpandHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.storage.StorageHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.jface.gridviewer.GridTreeViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SettingsTable {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SettingsTable.class);
    private static final int EXPAND_LEVEL = 3;
    private static final int COLUMN_VALUE_WIDTH = Rap.isActive() ? 350 : 250;
    private static final int COLUMN_NAME_WIDTH = Rap.isActive() ? 275 : 200;
    private static final int COLUMN_IMAGE_WIDTH = Rap.isActive() ? 27 : 24;
    private static final int COLUMN_ACCURACY_WIDTH = Rap.isActive() ? 75 : 50;
    @NonNull
    final Grid grid;
    @NonNull
    final GridTreeViewer gridViewer;
    @Nullable
    IValueChangeListener valueChangeListener;
    @NonNull
    private final Listener focusOutListener;
    @NonNull
    private final ISelectionChangedListener postSelectionChangeListener;
    @NonNull
    final @NonNull Set<@NonNull String> highlightedNodes = new HashSet<String>();
    @NonNull
    final String widthsId;
    @Nullable
    ISortChangeListener sortChangeListener;
    boolean sortRoots = true;
    @NonNull
    final GuiController guiController = GuiController.getInstance();
    int lockColumnIdx = -1;
    protected boolean menuAllowed = true;
    @NonNull
    private final StorageHelper storageHelper = new StorageHelper(3);

    public SettingsTable(@NonNull Composite composite, @NonNull String widthsId, boolean lockColumn, boolean connectionColumn) {
        this(composite, widthsId, lockColumn, connectionColumn, 772);
    }

    public SettingsTable(@NonNull Composite composite, @NonNull String widthsId, boolean lockColumn, boolean connectionColumn, int style) {
        this.widthsId = widthsId;
        this.grid = new Grid(composite, style);
        this.grid.setLayoutData((Object)new GridData(1808));
        SWTFactoryProxy.INSTANCE.enableHtmlTooltip((Control)this.grid);
        this.grid.setHeaderVisible(true);
        this.grid.setLinesVisible(false);
        IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
        platformSpecific.setTreeLinesVisible(this.grid, false);
        this.gridViewer = new GridTreeViewer(this.grid);
        this.gridViewer.setContentProvider((IContentProvider)new SettingsContentProvider());
        this.createColumns(lockColumn, connectionColumn);
        platformSpecific.setDefaultColorScheme(this.grid);
        platformSpecific.makeItemsCollapsible(this.gridViewer);
        this.gridViewer.setInput((Object)new SettingsInput(new HashMap<String, Collection<ISetting>>()));
        this.gridViewer.expandToLevel(3);
        this.focusOutListener = this.createFocusOutListener();
        this.postSelectionChangeListener = this.createPostSelectionChangeListener();
        this.attachMenuListener();
        this.attachDoubleClickListener();
    }

    private void attachDoubleClickListener() {
        this.grid.addListener(8, event -> {
            GridItem gridItem = this.grid.getItem(new Point(event.x, event.y));
            if (gridItem != null) {
                Object selectedElement = gridItem.getData();
                if (this.lockColumnIdx >= 0 && gridItem.getBounds(this.lockColumnIdx).contains(event.x, event.y) && selectedElement instanceof ISettingNode) {
                    IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
                    ISetting setting = ((ISettingNode)selectedElement).getSetting();
                    if (activeConfig != null && setting != null && setting.isUserLockable() && !activeConfig.isLocked(setting) && !activeConfig.getSettingsConfig().getSettingValue(setting).isN_A()) {
                        SettingEditorHelper.lockSetting(setting, activeConfig, true, this.valueChangeListener);
                        this.refresh();
                    }
                }
                GuiController.showDetailsView();
            }
        });
    }

    private @NonNull Listener createFocusOutListener() {
        return e -> this.gridViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private int getSavedColumnWidth(@NonNull String columnId, int defaultWidth) {
        String id = String.valueOf(columnId) + "_" + this.widthsId;
        return this.storageHelper.loadInt(id, defaultWidth);
    }

    void saveColumnWidth(@NonNull String columnId, int width) {
        String id = String.valueOf(columnId) + "_" + this.widthsId;
        this.storageHelper.saveInt(id, width);
    }

    private @NonNull ISelectionChangedListener createPostSelectionChangeListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && !SettingsTable.this.gridViewer.isCellEditorActive()) {
                    SettingsTable.this.gridViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        };
    }

    private void attachMenuListener() {
        this.grid.addMenuDetectListener(e -> {
            if (this.menuAllowed) {
                GridItem currentItem;
                Menu oldMenu = this.grid.getMenu();
                if (this.grid.getItems().length != 0 && (currentItem = this.grid.getItem(this.grid.toControl(new Point(e.x, e.y)))) != null) {
                    Object selectedNode = currentItem.getData();
                    if (selectedNode instanceof ISettingNode && ((ISettingNode)selectedNode).getSetting() != null) {
                        MenuManager menuMgr = new MenuManager();
                        Menu menu = menuMgr.createContextMenu((Control)this.grid);
                        ISetting setting = ((ISettingNode)selectedNode).getSetting();
                        if (setting != null) {
                            menuMgr.add((IAction)new LockUnlockAction(setting, this.valueChangeListener, () -> this.gridViewer.refresh()));
                            Shell shell = this.grid.getShell();
                            if (shell != null && setting.isFindNearValueSupported()) {
                                menuMgr.add((IAction)new FindAction(setting, this.valueChangeListener, () -> this.gridViewer.refresh(), shell));
                            }
                        }
                        IClocksConfig activeConfig = this.guiController.getProfile().getActiveConfig();
                        if (setting != null && activeConfig != null && setting.getElement() instanceof ClockOutput) {
                            ClockOutput output = (ClockOutput)setting.getElement();
                            if (output.isDisabled(activeConfig)) {
                                menuMgr.add((IAction)new EnableOutputAction(setting, this.valueChangeListener, () -> this.gridViewer.refresh()));
                            }
                            if (!output.isValid(activeConfig)) {
                                menuMgr.add((IAction)new AdvancedResolverAction(setting, this.valueChangeListener, () -> this.gridViewer.refresh()));
                            }
                        }
                        this.grid.setMenu(menu);
                        if (Rap.isActive()) {
                            menu.setLocation(e.x, e.y);
                            menu.setVisible(true);
                        }
                    } else {
                        this.grid.setMenu(null);
                    }
                }
                if (oldMenu != null && oldMenu != this.grid.getMenu()) {
                    oldMenu.dispose();
                }
            }
        });
    }

    public void setLooseSelection(boolean looseSelection) {
        if (looseSelection) {
            this.grid.addListener(16, this.focusOutListener);
            this.gridViewer.addPostSelectionChangedListener(this.postSelectionChangeListener);
            this.menuAllowed = false;
        } else {
            this.grid.removeListener(16, this.focusOutListener);
            this.gridViewer.removePostSelectionChangedListener(this.postSelectionChangeListener);
            this.menuAllowed = true;
        }
    }

    public void setInput(@NonNull SettingsInput input) {
        if (!this.grid.isDisposed()) {
            Object currentInput = this.gridViewer.getInput();
            if (currentInput instanceof SettingsInput && input.isIdentical((SettingsInput)currentInput)) {
                this.refresh();
            } else {
                ScrollPersister scrollPersister = new ScrollPersister((Scrollable)this.grid);
                ScrollState scrollState = scrollPersister.getScollState();
                TreeExpandHelper expandHelper = new TreeExpandHelper((AbstractTreeViewer)this.gridViewer);
                ExpandedState expandedState = expandHelper.getExpandedState();
                this.gridViewer.setInput((Object)input);
                expandHelper.expandAllExcept(expandedState.getCollapsedElements());
                scrollPersister.restoreState(scrollState);
                this.grid.showSelection();
            }
        }
    }

    public void refresh() {
        this.gridViewer.refresh();
    }

    public void showSelection() {
        this.grid.showSelection();
    }

    public void refreshSetting(@NonNull ISetting setting) {
        GridItem[] gridItemArray = this.grid.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem item = gridItemArray[n2];
            Object data = item.getData();
            if (data instanceof ISettingNode && setting.equals(((ISettingNode)data).getSetting())) {
                this.gridViewer.refresh(data);
            }
            ++n2;
        }
    }

    public void selectSetting(@NonNull ISetting setting) {
        Collection<@NonNull GridItem> gridItems = this.findGridItems(setting);
        int[] indices = new int[gridItems.size()];
        int idx = 0;
        Iterator<@NonNull GridItem> gridItemIterator = gridItems.iterator();
        while (gridItemIterator.hasNext()) {
            indices[idx] = this.grid.indexOf(gridItemIterator.next());
            ++idx;
        }
        this.grid.select(indices);
    }

    protected @NonNull Collection<@NonNull GridItem> findGridItems(@NonNull ISetting setting) {
        ArrayList<@NonNull GridItem> itemsFound = new ArrayList<GridItem>();
        GridItem[] gridItemArray = this.grid.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISettingNode settingNode;
            GridItem item = gridItemArray[n2];
            Object data = item.getData();
            if (data instanceof ISettingNode && setting.equals((settingNode = (ISettingNode)data).getSetting())) {
                itemsFound.add(item);
            }
            ++n2;
        }
        return itemsFound;
    }

    private void createColumns(boolean lockColumn, boolean connectionColumn) {
        int createdColumns = 0;
        this.createNameColumn();
        ++createdColumns;
        if (connectionColumn) {
            this.createConnectionColumn();
            ++createdColumns;
        }
        if (lockColumn) {
            this.createLockColumn();
            this.lockColumnIdx = createdColumns++;
        }
        this.createValueColumn();
        ++createdColumns;
        if (lockColumn) {
            this.createAccuracyColumn();
            ++createdColumns;
        }
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)this.gridViewer);
    }

    private void createConnectionColumn() {
        GridColumn colChecks = new GridColumn(this.grid, 0);
        colChecks.setText(Messages.get().SettingsTable_ColumnConnected);
        colChecks.setHeaderTooltip(Messages.get().SettingsTable_ColumnConnected);
        this.setWidthRegisterWidthListener(colChecks, "check", COLUMN_IMAGE_WIDTH);
        GridViewerColumn colChecksViewer = new GridViewerColumn(this.gridViewer, colChecks);
        colChecksViewer.setLabelProvider((CellLabelProvider)new BaseSettingColumnLabelProvider(){

            @Override
            public @NonNull String getText(@NonNull ISettingNode node) {
                return "";
            }

            @Override
            public @Nullable Image getImage(@NonNull ISettingNode node) {
                ISetting setting = node.getSetting();
                IClocksConfig activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig();
                if (activeConfig != null && setting != null && setting.isUserEnableable()) {
                    String imageId = setting.isUserEnabled(activeConfig) ? "icons/checkbox_checked.png" : "icons/checkbox_unchecked.png";
                    return ToolsImages.getImage((String)imageId);
                }
                return null;
            }

            @Override
            public @Nullable String getToolTipText(@NonNull ISettingNode node) {
                ISetting setting = node.getSetting();
                IClocksConfig activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig();
                if (activeConfig != null && setting != null && setting.isUserEnableable()) {
                    if (setting.isUserEnabled(activeConfig)) {
                        return Messages.get().SettingsTable_ConnectionCheckBoxToolTip;
                    }
                    return Messages.get().SettingsTable_ConnectionCheckBoxNotCheckedToolTip;
                }
                return null;
            }
        });
        colChecksViewer.setEditingSupport((EditingSupport)new ASettingEditingSupport((ColumnViewer)this.gridViewer){

            @Override
            protected void setValue(@NonNull ISettingNode element, @Nullable Object value) {
            }

            @Override
            protected @Nullable Object getValue(@NonNull ISettingNode element) {
                return null;
            }

            @Override
            protected @Nullable CellEditor getCellEditor(@NonNull ISettingNode element) {
                ISetting setting = element.getSetting();
                IClocksProfile profile = SettingsTable.this.guiController.getProfile();
                IClocksConfig config = profile.getActiveConfig();
                if (config != null && setting != null) {
                    SettingsConfig settingsConfig = config.getSettingsConfig();
                    LockState lockState = settingsConfig.getLockState(setting);
                    SettingValue currentValue = settingsConfig.getSettingValue(setting);
                    boolean isUserEnabled = setting.isUserEnabled(config);
                    if (!isUserEnabled && (lockState != null && lockState.getValue().isUndefined() || lockState == null && currentValue.isUndefined())) {
                        SettingValueDialog settingValueDialog = SettingValueDialog.getDialogForSetting(SettingsTable.this.getShell(), setting, MessageFormat.format(Messages.get().SettingsTable_SetValueOfSetting, setting.getName()), String.valueOf(Messages.get().SettingsTable_ValueIsNotValid) + "\n" + setting.getAllowedValueDescription(config));
                        settingValueDialog.open();
                        currentValue = settingValueDialog.getValue();
                    } else if (lockState != null) {
                        currentValue = lockState.getValue();
                    }
                    if (currentValue != null) {
                        GuiController.getInstance().setEnableState(setting, config, currentValue, settingsConfig, isUserEnabled);
                        profile.regenerateCode();
                        SettingsTable.this.refresh();
                        SettingsTable.this.fireChangeEvent(setting, currentValue);
                    }
                }
                return null;
            }

            @Override
            protected boolean canEdit(@NonNull ISettingNode element) {
                ISetting setting = element.getSetting();
                return setting != null && setting.isUserEnableable();
            }
        });
    }

    private void enableSortingByNameFor(final @NonNull GridColumn gridColumn) {
        gridColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newSort;
                int oldSort = gridColumn.getSort();
                switch (oldSort) {
                    case 0: {
                        newSort = 1024;
                        break;
                    }
                    case 1024: {
                        newSort = 128;
                        break;
                    }
                    case 128: {
                        newSort = 0;
                        break;
                    }
                    default: {
                        newSort = 0;
                    }
                }
                SettingsTable.this.setColumnSorting(gridColumn, newSort);
            }
        });
    }

    public void setSortRootNodes(boolean sortRoots) {
        this.sortRoots = sortRoots;
    }

    private void createNameColumn() {
        GridColumn colNames = new GridColumn(this.grid, 0);
        colNames.setText(Messages.get().SettingsTable_ColumnName);
        colNames.setHeaderTooltip(Messages.get().SettingsTable_ColumnName_ToolTIp);
        this.setWidthRegisterWidthListener(colNames, "names", COLUMN_NAME_WIDTH);
        this.enableSortingByNameFor(colNames);
        GridViewerColumn colNamesViewer = new GridViewerColumn(this.gridViewer, colNames);
        colNamesViewer.setLabelProvider((CellLabelProvider)new BaseSettingColumnLabelProvider(colNames){
            private Font boldFont;
            {
                Font font = SettingsTable.this.grid.getFont();
                if (!$assertionsDisabled && font == null) {
                    throw new AssertionError();
                }
                this.boldFont = FontFactory.changeStyle((Font)font, (int)1);
                gridColumn.addDisposeListener(d -> this.boldFont.dispose());
            }

            @Override
            public String getText(ISettingNode node) {
                ISetting setting = node.getSetting();
                if (setting != null) {
                    return setting.getName();
                }
                IClockElement clockElement = SettingsTable.this.guiController.getProfile().getMcu().getClockElement(node.getId());
                if (clockElement != null) {
                    return clockElement.getName();
                }
                return node.getId();
            }

            @Override
            public int getColumnSpan(@NonNull ISettingNode node) {
                if (node.getSetting() == null) {
                    return SettingsTable.this.grid.getColumnCount();
                }
                return 0;
            }

            @Override
            public @Nullable Font getFont(ISettingNode node) {
                Font font = super.getFont(node);
                if (SettingsTable.this.highlightedNodes.contains(node.getId()) || node.getSetting() instanceof AGlobalSetting) {
                    font = this.boldFont;
                }
                return font;
            }

            @Override
            public String getToolTipText(ISettingNode node) {
                ISetting setting = node.getSetting();
                IClocksConfig activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig();
                if (activeConfig != null) {
                    if (setting != null) {
                        return setting.getToolTipText(activeConfig);
                    }
                    String name = node.getId();
                    IClockElement clockElement = SettingsTable.this.guiController.getProfile().getMcu().getClockElement(name);
                    if (clockElement != null) {
                        return ToolTipBuilder.create(clockElement, activeConfig);
                    }
                }
                return null;
            }

            @Override
            public Image getImage(ISettingNode node) {
                String name = node.getId();
                IClocksConfig activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig();
                if (activeConfig != null) {
                    if (activeConfig.getErrorsAsText(name) != null) {
                        return ToolsImages.getStatusDecoratorImg((int)2);
                    }
                    if (activeConfig.getWarningsAsText(name) != null) {
                        return ToolsImages.getStatusDecoratorImg((int)1);
                    }
                }
                return null;
            }
        });
    }

    private void createValueColumn() {
        GridColumn colValues = new GridColumn(this.grid, 0);
        colValues.setText(Messages.get().SettingsTable_ColumnValue);
        colValues.setHeaderTooltip(Messages.get().SettingsTable_ColumnValue);
        this.setWidthRegisterWidthListener(colValues, "values", COLUMN_VALUE_WIDTH);
        GridViewerColumn colValuesViewer = new GridViewerColumn(this.gridViewer, colValues);
        colValuesViewer.setLabelProvider((CellLabelProvider)new BaseSettingColumnLabelProvider(colValues){
            private Font boldFont;
            {
                Font font = SettingsTable.this.grid.getFont();
                if (!$assertionsDisabled && font == null) {
                    throw new AssertionError();
                }
                this.boldFont = FontFactory.changeStyle((Font)font, (int)1);
                gridColumn.addDisposeListener(d -> this.boldFont.dispose());
            }

            @Override
            public @NonNull String getText(@NonNull ISettingNode node) {
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    LockState lockState;
                    SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
                    String uiValue = value.getUiValue();
                    if (setting.isUserLockable() && (lockState = activeConfig.getSettingsConfig().getLockState(setting)) != null && !lockState.getUiValue().equals(uiValue)) {
                        return UtilsText.safeString((String)String.format("%s [%s]", lockState.getUiValue(), uiValue));
                    }
                    return SettingEditorHelper.getUiValueToShow(setting, value);
                }
                return "";
            }

            @Override
            public @Nullable Font getFont(ISettingNode node) {
                Font font = super.getFont(node);
                if (SettingsTable.this.highlightedNodes.contains(node.getId()) || node.getSetting() instanceof AGlobalSetting) {
                    font = this.boldFont;
                }
                return font;
            }

            @Override
            public @Nullable Image getImage(@NonNull ISettingNode node) {
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    IClockElement clockElement;
                    SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
                    if (!setting.isValid(value, activeConfig)) {
                        return ToolsImages.getStatusDecoratorImg((int)2);
                    }
                    if (activeConfig.getWarningsAsText(setting.getId()) != null) {
                        return ToolsImages.getStatusDecoratorImg((int)1);
                    }
                    IElement element = setting.getElement();
                    if (element instanceof IClockElement && (clockElement = (IClockElement)element).getMainSetting() == setting && activeConfig.getWarningsAsText(clockElement.getID()) != null) {
                        return ToolsImages.getStatusDecoratorImg((int)1);
                    }
                }
                return null;
            }

            @Override
            public @Nullable Color getBackground(@NonNull ISettingNode node) {
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    if (activeConfig.getSettingsConfig().isLastlyChanged(setting) || setting.getId().equals(UiController.getInstance().getLastlyChangedSetting())) {
                        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.highlight_change_BG");
                    }
                    SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
                    if (!setting.isValid(value, activeConfig)) {
                        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG");
                    }
                }
                return super.getBackground(node);
            }

            @Override
            public @Nullable Color getForeground(@NonNull ISettingNode node) {
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
                    if (!setting.isValid(value, activeConfig)) {
                        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_FG");
                    }
                    if (!setting.isEditable(activeConfig) || !setting.isEnabled(activeConfig)) {
                        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_FG");
                    }
                }
                return super.getForeground(node);
            }

            @Override
            public @Nullable String getToolTipText(@NonNull ISettingNode node) {
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    return setting.getToolTipText(activeConfig);
                }
                return null;
            }
        });
        colValuesViewer.setEditingSupport((EditingSupport)new ASettingEditingSupport((ColumnViewer)this.gridViewer){

            @Override
            protected CellEditor getCellEditor(ISettingNode element) {
                IClocksConfig activeConfig;
                ISetting setting = element.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    Control editorControl;
                    TextCellEditor editor = null;
                    @NonNull String[] values = SettingEditorHelper.getUiValuesForCombo(setting);
                    if (values != null) {
                        InstantSearchCellEditor instantSearchListEditor = new InstantSearchCellEditor((Composite)SettingsTable.this.grid, values, 0);
                        if (setting.getType().equals((Object)SettingType.FREQUENCY_OUTPUT)) {
                            instantSearchListEditor.setAllowCustomValue(true);
                        }
                        String selectedValue = SettingEditorHelper.getValue(setting, activeConfig);
                        instantSearchListEditor.setSelection(selectedValue);
                        editor = instantSearchListEditor;
                    }
                    if (editor == null && (editorControl = (editor = new TextCellEditor((Composite)SettingsTable.this.grid)).getControl()) instanceof Text) {
                        ((Text)editorControl).setTextLimit(20);
                        if (setting.getElement() instanceof ValueConfigElement) {
                            ((Text)editorControl).setTextLimit(250);
                        }
                    }
                    Control control = editor.getControl();
                    if (!$assertionsDisabled && control == null) {
                        throw new AssertionError();
                    }
                    SWTFactoryProxy.INSTANCE.setHtmlTooltip(control, SettingEditorHelper.getEditorToolTip(setting));
                    return editor;
                }
                return null;
            }

            @Override
            protected boolean canEdit(ISettingNode element) {
                IClocksConfig activeConfig;
                ISetting setting = element.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    return setting.isEditable(activeConfig);
                }
                return false;
            }

            @Override
            protected Object getValue(ISettingNode element) {
                IClocksConfig activeConfig;
                ISetting setting = element.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    SettingValue selectedValue = activeConfig.getSettingsConfig().getSettingValue(setting);
                    List<SettingValue> allowedValues = setting.getValues(activeConfig);
                    if (!(allowedValues == null || setting.isComboSuppressionAllowed() && allowedValues.size() > 256)) {
                        int selectedValuePosition = allowedValues.indexOf(selectedValue);
                        return selectedValuePosition;
                    }
                    return SettingEditorHelper.getValue(setting, activeConfig);
                }
                return null;
            }

            @Override
            protected void setValue(ISettingNode element, Object value) {
                ISetting setting = element.getSetting();
                if (setting != null && SettingEditorHelper.setValue(setting, value, SettingsTable.this.valueChangeListener)) {
                    SettingsTable.this.refresh();
                }
            }
        });
    }

    private void createLockColumn() {
        GridColumn colLocks = new GridColumn(this.grid, 0);
        colLocks.setText(Messages.get().SettingsTable_ColumnLock);
        colLocks.setHeaderTooltip(Messages.get().SettingsTable_ColumnLock);
        this.setWidthRegisterWidthListener(colLocks, "locks", COLUMN_IMAGE_WIDTH);
        GridViewerColumn colLocksViewer = new GridViewerColumn(this.gridViewer, colLocks);
        colLocksViewer.setLabelProvider((CellLabelProvider)new BaseSettingColumnLabelProvider(){

            @Override
            public @Nullable Image getImage(@NonNull ISettingNode node) {
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null && setting.isUserLockable() && activeConfig.getSettingsConfig().isLocked(setting)) {
                    return ToolsImages.getImage((String)"icons/locked.png");
                }
                return null;
            }

            @Override
            public String getText(ISettingNode element) {
                return "";
            }

            @Override
            public @Nullable String getToolTipText(@NonNull ISettingNode node) {
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null && setting.isUserLockable() && activeConfig.getSettingsConfig().isLocked(setting)) {
                    return Messages.get().SettingsTable_LockedSettingToolTip;
                }
                return null;
            }
        });
        colLocksViewer.setEditingSupport((EditingSupport)new ASettingEditingSupport((ColumnViewer)this.gridViewer){

            @Override
            protected void setValue(@NonNull ISettingNode element, @Nullable Object value) {
            }

            @Override
            protected @Nullable Object getValue(@NonNull ISettingNode element) {
                return null;
            }

            @Override
            protected @Nullable CellEditor getCellEditor(@NonNull ISettingNode element) {
                IClocksConfig activeConfig;
                ISetting setting = element.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null && setting.isUserLockable() && activeConfig.getSettingsConfig().isLocked(setting)) {
                    LockUnlockAction lockUnlockAction = new LockUnlockAction(setting, SettingsTable.this.valueChangeListener, () -> SettingsTable.this.gridViewer.refresh());
                    lockUnlockAction.run();
                }
                return null;
            }

            @Override
            protected boolean canEdit(@NonNull ISettingNode element) {
                IClocksConfig activeConfig;
                ISetting setting = element.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    return setting.isUserLockable() && activeConfig.getSettingsConfig().isLocked(setting);
                }
                return false;
            }
        });
    }

    private void setWidthRegisterWidthListener(final @NonNull GridColumn column, final @NonNull String colId, int colDefWidth) {
        int width = this.getSavedColumnWidth(colId, colDefWidth);
        column.setWidth(width);
        column.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                SettingsTable.this.saveColumnWidth(colId, column.getWidth());
            }
        });
    }

    private void createAccuracyColumn() {
        GridColumn colAccuracy = new GridColumn(this.grid, 0);
        colAccuracy.setText(Messages.get().SettingsTable_ColumnAccuracy);
        colAccuracy.setHeaderTooltip(Messages.get().SettingsTable_AcuracyColumnTooltip);
        this.setWidthRegisterWidthListener(colAccuracy, "accuracy", COLUMN_ACCURACY_WIDTH);
        GridViewerColumn colAccuracyViewer = new GridViewerColumn(this.gridViewer, colAccuracy);
        colAccuracyViewer.setLabelProvider((CellLabelProvider)new BaseSettingColumnLabelProvider(){

            @Override
            public String getText(@NonNull ISettingNode node) {
                BigRational accuracy;
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null && setting.isUserLockable() && activeConfig.getSettingsConfig().isLocked(setting) && (accuracy = activeConfig.getSettingsConfig().getLockAccuracy(setting)) != null) {
                    return com.nxp.swtools.clocks.utils.Text.accuracyToPercent(accuracy);
                }
                return "";
            }

            @Override
            public @Nullable String getToolTipText(@NonNull ISettingNode node) {
                IClocksConfig activeConfig;
                ISetting setting = node.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    BigRational accuracy = activeConfig.getSettingsConfig().getLockAccuracy(setting);
                    if (setting.isUserLockable() && activeConfig.getSettingsConfig().isLocked(setting) && accuracy != null) {
                        return MessageFormat.format(Messages.get().SettingsTable_AccuracyToolTip, com.nxp.swtools.clocks.utils.Text.accuracyToPercent(accuracy));
                    }
                }
                return null;
            }
        });
        colAccuracyViewer.setEditingSupport((EditingSupport)new ASettingEditingSupport((ColumnViewer)this.gridViewer){

            @Override
            protected void setValue(@NonNull ISettingNode element, @Nullable Object value) {
                String text;
                BigRational accuracy;
                IClocksConfig activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig();
                ISetting setting = element.getSetting();
                if (activeConfig != null && setting != null && value instanceof String && (accuracy = BigRational.tryParse((String)(text = (String)value))) != null) {
                    if ((accuracy = accuracy.divide(100)).compareTo(BigRational.ZERO) < 0) {
                        accuracy = accuracy.negate();
                    }
                    BigRational accuracyToSet = accuracy;
                    GuiController.getInstance().runBlocking(m -> {
                        activeConfig.changeLockAccuracy(setting, accuracyToSet, true);
                        SettingsTable.this.guiController.getProfile().regenerateCode();
                    });
                    SettingsTable.this.fireLockChangeEvent(setting, true);
                    SettingsTable.this.fireChangeEvent(setting, activeConfig.getSettingsConfig().getSettingValue(setting));
                    SettingsTable.this.refresh();
                }
            }

            @Override
            protected @Nullable Object getValue(@NonNull ISettingNode element) {
                BigRational accuracy;
                IClocksConfig activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig();
                ISetting setting = element.getSetting();
                if (activeConfig != null && setting != null && (accuracy = activeConfig.getSettingsConfig().getLockAccuracy(setting)) != null) {
                    accuracy = accuracy.multiply(100);
                    return accuracy.toExactDecimalString();
                }
                return null;
            }

            @Override
            protected @Nullable CellEditor getCellEditor(@NonNull ISettingNode element) {
                IClocksConfig activeConfig;
                ISetting setting = element.getSetting();
                if (setting != null && (activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig()) != null) {
                    TextCellEditor editor = new TextCellEditor((Composite)SettingsTable.this.grid);
                    Control editorControl = editor.getControl();
                    if (editorControl instanceof Text) {
                        ((Text)editorControl).setTextLimit(20);
                    }
                    return editor;
                }
                return null;
            }

            @Override
            protected boolean canEdit(@NonNull ISettingNode element) {
                IClocksConfig activeConfig = SettingsTable.this.guiController.getProfile().getActiveConfig();
                ISetting setting = element.getSetting();
                return activeConfig != null && setting != null && setting.isUserLockable() && activeConfig.getSettingsConfig().getLockAccuracy(setting) != null;
            }
        });
    }

    public @Nullable ISettingNode getSelectedSetting() {
        IStructuredSelection structuredSelection;
        Object firstSelectedElement;
        ISelection selection = this.gridViewer.getSelection();
        if (selection instanceof IStructuredSelection && (firstSelectedElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ISettingNode) {
            return (ISettingNode)firstSelectedElement;
        }
        return null;
    }

    public @NonNull GridTreeViewer getGridViewer() {
        return this.gridViewer;
    }

    public @NonNull Grid getGrid() {
        return this.grid;
    }

    void fireLockChangeEvent(@NonNull ISetting changedSetting, boolean value) {
        if (this.valueChangeListener != null) {
            this.valueChangeListener.onLockChanged(changedSetting, value);
        }
    }

    void fireChangeEvent(@NonNull ISetting changedSetting, @NonNull SettingValue value) {
        if (this.valueChangeListener != null) {
            this.valueChangeListener.onValueChanged(changedSetting, value);
        }
    }

    public void setValueChangeListener(@Nullable IValueChangeListener listener) {
        this.valueChangeListener = listener;
    }

    public boolean isBelowVisible(@NonNull GridItem item) {
        @NonNull GridItem[] visibles = this.getVisibleRange();
        if (visibles.length > 0) {
            IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
            return platformSpecific.getRowIndex(visibles[visibles.length - 1]) < platformSpecific.getRowIndex(item);
        }
        return false;
    }

    public boolean isAboveVisible(@NonNull GridItem item) {
        @NonNull GridItem[] visibles = this.getVisibleRange();
        if (visibles.length > 0) {
            IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
            return platformSpecific.getRowIndex(visibles[0]) > platformSpecific.getRowIndex(item);
        }
        return false;
    }

    private @NonNull GridItem @NonNull [] getVisibleRange() {
        ArrayList<GridItem> visibles = new ArrayList<GridItem>();
        GridItem[] gridItemArray = this.grid.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem item = gridItemArray[n2];
            if (item.getBounds((int)0).x >= 0) {
                visibles.add(item);
            }
            ++n2;
        }
        @NonNull GridItem @NonNull [] result = visibles.toArray(new GridItem[0]);
        return result;
    }

    public int getFirstVisibleTop() {
        GridItem[] visibleItems = this.getVisibleRange();
        if (visibleItems.length > 0) {
            GridItem lastVisible = visibleItems[0];
            Rectangle bounds = lastVisible.getBounds(0);
            return bounds.y;
        }
        return -1;
    }

    public int getLastVisibleBottom() {
        GridItem[] visibleItems = this.getVisibleRange();
        if (visibleItems.length > 0) {
            GridItem lastVisible = visibleItems[visibleItems.length - 1];
            Rectangle bounds = lastVisible.getBounds(0);
            return bounds.y + bounds.height;
        }
        return -1;
    }

    public boolean isVisible(@NonNull ISetting setting) {
        GridItem settingItem = this.getItem(setting);
        IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
        return settingItem == null ? false : platformSpecific.isVisible(settingItem);
    }

    public int getCenterY(@NonNull ISetting setting) {
        IPlatformSpecific platformSpecific = PlatformSpecificFactory.getPlatformSpecific();
        GridItem[] gridItemArray = this.grid.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISettingNode settingNode;
            GridItem item = gridItemArray[n2];
            Object data = item.getData();
            if (data instanceof ISettingNode && setting == (settingNode = (ISettingNode)data).getSetting()) {
                ISettingNode parent;
                GridItem itemToReturn = item;
                if (!platformSpecific.isVisible(item) && (parent = settingNode.getParent()) != null) {
                    itemToReturn = this.getItem(parent);
                }
                if (itemToReturn != null) {
                    Rectangle bounds = itemToReturn.getBounds(0);
                    if (bounds.y >= 0) {
                        return bounds.y + bounds.height / 2;
                    }
                    return this.isAboveVisible(item) ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                }
            }
            ++n2;
        }
        return -1;
    }

    @NonNull Shell getShell() {
        Shell gridShell = this.grid.getShell();
        assert (gridShell != null);
        return gridShell;
    }

    private @Nullable GridItem getItem(@NonNull ISettingNode settingNode) {
        GridItem[] gridItemArray = this.grid.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem item = gridItemArray[n2];
            Object data = item.getData();
            if (data == settingNode) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private @Nullable GridItem getItem(@NonNull ISetting setting) {
        GridItem[] gridItemArray = this.grid.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISettingNode settingNode;
            GridItem item = gridItemArray[n2];
            Object data = item.getData();
            if (data instanceof ISettingNode && setting == (settingNode = (ISettingNode)data).getSetting()) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public void setSelectedNodes(@NonNull Collection<@NonNull String> settingNodes) {
        ArrayList<ISettingNode> nodesToSelect = new ArrayList<ISettingNode>(settingNodes.size());
        GridItem[] gridItemArray = this.grid.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISettingNode settingNode;
            GridItem item = gridItemArray[n2];
            Object data = item.getData();
            if (data instanceof ISettingNode && settingNodes.contains((settingNode = (ISettingNode)data).getId())) {
                nodesToSelect.add(settingNode);
            }
            ++n2;
        }
        this.gridViewer.setSelection((ISelection)new StructuredSelection((Object[])nodesToSelect.toArray(new ISettingNode[0])));
        this.grid.showSelection();
    }

    public void addHighlight(@NonNull Collection<@NonNull String> nodes) {
        this.highlightedNodes.addAll(nodes);
    }

    public void addHighlight(@NonNull String nodes) {
        this.highlightedNodes.add(nodes);
    }

    public void removeHighlight(@NonNull String node) {
        this.highlightedNodes.remove(node);
    }

    public void clearHighlight() {
        this.highlightedNodes.clear();
    }

    void lockSynchronously(@NonNull ISetting setting, @NonNull IClocksConfig clocksConfig, boolean lock, boolean fireEvents, boolean coLockersOnly) {
        SettingEditorHelper.lockSynchronously(setting, clocksConfig, lock, fireEvents, coLockersOnly, this.valueChangeListener);
    }

    public static IValueChangeListener createValueChangeListenerWithRunnable(final IValueChangeListener listener, final Runnable runnable) {
        return new IValueChangeListener(){

            @Override
            public void onValueChanged(@NonNull ISetting setting, @NonNull SettingValue value) {
                if (listener != null) {
                    listener.onValueChanged(setting, value);
                }
                if (runnable != null) {
                    runnable.run();
                }
            }

            @Override
            public void onLockChanged(@NonNull ISetting setting, @NonNull Boolean value) {
                if (listener != null) {
                    listener.onLockChanged(setting, value);
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
    }

    public void setSortChangeListener(@Nullable ISortChangeListener sortChangeListener) {
        this.sortChangeListener = sortChangeListener;
    }

    public @Nullable ISortChangeListener getSortChangeListener() {
        return this.sortChangeListener;
    }

    void setColumnSorting(@NonNull GridColumn gridColumn, final int sortDirection) {
        if (sortDirection == 0) {
            this.gridViewer.setComparator(null);
        } else {
            this.gridViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof ISettingNode && e2 instanceof ISettingNode) {
                        ISettingNode node1 = (ISettingNode)e1;
                        ISettingNode node2 = (ISettingNode)e2;
                        if (SettingsTable.this.sortRoots || node1.getParent() != null && node2.getParent() != null) {
                            ISetting setting1 = node1.getSetting();
                            ISetting setting2 = node2.getSetting();
                            String name1 = setting1 == null ? node1.getId() : setting1.getName();
                            String name2 = setting2 == null ? node2.getId() : setting2.getName();
                            return (sortDirection == 1024 ? 1 : -1) * name1.compareTo(name2);
                        }
                    }
                    return 0;
                }
            });
        }
        gridColumn.setSort(sortDirection);
        this.gridViewer.refresh();
        if (this.sortChangeListener != null) {
            this.sortChangeListener.sortChanged();
        }
    }

    public void setNamesColumnSorting(int sortDirection) {
        GridColumn namesColumn = this.getGrid().getColumn(0);
        if (namesColumn != null) {
            this.setColumnSorting(namesColumn, sortDirection);
        } else {
            LOGGER.severe("Trying to access names grid column (index 0), but it doesn't exist.");
        }
    }

    public static class AdvancedResolverAction
    extends Action {
        @NonNull
        ISetting setting;
        @Nullable
        IValueChangeListener valueChangeListener;
        @Nullable
        Runnable runnable;

        public AdvancedResolverAction(@NonNull ISetting setting, @Nullable IValueChangeListener valueChangeListener, @Nullable Runnable runnable) {
            this.setting = setting;
            this.valueChangeListener = valueChangeListener;
            this.runnable = runnable;
        }

        public String getText() {
            String message = Messages.get().DiagramView_AdvancedResolver;
            return UtilsText.safeString((String)MessageFormat.format(message, this.setting.getElement().getName()));
        }

        public void run() {
            IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
            if (activeConfig != null) {
                IValueChangeListener listener = SettingsTable.createValueChangeListenerWithRunnable(this.valueChangeListener, this.runnable);
                SettingEditorHelper.tryEnableOutput(this.setting, activeConfig, listener, true);
            }
        }
    }

    public static class EnableOutputAction
    extends Action {
        @NonNull
        ISetting setting;
        @Nullable
        IValueChangeListener valueChangeListener;
        @Nullable
        Runnable runnable;

        public EnableOutputAction(@NonNull ISetting setting, @Nullable IValueChangeListener valueChangeListener, @Nullable Runnable runnable) {
            this.setting = setting;
            this.valueChangeListener = valueChangeListener;
            this.runnable = runnable;
        }

        public String getText() {
            String message = Messages.get().DiagramView_EnableOutput;
            return UtilsText.safeString((String)MessageFormat.format(message, this.setting.getElement().getName()));
        }

        public void run() {
            IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
            if (activeConfig != null) {
                IValueChangeListener listener = SettingsTable.createValueChangeListenerWithRunnable(this.valueChangeListener, this.runnable);
                SettingEditorHelper.tryEnableOutput(this.setting, activeConfig, listener, false);
            }
        }
    }

    public static class FindAction
    extends Action {
        @NonNull
        ISetting setting;
        @Nullable
        IValueChangeListener valueChangeListener;
        @Nullable
        Runnable runnable;
        @NonNull
        Shell shell;

        public FindAction(@NonNull ISetting setting, @Nullable IValueChangeListener valueChangeListener, @Nullable Runnable runnable, @NonNull Shell shell) {
            this.setting = setting;
            this.valueChangeListener = valueChangeListener;
            this.shell = shell;
            this.runnable = runnable;
        }

        public boolean isEnabled() {
            IClocksConfig config = GuiController.getInstance().getProfile().getActiveConfig();
            if (config != null) {
                SettingValue value = config.getSettingsConfig().getSettingValue(this.setting);
                return this.setting.isFindNearValueSupported() && !this.setting.isValid(value, config);
            }
            return false;
        }

        public String getText() {
            return Messages.get().SettingsEditorHelper_FindNearValue;
        }

        public void run() {
            IClocksConfig config = GuiController.getInstance().getProfile().getActiveConfig();
            if (config != null) {
                SettingEditorHelper.findNearValue(this.setting, config, this.valueChangeListener, this.shell);
                if (this.runnable != null) {
                    this.runnable.run();
                }
            }
        }
    }

    public static interface ISortChangeListener {
        public void sortChanged();
    }

    public static class LockUnlockAction
    extends Action {
        @NonNull
        ISetting setting;
        @Nullable
        IValueChangeListener valueChangeListener;
        @Nullable
        Runnable runnable;

        public LockUnlockAction(@NonNull ISetting setting, @Nullable IValueChangeListener valueChangeListener, @Nullable Runnable runnable) {
            this.setting = setting;
            this.valueChangeListener = valueChangeListener;
            this.runnable = runnable;
        }

        public boolean isEnabled() {
            IClocksConfig config = GuiController.getInstance().getProfile().getActiveConfig();
            if (config != null) {
                return this.setting.isUserLockable() && (config.isLocked(this.setting) || !config.getSettingsConfig().getSettingValue(this.setting).isN_A());
            }
            return false;
        }

        public String getText() {
            IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
            if (activeConfig != null) {
                return activeConfig.getSettingsConfig().isLocked(this.setting) ? Messages.get().SettingsTable_UnlockSetting : Messages.get().SettingsTable_LockSetting;
            }
            return "";
        }

        public ImageDescriptor getImageDescriptor() {
            IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
            if (activeConfig != null) {
                String imageId = activeConfig.getSettingsConfig().isLocked(this.setting) ? "icons/unlocked.png" : "icons/locked.png";
                return ToolsImages.getImageDescriptor((String)imageId);
            }
            return super.getImageDescriptor();
        }

        public void run() {
            IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
            if (activeConfig != null) {
                boolean lock = !activeConfig.getSettingsConfig().isLocked(this.setting);
                SettingEditorHelper.lockSetting(this.setting, activeConfig, lock, this.valueChangeListener);
                if (this.runnable != null) {
                    this.runnable.run();
                }
            }
        }
    }
}

