/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagramsymbols.BoundingBox;
import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.Rectangle;
import com.nxp.swtools.clocks.ui.diagramsymbols.TextField;
import com.nxp.swtools.clocks.ui.diagramsymbols.Wire;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DiagramLegend
extends Dialog {
    @Nullable
    protected Canvas mCanvas;
    private Composite mComposite;

    public DiagramLegend(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Canvas canvas = new Canvas(container, 0x20040000);
        GridData data = new GridData(4, 4, true, true);
        canvas.setLayoutData((Object)data);
        canvas.addPaintListener((PaintListener)new DrawListener());
        this.mCanvas = canvas;
        this.mComposite = container;
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().DiagramLegend_DialogTitle);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2148);
        this.setBlockOnOpen(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    protected void drawAll(@NonNull PaintEvent e) {
        double fontSize = 7.0;
        int margin = 15;
        int textHoffset = 50;
        int textVmargin = 9;
        int itemWidth = 30;
        int offset = 30;
        int itemHeight = 15;
        int pinScale = 6;
        AffineTransform itemTransform = new AffineTransform();
        AffineTransform descTransform = new AffineTransform();
        BoundingBox bb = new BoundingBox();
        descTransform.setToScale(fontSize, 1.0);
        TextField description = new TextField("", new Point2D.Double(0.0, 0.0), "");
        boolean initSuccessful = description.initialize();
        assert (initSuccessful);
        GraphicalElement elem = new Wire(new Point2D.Double(), new Point2D.Double(itemWidth, 0.0));
        DiagramStyleProvider styleProvider = new DiagramStyleProvider();
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_NormalWire));
        elem.update(DrawState.State.APPEARANCE_NORMAL);
        elem.update(DrawState.State.STATUS_FINE);
        itemTransform.translate(margin, margin);
        descTransform.translate((double)(textHoffset + margin) / fontSize, textVmargin);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_InactiveWire));
        elem.update(DrawState.State.APPEARANCE_INACTIVE);
        elem.update(DrawState.State.STATUS_FINE);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_SelectedWire));
        elem.update(DrawState.State.APPEARANCE_ACTIVE);
        elem.update(DrawState.State.STATUS_FINE);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_ErrorWire));
        elem.update(DrawState.State.APPEARANCE_NORMAL);
        elem.update(DrawState.State.STATUS_ERROR);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_DisabledWire));
        elem.update(DrawState.State.APPEARANCE_NORMAL);
        elem.update(DrawState.State.STATUS_DISABLED);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_UnavailableWire));
        elem.update(DrawState.State.APPEARANCE_INACTIVE);
        elem.update(DrawState.State.STATUS_UNAVAILABLE);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_SignalDirection));
        elem = new Pin((Point2D)new Point2D.Double(), new Point2D.Double(((double)itemWidth - 14.0) / (double)pinScale, 0.0), Pin.Direction.TO_RIGHT, Pin.Type.NORMAL, true);
        elem.update(DrawState.State.APPEARANCE_INACTIVE);
        elem.update(DrawState.State.STATUS_FINE);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        AffineTransform pinTransform = new AffineTransform(itemTransform);
        pinTransform.translate(7.0, 0.0);
        pinTransform.scale(pinScale, pinScale);
        elem.draw(pinTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_NormalElement));
        elem = new Rectangle(new Point2D.Double(), new Point2D.Double(itemWidth, itemHeight));
        elem.update(DrawState.State.APPEARANCE_NORMAL);
        elem.update(DrawState.State.STATUS_FINE);
        itemTransform.translate(0.0, 3 * offset / 4);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_ErrorElement));
        elem.update(DrawState.State.APPEARANCE_NORMAL);
        elem.update(DrawState.State.STATUS_ERROR);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_DisabledElement));
        elem.update(DrawState.State.APPEARANCE_NORMAL);
        elem.update(DrawState.State.STATUS_DISABLED);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_UnavailableElement));
        elem.update(DrawState.State.APPEARANCE_NORMAL);
        elem.update(DrawState.State.STATUS_UNAVAILABLE);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_SelectedElement));
        elem.update(DrawState.State.APPEARANCE_ACTIVE);
        elem.update(DrawState.State.STATUS_FINE);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        description.updateText(UtilsText.safeString((String)Messages.get().DiagramLegend_BoundaryElement));
        elem.update(DrawState.State.BOUNDARY_FLAG);
        itemTransform.translate(0.0, offset);
        descTransform.translate(0.0, offset);
        elem.draw(itemTransform, e, styleProvider);
        description.draw(descTransform, e, styleProvider);
        bb = bb.merge(elem.getBoundingBoxDS()).merge(description.getBoundingBoxDS());
        Point2D size = descTransform.transform(bb.getBottomRightCornerDS(), null);
        UIJobHelper.runNowOrInJob(() -> {
            if (this.mComposite == null || this.mComposite.isDisposed()) {
                return;
            }
            Shell shell = this.mComposite.getShell();
            shell.setSize(shell.computeSize((int)(size.getX() + (double)margin), (int)(size.getY() + (double)margin)));
        }, (String)"Diagram legend resize", null);
    }

    protected class DrawListener
    implements PaintListener {
        protected DrawListener() {
        }

        public void paintControl(PaintEvent e) {
            Canvas canvas = DiagramLegend.this.mCanvas;
            if (canvas != null && e != null) {
                Point size = canvas.getSize();
                Color bgColor = DiagramStyleProvider.getBgColor();
                org.eclipse.swt.graphics.Color swtColorOrig = e.gc.getBackground();
                e.gc.setBackground(bgColor.getSWTColor());
                e.gc.fillRectangle(0, 0, size.x, size.y);
                if (swtColorOrig != null && !swtColorOrig.isDisposed()) {
                    e.gc.setBackground(swtColorOrig);
                }
                e.gc.setAntialias(1);
                DiagramLegend.this.drawAll(e);
            }
        }
    }
}

