/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.script;

import com.nxp.swtools.clocks.script.ClocksRepresenter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.utils.scripting.ProfileInfo;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class YamlHelper {
    @NonNull
    public static final String YAML_BEGIN = "/* TEXT BELOW IS USED AS SETTING FOR THE CLOCKS TOOL *****************************";
    @NonNull
    public static final String YAML_END = " * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR THE CLOCKS TOOL **/";
    @NonNull
    private static final String PROFILE = "ClocksProfile";
    @NonNull
    private static final String CONFIG = "Configuration";

    private static @NonNull Yaml createYaml(boolean forceBlockStyle) {
        TypeDescription typeDescrProfile = new TypeDescription(ProfileInfo.class);
        typeDescrProfile.setTag(new Tag("tag:yaml.org,2002:ClocksProfile"));
        TypeDescription typeDescrConfig = new TypeDescription(StorageClocksConfiguration.class);
        typeDescrConfig.setTag(new Tag("tag:yaml.org,2002:Configuration"));
        ClocksConstructor constructor = new ClocksConstructor();
        constructor.getPropertyUtils().setSkipMissingProperties(true);
        constructor.addTypeDescription(typeDescrProfile);
        constructor.addTypeDescription(typeDescrConfig);
        ClocksRepresenter representer = new ClocksRepresenter();
        representer.addClassTag(ProfileInfo.class, new Tag("tag:yaml.org,2002:ClocksProfile"));
        representer.addClassTag(StorageClocksConfiguration.class, new Tag("tag:yaml.org,2002:Configuration"));
        representer.getPropertyUtils().setSkipMissingProperties(true);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        dumperOptions.setDefaultFlowStyle(forceBlockStyle ? DumperOptions.FlowStyle.BLOCK : DumperOptions.FlowStyle.AUTO);
        return new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions);
    }

    public static @NonNull String dump(@NonNull Object object) {
        return UtilsText.safeString((String)YamlHelper.createYaml(false).dump(object));
    }

    public static @NonNull String dump(@NonNull Object object, boolean forceBlockStyle) {
        return UtilsText.safeString((String)YamlHelper.createYaml(forceBlockStyle).dump(object));
    }

    public static @Nullable Object load(@NonNull String input) {
        return YamlHelper.createYaml(false).load(input);
    }

    static class ClocksConstructor
    extends Constructor {
        ClocksConstructor() {
        }

        protected Class<?> getClassForName(String name) throws ClassNotFoundException {
            return Class.forName(name, true, YamlHelper.class.getClassLoader());
        }
    }
}

