/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.dependencies;

import com.nxp.swtools.clocks.dependencies.ProblemResolveHelper;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemResolveHandler;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.text.MessageFormat;

public class FrequencyResolveHandler
implements IProblemResolveHandler {
    @Nullable
    private String freq;

    public FrequencyResolveHandler(@NonNull IValidationProblem problem) {
        this.freq = ProblemResolveHelper.parseFrequency(problem);
    }

    public boolean resolveProblem(@NonNull IBaseProblem problem) {
        if (!(problem instanceof IValidationProblem)) {
            return true;
        }
        IValidationProblem p = (IValidationProblem)problem;
        ProblemResolveHelper.setOutputFrequency(p);
        return true;
    }

    public @NonNull String getResolveProblemLabel(@NonNull IBaseProblem problem) {
        return MessageFormat.format(Messages.get().FrequencyResolveHandler_Label, this.freq);
    }
}

