/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.elements.DFSPrescaler;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.AFrequencyModifierSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.model.ICalculus;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.List;
import java.util.logging.Level;

@NonNullByDefault
public class DFSPrescalerSetting
extends AFrequencyModifierSetting {
    private static final String DIVIDE = "/";
    public static final String ID_SUFFIX = "scale";
    private DFSPrescaler prescaler;

    public DFSPrescalerSetting(DFSPrescaler prescaler) {
        super(prescaler);
        this.prescaler = prescaler;
    }

    @Override
    public @Nullable List<SettingValue> getValues(IClocksConfig clocksConfig) {
        return null;
    }

    @Override
    public @Nullable SettingValue parseUiValue(String uiValue, IClocksConfig clocksConfig) {
        String unPrefixedUiValue = DFSPrescalerSetting.getUnprefixedPart(uiValue);
        ValueMap activeValueMap = this.prescaler.getActiveValueMap(clocksConfig);
        if (activeValueMap != null) {
            Constraint constraint;
            Object value = activeValueMap.getControlValueByUiValue(unPrefixedUiValue);
            if (value != null) {
                BigRational parsedValue = BigRational.tryParse((String)unPrefixedUiValue);
                if (parsedValue != null) {
                    unPrefixedUiValue = parsedValue.toExactDecimalString(4);
                }
                return new SettingValue(UtilsText.safeToString((Object)value), "/ " + unPrefixedUiValue);
            }
            ICalculus calculus = activeValueMap.getCalculus();
            if (calculus != null && (constraint = (Constraint)calculus.getProblematicConstraint()) != null && constraint.isApplicable(clocksConfig)) {
                clocksConfig.addError(this.getId(), constraint.getDescription(), ClocksProblem.Type.SETTING);
                return new SettingValue(UtilsText.safeToString((Object)unPrefixedUiValue), "/ " + unPrefixedUiValue);
            }
        }
        return null;
    }

    private static String getUnprefixedPart(String uiValue) {
        String trimmedScalePrefix = DIVIDE;
        String trimmedUiValue = uiValue.trim();
        String unPrefixedUiValue = trimmedUiValue.startsWith(trimmedScalePrefix) ? trimmedUiValue.substring(trimmedScalePrefix.length()).trim() : trimmedUiValue;
        assert (unPrefixedUiValue != null);
        return unPrefixedUiValue;
    }

    @Override
    public @Nullable SettingValue findNearestUiValue(String uiValue, IClocksConfig clocksConfig) {
        return null;
    }

    @Override
    public @Nullable SettingValue parseValue(Object value, IClocksConfig clocksConfig) {
        String uiValue;
        ValueMap activeValueMap = this.prescaler.getActiveValueMap(clocksConfig);
        if (activeValueMap != null && (uiValue = activeValueMap.getUiValueByControlValue(UtilsText.safeToString((Object)value))) != null) {
            return new SettingValue(UtilsText.safeToString((Object)value), "/ " + BigRational.parse((String)uiValue).toExactDecimalString(4));
        }
        LOGGER.warning(value + " of setting: " + this.getId() + " was not parsed properly.");
        return new SettingValue(UtilsText.safeToString((Object)value), "/ " + UtilsText.safeToString((Object)value));
    }

    @Override
    public boolean isValid(SettingValue settingValue, IClocksConfig clocksConfig) {
        return this.isElementValid(clocksConfig);
    }

    @Override
    public @Nullable SettingValue getDefaultValue(IClocksConfig clockConfig) {
        ValueMap activeValueMap = this.prescaler.getActiveValueMap(clockConfig);
        if (activeValueMap != null) {
            String defaultScale = activeValueMap.getDefaultUiValue();
            String uiValue = "/ " + defaultScale;
            return this.parseUiValue(uiValue, clockConfig);
        }
        return null;
    }

    public DFSPrescaler getPrescaler() {
        return this.prescaler;
    }

    @Override
    protected String getIdSuffix() {
        return ID_SUFFIX;
    }

    @Override
    public String toString(SettingValue settingValue) {
        return UtilsText.safeString((String)settingValue.getValue().toString());
    }

    @Override
    public @Nullable SettingValue fromString(String string, IClocksConfig clocksConfig) {
        try {
            BigRational rationalValue = BigRational.tryParse((String)string);
            if (rationalValue == null) {
                rationalValue = new BigRational(string);
            }
            return this.parseValue(rationalValue.toExactDecimalString(), clocksConfig);
        }
        catch (NumberFormatException exception) {
            LOGGER.log(Level.WARNING, "Could not parse value: " + string + " of setting: " + this.getId(), exception);
            return SettingValue.N_A;
        }
    }

    @Override
    public boolean isComboSuppressionAllowed() {
        return true;
    }

    @Override
    public @Nullable Range getRangeOfValues(IClocksConfig config) {
        return null;
    }

    @Override
    public @Nullable String getAllowedValueDescription(IClocksConfig clocksConfig) {
        return "";
    }

    @Override
    public boolean isPrioritized() {
        return this.prescaler.isPrioritized();
    }
}

