/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;

public class ClockOutputSetting
extends OutputFrequencySetting {
    @NonNull
    private ClockOutput output;

    public ClockOutputSetting(@NonNull ClockOutput output) {
        super(output);
        this.visible = true;
        this.editable = true;
        this.editableByDefault = true;
        this.output = output;
    }

    public @NonNull ClockOutput getClockOutput() {
        return this.output;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public @NonNull String getGroup() {
        return this.output.getGroup();
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return this.output.isValid(clocksConfig);
    }

    @Override
    public boolean isUserLockable() {
        return true;
    }

    @Override
    public boolean isLockedByDefault() {
        return false;
    }

    @Override
    public boolean isFindNearValueSupported() {
        return true;
    }

    @Override
    public boolean shouldBeSaved(@NonNull IClocksConfig currentConfig) {
        return this.isLockDifferent(currentConfig, currentConfig.getMcu().getDefaultConfig()) || !currentConfig.getSettingsConfig().getSettingValue(this).isN_A();
    }

    @Override
    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        Object object;
        SettingValue value = super.parseUiValue(uiValue, clocksConfig);
        if (value != null && (object = value.getValue()) instanceof Frequency && ((Frequency)object).compareTo(Frequency.ZERO) <= 0) {
            return null;
        }
        return value;
    }
}

