/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ComponentOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.ClocksConfig;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class OutputEnabler {
    public static final int PROBLEM_LEVEL_ERROR = 2;
    private static final int PROGRESS_BAR = 1000;
    private ClockOutput clockOutput;
    private ClocksConfig clocksConfig;
    private ClocksConfig clocksConfigClone;
    private Collection<ClocksProblem> problems;
    private Map<ISetting, @Nullable SettingValue> changedSettings = new HashMap<ISetting, SettingValue>();
    private boolean isCancellable;

    public OutputEnabler(ClockOutput clockOutput, ClocksConfig clocksConfig) {
        this.clockOutput = clockOutput;
        this.clocksConfig = clocksConfig;
        this.clocksConfigClone = clocksConfig.clone(clocksConfig.getClocksModel());
        this.problems = new ArrayList<ClocksProblem>(clocksConfig.getProblems());
        this.isCancellable = true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean enableOutput(Display display, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        SubMonitor phase1 = subMonitor.split(500).setWorkRemaining(1000);
        if (phase1 != null && this.enableElementsOnPath(this.clocksConfigClone, null, phase1) && !this.containsErrors(this.clocksConfigClone) && !this.isErrorInOutput(this.clocksConfigClone)) {
            SubMonitor phase2 = subMonitor.split(500).setWorkRemaining(1000);
            this.isCancellable = false;
            if (phase2 != null) {
                this.enableElementsOnPath(this.clocksConfig, null, phase2);
                IClocksProfile profile = this.clocksConfig.getProfile();
                if (profile != null) {
                    display.asyncExec(() -> profile.regenerateCode());
                }
                if (!this.clocksConfig.getSettingsConfig().getLastlyChanged().isEmpty()) {
                    @Nullable Map.Entry entry = (Map.Entry)CollectionsUtils.last(this.clocksConfig.getSettingsConfig().getLastlyChanged().entrySet());
                    UiController.getInstance().setLastlyChangedSetting(((ISetting)entry.getKey()).getElement().getID());
                }
                this.changedSettings.forEach((k, v) -> this.clocksConfig.getSettingsConfig().addLastlyChangedSetting((ISetting)k, (SettingValue)v));
                return true;
            }
        }
        subMonitor.done();
        return false;
    }

    private boolean enableElementsOnPath(ClocksConfig config, @Nullable IClockElement clockElement, SubMonitor subMonitor) {
        List<IClockElement> elementsOnPath = config.getPathToOutput(this.clockOutput.getID());
        int progressBarPart = 1000 / elementsOnPath.size();
        if (clockElement != null) {
            int index = elementsOnPath.indexOf(clockElement);
            progressBarPart = index == -1 ? 0 : 1000 / (index + 1);
        }
        for (IClockElement element : elementsOnPath) {
            SubMonitor recursiveMonitor;
            OutputEnabler.recordProgress(element, config, subMonitor, progressBarPart);
            if (subMonitor.isCanceled() && this.isCancellable) {
                return false;
            }
            if (element.equals(clockElement)) {
                if (element.isDisabled(config)) {
                    this.enableClockElement(this.clockOutput, config);
                }
                subMonitor.done();
                return element.isEnabled(config);
            }
            if (element.isDisabled(config) && this.clockOutput.isDisabled(config)) {
                this.enableClockElement(element, config);
                if (element.isDisabled(config) && !(element instanceof ComponentOutput)) {
                    this.enableDependencies(element, config);
                }
            }
            if (!(element instanceof ClockSelect) || !element.isDisabled(config) && !this.isErrorInOutput(config) || (recursiveMonitor = subMonitor.split(progressBarPart)) == null) continue;
            this.enableClockSelector((ClockSelect)element, config, recursiveMonitor);
        }
        subMonitor.done();
        if (clockElement != null) {
            return clockElement.isEnabled(config);
        }
        return this.clockOutput.isEnabled(config);
    }

    private boolean enableClockElement(IClockElement element, ClocksConfig config) {
        if (element.isDisabled(config)) {
            List<ISetting> settings = element.getSettings(SettingType.LOCAL_CONFIG_ELEMENT);
            for (ISetting setting : settings) {
                ClocksConfig configClone = config.clone(config.getClocksModel());
                this.invertSettingValue(setting, configClone);
                if (!element.isEnabled(configClone)) continue;
                this.invertSettingValue(setting, config);
                return true;
            }
        }
        return false;
    }

    private boolean enableClockSelector(ClockSelect clockSelect, ClocksConfig config, SubMonitor subMonitor) {
        ISetting setting = clockSelect.getSetting(SettingType.FREQUENCY_MODIFIER);
        if (setting != null) {
            List<SettingValue> settingValues = OutputEnabler.getSortedSelectorValue(clockSelect, config);
            SubMonitor recurseMonitor = SubMonitor.convert((IProgressMonitor)subMonitor, (int)1000);
            int progressBarPart = 1000 / (settingValues.size() + 1);
            recurseMonitor.setWorkRemaining(1000);
            for (SettingValue settingValue : settingValues) {
                ClocksConfig configClone = config.clone(config.getClocksModel());
                configClone.setSettingValue(setting, settingValue, true, true);
                if (this.enableElementsOnPath(configClone, clockSelect, recurseMonitor) && !this.containsErrors(configClone) && !this.isErrorInOutput(configClone)) {
                    if (config.equals(this.clocksConfig)) {
                        this.addChangedSetting(config, setting, settingValue);
                    }
                    config.setSettingValue(setting, settingValue, true, true);
                    this.enableElementsOnPath(config, clockSelect, recurseMonitor);
                    recurseMonitor.done();
                    return true;
                }
                recurseMonitor.worked(progressBarPart);
            }
            recurseMonitor.done();
        }
        return false;
    }

    private static List<SettingValue> getSortedSelectorValue(ClockSelect clockSelect, ClocksConfig config) {
        ArrayList<SettingValue> settingsValues = new ArrayList<SettingValue>();
        ISetting setting = clockSelect.getSetting(SettingType.FREQUENCY_MODIFIER);
        if (setting != null) {
            Collection<IClockElement> predecessors = clockSelect.getPredecessors();
            for (IClockElement predecessor : predecessors) {
                SettingValue settingValue = setting.parseValue(predecessor.getID(), config);
                if (settingValue == null) continue;
                if (predecessor.isEnabled(config)) {
                    settingsValues.add(0, settingValue);
                    continue;
                }
                settingsValues.add(settingValue);
            }
        }
        return settingsValues;
    }

    private void enableDependencies(IClockElement element, ClocksConfig config) {
        Set<ISetting> dependedSettings = OutputEnabler.getDependedSettings(element, config);
        for (ISetting setting : dependedSettings) {
            this.invertSettingValue(setting, config);
        }
    }

    private static Set<ISetting> getDependedSettings(IClockElement element, ClocksConfig config) {
        IMcu mcu;
        Set<String> controlSettings;
        HashSet<ISetting> dependedSettings = new HashSet<ISetting>();
        EnableSetting enableSetting = element.getEnableSetting();
        if (enableSetting != null && (controlSettings = (mcu = config.getMcu()).getControlSettings(enableSetting.getId())) != null) {
            for (String controlSettingId : controlSettings) {
                ISetting controlSetting = SettingProvider.getSettingById(controlSettingId, mcu);
                if (controlSetting == null || controlSetting.getType() != SettingType.LOCAL_CONFIG_ELEMENT) continue;
                dependedSettings.add(controlSetting);
            }
        }
        return dependedSettings;
    }

    private boolean invertSettingValue(ISetting setting, ClocksConfig config) {
        SettingValue originalValue = config.getSettingsConfig().getSettingValue(setting);
        List<SettingValue> settingValues = setting.getValues(config);
        if (settingValues != null) {
            for (SettingValue settingValue : settingValues) {
                if (originalValue.getValue().equals(settingValue.getValue())) continue;
                if (config.equals(this.clocksConfig)) {
                    this.addChangedSetting(config, setting, settingValue);
                }
                config.setSettingValue(setting, settingValue, true, false);
                return true;
            }
        }
        return false;
    }

    private boolean containsErrors(ClocksConfig config) {
        for (ClocksProblem problem : config.getProblems()) {
            if (problem.getProblemLevel() < 2) continue;
            boolean contains = true;
            for (ClocksProblem originProblem : this.problems) {
                if (originProblem.getProblemLevel() < 2 || !originProblem.getResource().equals(problem.getResource())) continue;
                contains = false;
            }
            if (!contains) continue;
            return true;
        }
        return false;
    }

    private boolean isErrorInOutput(ClocksConfig config) {
        return !config.getProblemsOfElement(this.clockOutput.getID(), 2).isEmpty();
    }

    private static void recordProgress(IClockElement element, ClocksConfig config, SubMonitor subMonitor, int work) {
        if (element instanceof ClockSelect) {
            if (element.isEnabled(config)) {
                subMonitor.worked(work);
            }
        } else {
            subMonitor.worked(work);
        }
    }

    private void addChangedSetting(IClocksConfig config, ISetting setting, SettingValue settingValue) {
        this.changedSettings.put(setting, config.getSettingsConfig().getSettingValue(setting));
        Map<ISetting, SettingValue> bitfields = setting.getBitFieldsToWrite(config, settingValue);
        bitfields.forEach((k, v) -> {
            SettingValue settingValue = this.changedSettings.put((ISetting)k, (SettingValue)v);
        });
    }
}

