/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.elements.PowerModeSpecificElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ClockFixed;
import com.nxp.swtools.clocks.model.ClockListFixed;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ClockSource
extends AClockElement {
    @Nullable
    private Frequency defaultInputFrequency;
    private boolean internal;
    private boolean connectedByDefault;
    private boolean trimmable;
    @NonNull
    private @NonNull List<@NonNull Frequency> frequencies;
    @NonNull
    private @NonNull List<@NonNull Pin> pins;

    public ClockSource(@NonNull ClockElementData elementData, boolean internal, boolean trimmable, @NonNull List<@NonNull Frequency> frequencies, @Nullable String defaultFrequency, boolean connectedBydefault, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull List<@NonNull Pin> pins) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), elementData.getConstraints(), elementData.getConfigElements(), elementData.isPrioritized());
        this.frequencies = frequencies;
        this.internal = internal;
        this.trimmable = trimmable;
        this.addNestedSetting(new EnableSetting(this.id, (IElement)this, elementData.getEnableDisableConditions()));
        if (defaultFrequency != null) {
            Frequency defaultFreq = Frequency.parse((String)defaultFrequency);
            if (defaultFreq == null) {
                LOGGER.warning("Default frequency: " + defaultFrequency + " can not be parsed");
            }
            this.defaultInputFrequency = defaultFreq;
        }
        this.modelDevice = new ClockSourceModel(this.id, this.getModelType(), this.defaultInputFrequency, new ArrayList<BigRational>());
        this.values = values;
        this.pins = pins;
        super.setPowerModeSpecific(elementData.isPowerModeSpecific);
        this.connectedByDefault = !internal && connectedBydefault;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isConnectedByDefault() {
        if (this.connectedByDefault && this.defaultInputFrequency == null) {
            LOGGER.severe("External clocks source " + this.id + "is connected by default by no default frequency provided!");
        }
        return this.connectedByDefault;
    }

    public boolean isTrimmable() {
        return this.trimmable;
    }

    public @Nullable Frequency getDefaultInput() {
        return this.defaultInputFrequency;
    }

    public @NonNull List<@NonNull Frequency> getFrequencies() {
        return this.frequencies;
    }

    @Override
    public String getType() {
        return ElementType.CLOCK_SOURCE.toString();
    }

    public @NonNull ENodeType getModelType() {
        if (this.isFixed()) {
            return ENodeType.ClockFixed;
        }
        return ENodeType.Clock;
    }

    public boolean isFixed() {
        return !this.trimmable && this.frequencies.size() == 1;
    }

    @Override
    protected @NonNull ISetting createOutputFrequencySetting() {
        return new ClockSourceSetting(this);
    }

    @Override
    public @Nullable Frequency getOutputFrequency(@NonNull IClocksConfig config) {
        BigRational freq;
        Node compNode = this.getComputationNode(config);
        if (compNode != null && (freq = compNode.getFrequency()) != null) {
            return new Frequency(freq, FrequencyUnit.HERTZ);
        }
        return null;
    }

    @Override
    protected @NonNull PowerModeSpecificElement createPowerModeSpecific() {
        return new PowerModeSpecificElement(() -> new ClockSourceSetting(this), () -> this.configElements);
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        SettingsConfig settingsConfig = config.getSettingsConfig();
        ISetting outputSetting = this.getOutputFrequencySetting();
        SettingValue value = settingsConfig.getSettingValue(outputSetting);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            LockState lockState = settingsConfig.getLockState(outputSetting);
            if (lockedOnly && lockState == null || value.isN_A() && (lockState == null || lockState.getValue().isN_A())) {
                compNode.clean();
                compNode.disable();
            } else {
                Object valueObject;
                Object object = valueObject = !value.isN_A() || lockState == null ? value.getValue() : lockState.getValue().getValue();
                if (valueObject instanceof Frequency) {
                    Frequency freq = (Frequency)valueObject;
                    BigRational rationalFreq = Converter.toHertz(freq);
                    if (!(compNode instanceof ClockFixed) && !(compNode instanceof ClockListFixed)) {
                        compNode.setOutputFrequency(rationalFreq);
                    } else if (!rationalFreq.equals((Object)compNode.getFrequency())) {
                        LOGGER.warning("Can not change frequency of a fixed clock source: " + this.getID());
                    }
                } else {
                    LOGGER.warning("Frequency expected, but got: " + valueObject + ": " + valueObject.getClass().getSimpleName());
                }
            }
        }
    }

    @Override
    protected void loadFromModel(@NonNull IClocksConfig config) {
    }

    @Override
    public @Nullable ISetting getMainSetting() {
        return this.getOutputFrequencySetting();
    }

    public @NonNull List<@NonNull Pin> getPins() {
        return this.pins;
    }

    private static class ClockSourceModel
    extends AClockModelCreationElement {
        @Nullable
        private BigRational defaultFreq;
        @NonNull
        private ArrayList<BigRational> allFrequencies;

        public ClockSourceModel(@NonNull String id, @NonNull ENodeType type, @Nullable Frequency defaultFreq, @NonNull ArrayList<BigRational> frequencies) {
            super(id, type);
            if (defaultFreq != null) {
                try {
                    this.defaultFreq = Converter.toHertz(defaultFreq);
                }
                catch (ArithmeticException e) {
                    LOGGER.log(Level.SEVERE, "Error while initializing " + id + " of type " + type + " to following frequency: '" + defaultFreq + "'.", e);
                }
            } else {
                this.defaultFreq = null;
            }
            this.allFrequencies = frequencies;
        }

        @Override
        public List<BigRational> getListClockFreq() {
            return this.allFrequencies;
        }

        @Override
        public BigRational getDefaultClockFreq() {
            return this.defaultFreq;
        }

        @Override
        public BigRational getClockFrequency() {
            assert (this.defaultFreq != null);
            return this.defaultFreq;
        }

        @Override
        public String getPredecessor() {
            return "#root#";
        }
    }
}

