/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.common.utils.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LongValues {
    @NonNull
    public static final LongValues EMPTY = new LongValues(new Long[0]);
    @NonNull
    private @NonNull Long @NonNull [] values;

    public static @NonNull LongValues fromConfig(@NonNull IClocksConfig config, @NonNull BitFieldElement @NonNull [] bitFields) {
        @NonNull Long[] bitFieldValues = new Long[bitFields.length];
        int i = 0;
        while (i < bitFields.length) {
            Long value = ClocksBitFieldProvider.getBitFieldValueOrResetValue(bitFields[i], config).getValue();
            assert (value != null);
            bitFieldValues[i] = value;
            ++i;
        }
        return new LongValues(bitFieldValues);
    }

    public LongValues(@NonNull Long @NonNull [] values) {
        this.values = values;
    }

    public LongValues(@NonNull Long value) {
        this.values = new Long[1];
        this.values[0] = value;
    }

    public LongValues(long value) {
        this.values = new Long[1];
        Long longVal = value;
        assert (longVal != null);
        this.values[0] = longVal;
    }

    public @NonNull Long getValue(int position) {
        return this.values[position];
    }

    public int getLength() {
        return this.values.length;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongValues other = (LongValues)obj;
        return Arrays.equals((Object[])this.values, (Object[])other.values);
    }

    public String toString() {
        return Arrays.toString((Object[])this.values);
    }

    public static class Builder {
        @NonNull
        private @NonNull List<@NonNull Long> values = new ArrayList<Long>();

        public @NonNull Builder addValue(@NonNull Long value) {
            this.values.add(value);
            return this;
        }

        public @NonNull LongValues build() {
            @NonNull Long[] array = new Long[this.values.size()];
            array = this.values.toArray(array);
            assert (array != null);
            return new LongValues(array);
        }
    }
}

