/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.s32debugger.launch.checkers;

import com.nxp.s32ds.cle.debug.s32debugger.S32DebuggerActivator;
import com.nxp.s32ds.cle.debug.s32debugger.launch.markers.S32DebuggerFlashCapableLaunchConfigurationMarker;
import com.nxp.s32ds.ext.cdt.checkers.core.CdtLaunchConfigurationAbstractChecker;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class S32DebuggerFlashCompatibilityLaunchChecker
extends CdtLaunchConfigurationAbstractChecker
implements IResourceChecker {
    public static final String ATTR_BINARIES_LIST = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.projectBinariesList";
    public static final String ATTR_BINARIES_ENABLED_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binariesEnabledMap";
    public static final String ATTR_BINARIES_TO_BASE_ADDRESS_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryToBaseAddressMap";
    public static final String ATTR_BINARIES_TO_PROJECT_NAME_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryToProjectNameMap";
    private static final List<String> deprecatedAttributes = new ArrayList<String>();

    static {
        deprecatedAttributes.add(ATTR_BINARIES_LIST);
        deprecatedAttributes.add(ATTR_BINARIES_ENABLED_MAP);
        deprecatedAttributes.add(ATTR_BINARIES_TO_BASE_ADDRESS_MAP);
        deprecatedAttributes.add(ATTR_BINARIES_TO_PROJECT_NAME_MAP);
    }

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        return this.checkLaunchConfigurationFiles(resource);
    }

    protected IStatus check(List<IFile> listLaunchFiles, IProject project) {
        MultiStatus ms = new MultiStatus(S32DebuggerActivator.getInstance().getBundleId(), 0, "", null);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        for (IFile launchFile : listLaunchFiles) {
            if (!launchFile.exists()) continue;
            ILaunchConfiguration launchConfiguration = launchManager.getLaunchConfiguration(launchFile);
            try {
                String lcType = launchConfiguration.getType().getIdentifier();
                if (!"com.nxp.s32ds.debug.ide.s32debugger.flash.core.s32DebuggerFlashProgrammerLaunchConfigurationType".equals(lcType) || !S32DebuggerFlashCompatibilityLaunchChecker.hasDeprecatedLaunchAttributes(launchConfiguration, project.getName()) || S32DebuggerFlashCapableLaunchConfigurationMarker.containsMarker((IResource)launchFile)) continue;
                ms.add(S32DebuggerFlashCapableLaunchConfigurationMarker.createMarker((IResource)launchFile, project));
            }
            catch (CoreException ce) {
                S32DebuggerActivator.getInstance().log(ce.getStatus());
            }
        }
        return ms;
    }

    private static boolean hasDeprecatedLaunchAttributes(ILaunchConfiguration launchConfiguration, String validValue) throws CoreException {
        for (String attributeName : deprecatedAttributes) {
            if (!launchConfiguration.hasAttribute(attributeName)) continue;
            return true;
        }
        return false;
    }
}

