/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.ImageSegment;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="reserved_space", strict=false)
public class ReservedSpaceSetting
extends ABaseComponentSetting {
    private static final Logger LOGGER = LogManager.getLogger(ReservedSpaceSetting.class);
    @Attribute(name="offset")
    private String offset;
    @Attribute(name="size")
    private String size;
    @Attribute(name="include", empty="true", required=false)
    private String include;
    private ImageSegment imageSegment;
    @Attribute(name="exclude_custom_fields", required=false)
    private boolean excludeCustomFields = true;

    public ReservedSpaceSetting(String id, String label, @Nullable Description description, String offset, String size, String options, @Nullable MessagesSetting messages, String include) {
        super(id, label, description, "", options, messages, -1L, "");
        this.offset = offset;
        this.size = size;
        this.include = include;
        this.imageSegment = new ImageSegment(this.getId(), this.getOffsetValue(), this.getSizeValue(), ByteBuffer.allocate(this.getSizeValue()));
    }

    public ReservedSpaceSetting() {
        this.offset = "";
        this.size = "";
        this.include = Boolean.TRUE.toString();
        this.imageSegment = new ImageSegment(this.getId(), this.getOffsetValue(), this.getSizeValue(), ByteBuffer.allocate(this.getSizeValue()));
    }

    public boolean shouldBeIncluded() {
        return this.include.equals(Boolean.TRUE.toString());
    }

    public String getInclude() {
        return this.include;
    }

    public void setIncludeValue(boolean include) {
        this.include = include ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    public int getOffsetValue() {
        int offsetVal = 0;
        offsetVal = NumberFormatValidator.isValidXmlHexFormat((String)this.offset) ? NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.offset) : NumberFormatValidator.getIntFromStringDecimal((String)this.offset);
        return offsetVal;
    }

    public int getSizeValue() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.size);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
                return 0;
            }
        }
        return sizeVal;
    }

    public ImageSegment getImageSegment() {
        return this.imageSegment;
    }

    public void setImageSegment(ImageSegment imageSegment) {
        this.imageSegment = imageSegment;
    }

    public boolean excludeCustomFields() {
        return this.excludeCustomFields;
    }
}

