/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="img_length", strict=false)
public class ImageLengthSetting
extends ABaseComponentSetting {
    private static final Logger LOGGER = LogManager.getLogger(ImageLengthSetting.class);
    @Attribute(name="size")
    private String size;
    @Attribute(name="offset")
    private String offset;
    @Attribute(name="max_length", required=false)
    private String maxLength;
    @Attribute(name="reserved_space", required=false)
    private String reservedSpace;
    @Attribute(name="include_reserved_space", required=false)
    private boolean includeReservedSpace;

    public ImageLengthSetting(String id, String label, @Nullable Description description, String size, String value, String offset, String maxLength, String reservedSpace, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, value, options, messages, -1L, "");
        this.size = size;
        this.offset = offset;
        this.maxLength = maxLength;
        this.reservedSpace = reservedSpace;
        this.includeReservedSpace = false;
    }

    public ImageLengthSetting() {
        this.size = "";
        this.offset = "";
        this.maxLength = "";
        this.reservedSpace = "";
        this.includeReservedSpace = false;
    }

    public int getSizeValue() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.size);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
                return 0;
            }
        }
        return sizeVal;
    }

    public int getOffsetValue() {
        int offsetVal = 0;
        if (NumberFormatValidator.isValidDecimal((String)this.offset)) {
            offsetVal = NumberFormatValidator.getIntFromStringDecimal((String)this.offset);
        } else if (NumberFormatValidator.isValidXmlHexFormat((String)this.offset)) {
            offsetVal = NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.offset);
        }
        return offsetVal;
    }

    public int getImageLengthValue() {
        int imageLenVal = 0;
        if (!this.getInitValue().isEmpty()) {
            if (NumberFormatValidator.isValidXmlHexFormat((String)this.getInitValue())) {
                imageLenVal = NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.getInitValue());
            } else if (NumberFormatValidator.isValidDecimal((String)this.getInitValue())) {
                imageLenVal = NumberFormatValidator.getIntFromStringDecimal((String)this.getInitValue());
            }
        } else {
            imageLenVal = (int)this.getValueToWrite();
        }
        return imageLenVal;
    }

    public String getMaxLength() {
        return this.maxLength;
    }

    public int getMaxLengthValue() {
        int maxLengthVal = 0;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.maxLength)) {
            maxLengthVal = NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.maxLength);
        } else if (NumberFormatValidator.isValidDecimal((String)this.maxLength)) {
            maxLengthVal = NumberFormatValidator.getIntFromStringDecimal((String)this.maxLength);
        }
        return maxLengthVal;
    }

    public String getReservedSpace() {
        return this.reservedSpace;
    }

    public int getReservedSpaceValue() {
        int reservedSpaceVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.reservedSpace);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
                return 0;
            }
        }
        return reservedSpaceVal;
    }

    public boolean includeReservedSpace() {
        return this.includeReservedSpace;
    }

    public byte[] getBufferToWrite() {
        ByteBuffer bufferToWrite = ByteBuffer.allocate(this.getSizeValue());
        ByteBuffer imgLengthBuffer = ByteBuffer.allocate(8).putLong(this.getImageLengthValue());
        if (this.getSizeValue() > 8) {
            int i = 0;
            while (i < 8) {
                bufferToWrite.put(this.getSizeValue() - 1 - i, imgLengthBuffer.get(7 - i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.getSizeValue()) {
                bufferToWrite.put(this.getSizeValue() - 1 - i, imgLengthBuffer.get(7 - i));
                ++i;
            }
        }
        return bufferToWrite.array();
    }
}

