/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.data.Def;
import com.nxp.swtools.periphs.model.data.Import;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="fragment_defs", strict=false)
public class FragmentDefs {
    private static final Logger LOGGER = LogManager.getLogger(FragmentDefs.class);
    private LinkedHashMap<String, Def> defs;
    @Element(name="import", required=false)
    @Nullable
    private @Element(name="import", required=false) @Nullable Import import_;

    @ElementList(type=Def.class, required=false, inline=true)
    private @ElementList(type=Def.class, required=false, inline=true) List<Def> getDefsList() {
        return CollectionsUtils.listFromMapValues(this.defs);
    }

    @ElementList(type=Def.class, required=false, inline=true)
    private void setDefsList(List<Def> newDefs) {
        newDefs.stream().forEachOrdered(def -> this.addDef((Def)def));
    }

    public FragmentDefs() {
        this.import_ = null;
        this.defs = new LinkedHashMap();
    }

    public FragmentDefs(FragmentDefs original) {
        Import importOriginal = original.getImport();
        this.import_ = importOriginal != null ? new Import(importOriginal) : null;
        this.defs = new LinkedHashMap<String, Def>(original.getDefs());
    }

    public LinkedHashMap<String, Def> getDefs() {
        return this.defs;
    }

    public @Nullable Import getImport() {
        return this.import_;
    }

    public void addDef(Def def) {
        if (this.defs.put(def.getId(), def) != null) {
            LOGGER.severe(MessageFormat.format("[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.", def.getId(), this));
        }
    }

    public void setDefs(LinkedHashMap<String, Def> defs) {
        this.defs = defs;
    }

    public @Nullable Def getDef(String fragment) {
        return this.defs.get(fragment);
    }

    public void setImport(Import imp) {
        this.import_ = imp;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [import=" + this.import_ + "defs=(fst " + 3 + ")=" + CollectionsUtils.firstN(this.defs.values(), (int)3) + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.import_);
        result = 31 * result + this.defs.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FragmentDefs other = (FragmentDefs)obj;
        if (!Objects.equals(this.import_, other.import_)) {
            return false;
        }
        return this.defs.equals(other.defs);
    }
}

