/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.ComponentInfo;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentsProvider {
    public static final String COMPONENT_EXTENSION = "component";
    private static final Logger LOGGER = LogManager.getLogger(ComponentsProvider.class);

    private ComponentsProvider() {
    }

    public static Collection<ComponentInfo> getComponentsInfo(String componentsDir, String sdkVersion) {
        ArrayList<ComponentInfo> configurationComponentTypeIds = new ArrayList<ComponentInfo>();
        List components = UtilsFile.findFilesByExtension((String)componentsDir, (String)COMPONENT_EXTENSION, (int)2);
        for (String file : components) {
            File componentFile = new File(file);
            File fullNameFolder = new File(file).getParentFile();
            if (fullNameFolder == null) {
                LOGGER.severe(MessageFormat.format("[TOOL] Can't find full folder name for component: ", componentFile.getAbsolutePath()));
                continue;
            }
            ComponentInfo info = new ComponentInfo(UtilsText.safeString((String)fullNameFolder.getName()), sdkVersion, fullNameFolder);
            Path path = componentFile.toPath();
            assert (path != null);
            configurationComponentTypeIds.add(info);
        }
        return new ArrayList<ComponentInfo>(configurationComponentTypeIds);
    }

    public static Collection<ConfigurationComponentTypeId> getComponents(Collection<ComponentInfo> componentsInfo) {
        ArrayList<ConfigurationComponentTypeId> result = new ArrayList<ConfigurationComponentTypeId>();
        for (ComponentInfo info : componentsInfo) {
            try {
                ConfigurationComponentTypeId component = ComponentsProvider.loadComponent(info);
                if (component == null) continue;
                result.add(component);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] [{0}] Coomponent cannot be loaded due to following exception: {1}", info.getComponentDir(), e.getLocalizedMessage()));
            }
        }
        return result;
    }

    private static @Nullable ConfigurationComponentTypeId loadComponent(ComponentInfo info) {
        ConfigurationComponentTypeId result = null;
        Collection componentFiles = UtilsFile.getAllFilesInDir((File)info.getComponentDir(), (boolean)false, (String)COMPONENT_EXTENSION);
        if (componentFiles.isEmpty()) {
            LOGGER.severe("[DATA] No component file found in folder: " + info.getComponentDir());
        } else {
            File componentFile;
            ConfigurationComponent component;
            if (componentFiles.size() > 1) {
                LOGGER.warning("[DATA] More component files found in folder: " + info.getComponentDir() + ", loading only first of them");
            }
            if ((component = ConfigurationComponent.loadComponentFromFile(componentFile = (File)componentFiles.iterator().next(), ConfigurationComponent.LoadMode.STANDARD, null)) == null) {
                LOGGER.severe("[DATA] Component could not be loaded: " + componentFile);
            } else {
                result = new ConfigurationComponentTypeId(info, (IConfigurationComponent)component);
            }
        }
        boolean skipCheck = Boolean.parseBoolean(SWToolsProperties.getProperty((String)"com.nxp.swtools.periph.verify.ignore_typeid_type_match_check.disable", (String)"false"));
        if (result != null && SWToolsProperties.isVerificationOn() && !skipCheck) {
            if (result.getConfigurationComponent().isHidden()) {
                return result;
            }
            String componentDirName = info.getComponentDir().getName();
            if (result.getType().equals(componentDirName)) {
                return result;
            }
            int underscoreIndex = componentDirName.lastIndexOf("_");
            if (underscoreIndex == -1) {
                LOGGER.log(Level.SEVERE, "[DATA] Component with type_id: \"{0}\" does not contain undescore separator and does not match just the type either", result.getTypeId());
                return result;
            }
            String typeFromFolderName = componentDirName.substring(0, underscoreIndex);
            if (typeFromFolderName.equals(result.getType())) {
                return result;
            }
            String message = "[DATA] Component with type_id: \"{0}\" contains component with id \"{1}\" and id of component does not match with folder name";
            LOGGER.log(Level.SEVERE, MessageFormat.format(message, result.getTypeId(), result.getType()));
        }
        return result;
    }
}

