/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.ui.resources.fonts;

import com.nxp.s32ds.ext.rcp.ui.resources.fonts.FontUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class RcpUIFontRegistry {
    private static final String SEPARATOR = "-";
    private static final String PREFIX = "s32ds.ext.rcp.font.uid";
    private Map<String, String> fontId2uid = new ConcurrentHashMap<String, String>();

    public Font getById(String id) {
        String uid = this.fontId2uid.get(id);
        if (uid != null) {
            return JFaceResources.getFontRegistry().get(uid);
        }
        return null;
    }

    public Font getBold(Font font) {
        String uid = this.registerFont(null, font);
        return JFaceResources.getFontRegistry().getBold(uid);
    }

    public Font getItalic(Font font) {
        String uid = this.registerFont(null, font);
        return JFaceResources.getFontRegistry().getItalic(uid);
    }

    public Font getFont(Font base, int newHeight) {
        this.registerFont(null, base);
        FontData fontData = base.getFontData()[0];
        String uid = RcpUIFontRegistry.calculateFontUid(fontData.getName(), newHeight);
        if (!this.isFontRegistered(uid)) {
            this.registerFont(uid, FontUtils.createFont(fontData.getName(), newHeight, fontData.getStyle()));
        }
        return JFaceResources.getFontRegistry().get(uid);
    }

    public void addFont(String id, Font font) {
        this.registerFont(id, font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String registerFont(String id, Font font) {
        String uid = RcpUIFontRegistry.getFontUid(font);
        if (!this.isFontRegistered(uid)) {
            RcpUIFontRegistry rcpUIFontRegistry = this;
            synchronized (rcpUIFontRegistry) {
                if (!this.isFontRegistered(uid)) {
                    JFaceResources.getFontRegistry().put(uid, font.getFontData());
                    String key = id != null ? id : uid;
                    this.fontId2uid.put(key, uid);
                }
            }
        }
        return uid;
    }

    private boolean isFontRegistered(String uid) {
        return this.fontId2uid.containsValue(uid);
    }

    private static String getFontUid(Font font) {
        FontData fontData = font.getFontData()[0];
        return RcpUIFontRegistry.calculateFontUid(fontData.getName(), fontData.getHeight());
    }

    private static String calculateFontUid(String name, int height) {
        return "s32ds.ext.rcp.font.uid-" + name + SEPARATOR + height;
    }
}

