/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.lang.registry.core;

import com.nxp.s32ds.cle.runtime.lang.intrernal.registry.core.LangRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.lang.registry.HardwareLangDescriptor;
import com.nxp.s32ds.cle.runtime.lang.registry.LangDescriptor;
import com.nxp.s32ds.cle.runtime.lang.registry.LangRegistry;
import java.util.List;

public class LangDescriptors {
    private LangDescriptors() {
    }

    public static LangRegistry getLangRegistry() {
        return LangRegistryCoreActivator.getInstance().getLangRegistry();
    }

    public static void addLangDescriptor(LangDescriptor descriptor) {
        LangDescriptors.getLangRegistry().addLangDescriptor(descriptor);
    }

    public static List<LangDescriptor> getLangDescriptors() {
        return LangDescriptors.getLangRegistry().getLangDescriptors();
    }

    public static LangDescriptor getLangDescriptorById(String id) {
        return LangDescriptors.getLangRegistry().getLangDescriptor(id);
    }

    public static void removeLangDescriptor(LangDescriptor descriptor) {
        LangDescriptors.getLangRegistry().removeLangDescriptor(descriptor);
    }

    public static void addHardwareLangDescriptor(HardwareLangDescriptor descriptor) {
        LangDescriptors.getLangRegistry().addHardwareLangDescriptor(descriptor);
    }

    public static List<HardwareLangDescriptor> getHardwareLangDescriptors() {
        return LangDescriptors.getLangRegistry().getHardwareLangDescriptors();
    }

    public static HardwareLangDescriptor getHardwareLangDescriptorByDeviceId(String deviceId) {
        return LangDescriptors.getHardwareLangDescriptors().stream().filter(descriptor -> descriptor.getDeviceId().equals(deviceId)).findFirst().orElse(null);
    }

    public static HardwareLangDescriptor getHardwareLangDescriptorByDeviceCoreId(String deviceCoreId) {
        return LangDescriptors.getHardwareLangDescriptors().stream().filter(descriptor -> descriptor.getDeviceCoreId().equals(deviceCoreId)).findFirst().orElse(null);
    }

    public static HardwareLangDescriptor getHardwareLangDescriptorByCoreId(String coreId) {
        return LangDescriptors.getHardwareLangDescriptors().stream().filter(descriptor -> descriptor.getCoreId().equals(coreId)).findFirst().orElse(null);
    }

    public static void removeHardwareLangDescriptor(HardwareLangDescriptor descriptor) {
        LangDescriptors.getLangRegistry().removeHardwareLangDescriptor(descriptor);
    }
}

