/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.toolchainproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectChangeListener;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectInfo;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;

@NonNullByDefault
public interface IToolchainProjectWithSdk
extends IToolchainProjectInfo {
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$nxp$swtools$provider$toolchainproject$IToolchainProjectWithSdk$SecureProjectType;

    public static @Nullable SecureProjectType reverseSecurity(@Nullable SecureProjectType currentSecurity) {
        if (currentSecurity == null) {
            return null;
        }
        switch (currentSecurity) {
            case SECURE: {
                return SecureProjectType.NON_SECURE;
            }
            case NON_SECURE: {
                return SecureProjectType.SECURE;
            }
        }
        return null;
    }

    default public String getProjectReference() {
        String path = this.getProjectRoot().toString();
        return path.isEmpty() ? this.getProjectName() : path;
    }

    default public boolean wasProjectDetected() {
        return this.getToolchain() != null;
    }

    public @Nullable String getProjectDetectionProblem();

    public @Nullable String getToolchainId();

    public @Nullable String getToolchain();

    public @Nullable ISdkComponentInProject getSdkComponent(String var1);

    default public List<@NonNull ISdkComponentInProject> getAllSdkComponents() {
        return CollectionsUtils.emptyUnmodifiableList();
    }

    default public boolean isGetAllSdkComponentsSupported() {
        return false;
    }

    public @Nullable String getSdkVersion();

    public @Nullable String getProcessor();

    public @Nullable String getPartNumber();

    public @Nullable String getCoreId();

    public List<@NonNull Path> getIncludePaths();

    public boolean canAddAdditionalComponents();

    public boolean addComponent(String var1);

    public boolean addComponents(List<@NonNull String> var1);

    public void addChangeListener(IToolchainProjectChangeListener var1);

    public void removeChangeListener(IToolchainProjectChangeListener var1);

    public boolean isProjectAccessible();

    public void close();

    public @Nullable IProject getEclipseProject();

    default public boolean existsProcessor(String processor) {
        String sdkVersion = SWToolsPlatform.getSdkVersionForProcessor(processor);
        return KExProcessorsProvider.checkOrDownloadProcessor(processor, sdkVersion, false).isProcessorPresent();
    }

    default public void logProblemsInSdkComponentDetection() {
    }

    public Collection<@NonNull ISdkComponentInProject> getRteComponents();

    public boolean deleteFile(Path var1);

    public boolean deleteFileSafe(Path var1);

    default public void updateProjectSettings(ISharedConfiguration shrdConfig, @Nullable Collection<@NonNull String> updatedFiles) {
    }

    public SecureProjectType getSecureProjectType();

    default public boolean openSdkComponentsManager() {
        return false;
    }

    default public boolean canOpenSdkComponentManager() {
        return false;
    }

    public static enum SecureProjectType {
        SECURE,
        NON_SECURE,
        NONE,
        NOT_DETECTED;

    }
}

