/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.processors;

import com.nxp.swtools.common.ui.utils.Messages;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.api.IProcessorInfo;
import com.nxp.swtools.provider.processors.DownloadStatus;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DataUpdater {
    static Logger LOGGER = LogManager.getLogger(DataUpdater.class);

    public static void updateAllData(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(Messages.get().KExProgressMonitorDialog_DownloadingProcessor, 100);
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        SubMonitor subP = subMonitor.newChild(65, 0);
        ArrayList<IProcessorInfo> processors = new ArrayList<IProcessorInfo>(KExProcessorsProvider.listProcessors());
        if (processors.isEmpty()) {
            processors.addAll(KExProcessorsProvider.listProcessors());
        }
        derivatives.getAllProcessorMasterToolInfos().forEach(proc -> {
            LOGGER.fine("Updating processor " + proc.getId());
            DownloadStatus status = DataUpdater.tryDownload(() -> KExProcessorsProvider.downloadOrUpdateProcessor(proc.getId(), proc.getSWToolsDataFolderID(), processors, (IProgressMonitor)subP));
            if (status.isErrorOrCancelled() || status == DownloadStatus.NOT_FOUND) {
                LOGGER.severe("Updating processor failed: " + proc.getId());
            }
        });
        SubMonitor subB = subMonitor.newChild(20, 0);
        assert (subB != null);
        derivatives.getAllBoardsInfos().forEach(brd -> {
            LOGGER.fine("Updating board " + brd.getId());
            DownloadStatus status = DataUpdater.tryDownload(() -> KExProcessorsProvider.downloadOrUpdateBoard(brd.getId(), brd.getSWToolsDataFolderID(), (IProgressMonitor)subB));
            if (status.isErrorOrCancelled() || status == DownloadStatus.NOT_FOUND) {
                LOGGER.severe("Updating board failed: " + brd.getId());
            }
        });
        SubMonitor subK = subMonitor.newChild(5, 0);
        assert (subK != null);
        derivatives.getAllKitsInfos().forEach(kit -> {
            LOGGER.fine("Updating kit " + kit.getId());
            DownloadStatus status = DataUpdater.tryDownload(() -> KExProcessorsProvider.downloadOrUpdateKit(kit.getId(), kit.getSWToolsDataFolderID(), (IProgressMonitor)subK));
            if (status.isErrorOrCancelled() || status == DownloadStatus.NOT_FOUND) {
                LOGGER.severe("Updating kit failed: " + kit.getId());
            }
        });
        derivatives.refreshSupportedDerivatives();
        SubMonitor subC = subMonitor.newChild(10, 0);
        assert (subC != null);
        for (String sdkVersion : derivatives.getAllSwtoolsFolderIDs()) {
            LOGGER.fine("updating coomponents for SDK: " + sdkVersion);
            DownloadStatus status = DataUpdater.tryDownload(() -> KExProcessorsProvider.downloadOrUpdateComponents(sdkVersion, null, (IProgressMonitor)subC));
            if (!status.isErrorOrCancelled() && status != DownloadStatus.NOT_FOUND) continue;
            LOGGER.severe("Updating components failed for SDK: " + sdkVersion);
        }
    }

    private static DownloadStatus tryDownload(Supplier<DownloadStatus> action) {
        int tries = 3;
        DownloadStatus status = DownloadStatus.NOT_FOUND;
        while (tries-- > 0) {
            status = action.get();
            if (status.isCurrentOrUpdated()) break;
        }
        return status;
    }
}

