/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeBaseMemoryRegionConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(strict=false, name="region")
public class StorageTeeMemoryRegionConfig
extends StorageTeeBaseMemoryRegionConfig {
    public static final String REGION_ID = "region";
    private static final String SECURITY_LEVEL_ID = "security";
    private static final String ACCESS_TEMPLATE_ID = "template";
    private static final String DOMAIN_TEMPLATE_ID = "domain_templates";
    @Attribute(name="security")
    private String security = "";
    @Attribute(name="template", required=false)
    @Nullable
    private @Attribute(name="template", required=false) @Nullable String template;
    @Attribute(name="domain_templates", required=false)
    @Nullable
    private @Attribute(name="domain_templates", required=false) @Nullable String domainTemplates;

    public StorageTeeMemoryRegionConfig(BigInteger start, BigInteger size, String security) {
        this(start, size, security, null);
    }

    public StorageTeeMemoryRegionConfig(BigInteger start, BigInteger size, String security, @Nullable String accessTemplate) {
        this.start = start;
        this.size = size;
        this.security = security;
        this.template = accessTemplate;
    }

    public StorageTeeMemoryRegionConfig() {
    }

    public String getSecurity() {
        return this.security;
    }

    public void setSecurity(String security) {
        this.security = security;
    }

    public @Nullable String getTemplate() {
        return this.template;
    }

    public void setTemplate(@Nullable String templateRef) {
        this.template = templateRef;
    }

    public @Nullable String getDomainTemplates() {
        return this.domainTemplates;
    }

    public void setDomainTemplates(@Nullable String domainTemplates) {
        this.domainTemplates = domainTemplates;
    }

    @Override
    protected String getYamlId() {
        return REGION_ID;
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue(SECURITY_LEVEL_ID, this.getSecurity()));
        if (this.template != null) {
            storable.add((IYamlStorable)new YamlStorableValue(ACCESS_TEMPLATE_ID, this.template));
        }
        if (this.domainTemplates != null) {
            storable.add((IYamlStorable)new YamlStorableValue(DOMAIN_TEMPLATE_ID, this.domainTemplates));
        }
        storable.addAll(super.createYamlStorable());
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        String securityLoc = "";
        String templateLoc = null;
        String domainTemplateLoc = null;
        for (IYamlStorable childYaml : children) {
            if (!(childYaml instanceof YamlStorableValue)) continue;
            if (childYaml.getYamlId().equals(SECURITY_LEVEL_ID)) {
                securityLoc = childYaml.getYamlValue();
                continue;
            }
            if (childYaml.getYamlId().equals(ACCESS_TEMPLATE_ID)) {
                templateLoc = childYaml.getYamlValue();
                continue;
            }
            if (!childYaml.getYamlId().equals(DOMAIN_TEMPLATE_ID)) continue;
            domainTemplateLoc = childYaml.getYamlValue();
        }
        this.setSecurity(securityLoc);
        this.setTemplate(templateLoc);
        this.setDomainTemplates(domainTemplateLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.security, this.template);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeMemoryRegionConfig other = (StorageTeeMemoryRegionConfig)obj;
        return Objects.equals(this.security, other.security) && Objects.equals(this.template, other.template);
    }
}

