/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.tee.AccessType;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(strict=false)
@Order(attributes={"read", "write", "execute", "security_level", "region"})
public abstract class AStorageTeeRwxAccessRule {
    private static final String READ_ID = "read";
    private static final String SECURITY_LEVEL_ID = "security_level";
    private static final String WRITE_ID = "write";
    private static final String EXECUTE_ID = "execute";
    private static final String REGION_ID = "region";
    @Nullable
    private String securityLevel;
    private AccessType read = AccessType.BLOCK;
    private AccessType write = AccessType.BLOCK;
    @Nullable
    private AccessType execute;
    @Nullable
    private Boolean region;

    public AStorageTeeRwxAccessRule() {
    }

    public AStorageTeeRwxAccessRule(@Nullable String securityLevel) {
        this.securityLevel = securityLevel;
    }

    @Attribute(name="security_level", required=false)
    public void setSecurityLevelString(@Nullable String securityLevelString) {
        this.securityLevel = securityLevelString;
    }

    @Attribute(name="security_level", required=false)
    public @Attribute(name="security_level", required=false) @Nullable String getSecurityLevelString() {
        return this.securityLevel;
    }

    @Attribute(name="read", required=true)
    public void setReadString(String readString) {
        this.read = AccessType.valueOf(readString);
    }

    @Attribute(name="read", required=true)
    public @Attribute(name="read", required=true) String getReadString() {
        return this.read.name();
    }

    @Attribute(name="write", required=true)
    public void setWriteString(String writeString) {
        this.write = AccessType.valueOf(writeString);
    }

    @Attribute(name="write", required=true)
    public @Attribute(name="write", required=true) String getWriteString() {
        return this.write.name();
    }

    @Attribute(name="execute", required=false)
    public void setExecuteString(@Nullable String executeString) {
        this.execute = executeString != null ? AccessType.valueOf(executeString) : null;
    }

    @Attribute(name="execute", required=false)
    public @Attribute(name="execute", required=false) String getExecuteString() {
        return this.execute != null ? this.execute.name() : AccessType.BLOCK.name();
    }

    @Attribute(name="region", required=false)
    public void setRegionString(@Nullable String regionString) {
        this.region = regionString != null ? Boolean.valueOf(regionString) : null;
    }

    @Attribute(name="region", required=false)
    public @Attribute(name="region", required=false) @Nullable String getRegionString() {
        return this.region != null ? this.region.toString() : null;
    }

    public void setReadByAbbreviation(String abbreviation) {
        AccessType readAccess = AccessType.findBy(abbreviation);
        if (readAccess != null) {
            this.read = readAccess;
        }
    }

    public void setWriteByAbbreviation(String abbreviation) {
        AccessType writeAccess = AccessType.findBy(abbreviation);
        if (writeAccess != null) {
            this.write = writeAccess;
        }
    }

    public void setExecuteByAbbreviation(String abbreviation) {
        AccessType executeAccess = AccessType.findBy(abbreviation);
        if (executeAccess != null) {
            this.execute = executeAccess;
        }
    }

    public void setRead(AccessType read) {
        this.read = read;
    }

    public AccessType getRead() {
        return this.read;
    }

    public AccessType getWrite() {
        return this.write;
    }

    public @Nullable AccessType getExecute() {
        return this.execute;
    }

    public void setWrite(AccessType write) {
        this.write = write;
    }

    public void setExecute(@Nullable AccessType execute) {
        this.execute = execute;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.securityLevel, this.execute, this.read, this.write, this.region});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AStorageTeeRwxAccessRule other = (AStorageTeeRwxAccessRule)obj;
        return Objects.equals(this.securityLevel, other.securityLevel) && Objects.equals((Object)this.execute, (Object)other.execute) && Objects.equals((Object)this.read, (Object)other.read) && Objects.equals((Object)this.write, (Object)other.write) && Objects.equals(this.region, other.region);
    }

    public String toString() {
        return String.format("%s [securityLevel=%s, read=%s, write=%s, execute=%s]", this.getClass().getSimpleName(), this.getSecurityLevelString(), this.getReadString(), this.getWriteString(), this.getExecuteString());
    }
}

