/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.projectgenerator;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.ComponentType;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;

public class StorageProjectGeneratorComponentSet {
    static final long serialVersionUID = 1L;
    @Attribute(name="type")
    @NonNull
    @Attribute(name="type") @NonNull String typeSerialization = ComponentType.DRIVER.getId();
    @NonNull
    ComponentType type;
    @Attribute(name="selection")
    @NonNull
    @Attribute(name="selection") @NonNull String selectionSerialization = ComponentSelection.ALL.getSelection();
    @NonNull
    ComponentSelection selection;
    @ElementList(entry="component", inline=true, required=false)
    @NonNull
    private @ElementList(entry="component", inline=true, required=false) @NonNull List<@NonNull String> components = new ArrayList<String>();

    public StorageProjectGeneratorComponentSet() {
        this(ComponentType.DRIVER);
    }

    public StorageProjectGeneratorComponentSet(@NonNull ComponentType type) {
        this.type = type;
        this.setType(type);
        this.selection = type.getDefaultSelection();
    }

    @Commit
    public void commit() {
        this.type = ComponentType.fromString(this.typeSerialization);
        this.selection = ComponentSelection.fromString(this.selectionSerialization);
    }

    @Persist
    public void prepare() {
        this.typeSerialization = this.type.getId();
        this.selectionSerialization = this.selection.getSelection();
    }

    public @NonNull ComponentType getType() {
        return this.type;
    }

    public void setType(@NonNull ComponentType type) {
        this.type = type;
    }

    public @NonNull ComponentSelection getSelection() {
        return this.selection;
    }

    public void setSelection(@NonNull ComponentSelection selection) {
        this.selection = selection;
    }

    public @NonNull List<@NonNull String> getComponents() {
        return this.components;
    }

    public void setComponents(@NonNull List<@NonNull String> components) {
        assert (components.isEmpty() || this.selection.equals((Object)ComponentSelection.CUSTOM));
        this.components = components;
    }

    public String toString() {
        return "StorageProjectGeneratorComponentSet [type=" + (Object)((Object)this.type) + ", selection=" + (Object)((Object)this.selection) + ", components=" + this.components + "]";
    }

    public static final class ComponentSelection
    extends Enum<ComponentSelection> {
        public static final /* enum */ ComponentSelection ALL = new ComponentSelection("all");
        public static final /* enum */ ComponentSelection NONE = new ComponentSelection("none");
        public static final /* enum */ ComponentSelection CUSTOM = new ComponentSelection("custom");
        @NonNull
        private final String selection;
        private static final /* synthetic */ ComponentSelection[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ComponentSelection[]{ALL, NONE, CUSTOM};
        }

        private ComponentSelection(String selection) {
            this.selection = selection;
        }

        public @NonNull String getSelection() {
            return this.selection;
        }

        public static @NonNull ComponentSelection fromString(@NonNull String selection) {
            ComponentSelection[] componentSelectionArray = ComponentSelection.values();
            int n = componentSelectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentSelection t = componentSelectionArray[n2];
                if (t.getSelection().equals(selection)) {
                    return t;
                }
                ++n2;
            }
            assert (false);
            return CUSTOM;
        }

        public static ComponentSelection[] values() {
            ComponentSelection[] componentSelectionArray = ENUM$VALUES;
            int n = componentSelectionArray.length;
            ComponentSelection[] componentSelectionArray2 = new ComponentSelection[n];
            System.arraycopy(ENUM$VALUES, 0, componentSelectionArray2, 0, n);
            return componentSelectionArray2;
        }

        public static ComponentSelection valueOf(String string) {
            return Enum.valueOf(ComponentSelection.class, string);
        }
    }
}

